<?php


namespace App\Traits;

use Carbon\Carbon;

trait FormatDates
{
    protected $newDateFormat = 'M d, Y';

    public function initialVal()
    {
        return $this->newDateFormat = env("DATE_FORMAT");
    }

    public function getCreatedAtDateAttribute()
    {
        return Carbon::parse($this->created_at)->format($this->initialVal());
    }

    public function getUpdatedAtDateAttribute()
    {
        return Carbon::parse($this->updated_at)->diffForHumans();
    }
}
