<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTasksReportsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('task_reports', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('data_sheet_id')->unsigned();
            $table->foreign('data_sheet_id')
                ->references('id')->on('data_sheets')->onDelete('cascade');
            $table->bigInteger('staff_id')->unsigned();
            $table->foreign('staff_id')
                ->references('id')->on('users')->onDelete('cascade');
            $table->bigInteger('client_id')->unsigned();
            $table->foreign('client_id')
                ->references('id')->on('users')->onDelete('cascade');
            $table->text('additional_message')->nullable();
            $table->text('progress_note');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('task_reports');
    }
}
