<?php $__env->startSection('title', 'View User'); ?>

<?php $__env->startSection('headSource'); ?>
    <link rel="stylesheet" href="<?php echo asset('admin-assets/vendor/select2/css/select2.min.css'); ?>">
    <link href="<?php echo asset('admin-assets/vendor/bootstrap-select/dist/css/bootstrap-select.min.css'); ?>"
          rel="stylesheet">
    <!-- Datatable -->
    <link rel="stylesheet" href="<?php echo asset('admin-assets/vendor/datatables/css/jquery.dataTables.min.css'); ?>">
<?php $__env->stopSection(); ?>
<style>
    fieldset {
        padding: 1px 15px 10px !important;
        border: 1px solid #ced4da !important;
        margin-bottom: 15px !important;
    }

    legend {
        width: auto !important;
        padding: 0 10px !important;
        font-weight: 400;
    }

    fieldset input[type="checkbox"] {
        float: right;
        margin-top: 5px;
        margin-right: 15px;
    }

    fieldset label {
        margin-bottom: 0px;
    }
</style>
<?php $__env->startSection('content'); ?>

    <div class="row page-titles mx-0">
        <div class="col-sm-6 p-md-0">
            <div class="welcome-text">
                <h4>Role Grant Access</h4>
            </div>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('portal.dashboard')); ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route('portal.userFilterList', ["type" => $type])); ?>">Users</a>
                </li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Permissions</a></li>
            </ol>
        </div>
    </div>
    <div class="row">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">
                    <div class="profile-tab">
                        <div class="custom-tab-1">
                            <div class="tab-content">
                                <div id="aboutTab" class="tab-pane fade active show">
                                    <div class="profile-personal-info">
                                        <form id="userPermissions" method="post">
                                            <p style="width:300px">Role:
                                                <select id="roleChanger" class="form-control form-control-lg"
                                                        name="role">
                                                    <option value="SuperAdmin"
                                                            <?php if($type=='SuperAdmin'): ?> selected="selected" <?php endif; ?>>Super
                                                        Admin
                                                    </option>
                                                    <option value="Coordinator"
                                                            <?php if($type==='Coordinator'): ?> selected="selected" <?php endif; ?>
                                                    >Coordinator
                                                    </option>
                                                    <option value="Executive"
                                                            <?php if($type=='Executive'): ?> selected="selected" <?php endif; ?>>Executive
                                                    </option>
                                                    <option value="Manager"
                                                            <?php if($type==='Manager'): ?> selected="selected" <?php endif; ?>>Manager
                                                    </option>
                                                    <option value="Admin"
                                                            <?php if($type=='Admin'): ?> selected="selected" <?php endif; ?>>Admin
                                                    </option>
                                                    <option value="Staff"
                                                            <?php if($type=='Staff'): ?> selected="selected" <?php endif; ?>>Staff
                                                    </option>
                                                    <option value="Client"
                                                            <?php if($type=='Client'): ?> selected="selected" <?php endif; ?>>Client
                                                    </option>
                                                </select></p>
                                            <fieldset class="mb-4 mt-4">
                                                <legend><h4 class="text-primary">User Roles Management</h4></legend>
                                                <div class="row">
                                                    <div class="col-sm-6">
                                                        <fieldset>
                                                            <legend><h5 class="text-primary">Super Admin</h5></legend>
                                                            <div class="row">
                                                                <div class="col-sm-4">
                                                                    <label for="addSuperAdmin">Add</label> <input
                                                                        id="addSuperAdmin" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="addUser_superadmin" <?php echo e(isPermission('addUser_superadmin', $type) ? 'checked' : ''); ?>>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="editSuperAdmin">Edit</label> <input
                                                                        id="editSuperAdmin" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="editUser_superadmin" <?php echo e(isPermission('editUser_superadmin', $type) ? 'checked' : ''); ?>>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="viewSuperAdmin">View</label> <input
                                                                        id="viewSuperAdmin" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="viewUser_superadmin" <?php echo e(isPermission('viewUser_superadmin', $type) ? 'checked' : ''); ?>>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="deleteSuperAdmin">Delete</label> <input
                                                                        id="deleteSuperAdmin" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="deleteUser_superadmin" <?php echo e(isPermission('deleteUser_superadmin', $type) ? 'checked' : ''); ?>>
                                                                </div>
                                                                <div class="col-sm-8">
                                                                    <label for="deactivateSuperAdmin">Deactivate</label>
                                                                    <input id="deactivateSuperAdmin" type="checkbox"
                                                                           name="user_permissions[]"
                                                                           value="deactivateUser_superadmin" <?php echo e(isPermission('deactivateUser_superadmin', $type) ? 'checked' : ''); ?>>
                                                                </div>
                                                            </div>
                                                        </fieldset>
                                                    </div>
                                                    <div class="col-sm-6">
                                                        <fieldset>
                                                            <legend><h5 class="text-primary">Coordinator</h5></legend>
                                                            <div class="row">
                                                                <div class="col-sm-4">
                                                                    <label for="addCoordinator">Add</label> <input
                                                                        id="addCoordinator" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="addUser_coordinator" <?php echo e(isPermission('addUser_coordinator', $type) ? 'checked' : ''); ?>>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="editCoordinator">Edit</label> <input
                                                                        id="editCoordinator" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="editUser_coordinator" <?php echo e(isPermission('editUser_coordinator', $type) ? 'checked' : ''); ?>>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="viewCoordinator">View</label> <input
                                                                        id="viewCoordinator" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="viewUser_coordinator" <?php echo e(isPermission('viewUser_coordinator', $type) ? 'checked' : ''); ?>>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="deleteCoordinator">Delete</label> <input
                                                                        id="deleteCoordinator" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="deleteUser_coordinator" <?php echo e(isPermission('deleteUser_coordinator', $type) ? 'checked' : ''); ?>>
                                                                </div>
                                                                <div class="col-sm-8">
                                                                    <label
                                                                        for="deactivateCoordinator">Deactivate</label>
                                                                    <input id="deactivateCoordinator" type="checkbox"
                                                                           name="user_permissions[]"
                                                                           value="deactivateUser_coordinator" <?php echo e(isPermission('deactivateUser_coordinator', $type) ? 'checked' : ''); ?>>
                                                                </div>
                                                            </div>
                                                        </fieldset>
                                                    </div>
                                                    <div class="col-sm-6">
                                                        <fieldset>
                                                            <legend><h5 class="text-primary">Executive</h5></legend>
                                                            <div class="row">
                                                                <div class="col-sm-4">
                                                                    <label for="addExecutive">Add</label> <input
                                                                        id="addExecutive" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="addUser_executive" <?php echo e(isPermission('addUser_executive', $type) ? 'checked' : ''); ?>>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="editExecutive">Edit</label> <input
                                                                        id="editExecutive" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="editUser_executive" <?php echo e(isPermission('editUser_executive', $type) ? 'checked' : ''); ?>>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="viewExecutive">View</label> <input
                                                                        id="viewExecutive" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="viewUser_executive" <?php echo e(isPermission('viewUser_executive', $type) ? 'checked' : ''); ?>>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="deleteExecutive">Delete</label> <input
                                                                        id="deleteExecutive" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="deleteUser_executive" <?php echo e(isPermission('deleteUser_executive', $type) ? 'checked' : ''); ?>>
                                                                </div>
                                                                <div class="col-sm-8">
                                                                    <label for="deactivateExecutive">Deactivate</label>
                                                                    <input id="deactivateExecutive" type="checkbox"
                                                                           name="user_permissions[]"
                                                                           value="deactivateUser_executive" <?php echo e(isPermission('deactivateUser_executive', $type) ? 'checked' : ''); ?>>
                                                                </div>
                                                            </div>
                                                        </fieldset>
                                                    </div>
                                                    <div class="col-sm-6">
                                                        <fieldset>
                                                            <legend><h5 class="text-primary">Manager</h5></legend>
                                                            <div class="row">
                                                                <div class="col-sm-4">
                                                                    <label for="addManager">Add</label> <input
                                                                        id="addManager" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="addUser_manager" <?php echo e(isPermission('addUser_manager', $type) ? 'checked' : ''); ?>>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="editManager">Edit</label> <input
                                                                        id="editManager" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="editUser_manager" <?php echo e(isPermission('editUser_manager', $type) ? 'checked' : ''); ?>>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="viewManager">View</label> <input
                                                                        id="viewManager" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="viewUser_manager" <?php echo e(isPermission('viewUser_manager', $type) ? 'checked' : ''); ?>>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="deleteManager">Delete</label> <input
                                                                        id="deleteManager" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="deleteUser_manager" <?php echo e(isPermission('deleteUser_manager', $type) ? 'checked' : ''); ?>>
                                                                </div>
                                                                <div class="col-sm-8">
                                                                    <label for="deactivateManager">Deactivate</label>
                                                                    <input id="deactivateManager" type="checkbox"
                                                                           name="user_permissions[]"
                                                                           value="deactivateUser_manager" <?php echo e(isPermission('deactivateUser_manager', $type) ? 'checked' : ''); ?>>
                                                                </div>
                                                            </div>
                                                        </fieldset>
                                                    </div>
                                                    <div class="col-sm-6">
                                                        <fieldset>
                                                            <legend><h5 class="text-primary">Admin</h5></legend>
                                                            <div class="row">
                                                                <div class="col-sm-4">
                                                                    <label for="addAdmin">Add</label> <input
                                                                        id="addAdmin" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="addUser_admin" <?php echo e(isPermission('addUser_admin', $type) ? 'checked' : ''); ?>>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="editAdmin">Edit</label> <input
                                                                        id="editAdmin" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="editUser_admin" <?php echo e(isPermission('editUser_admin', $type) ? 'checked' : ''); ?>>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="viewAdmin">View</label> <input
                                                                        id="viewAdmin" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="viewUser_admin" <?php echo e(isPermission('viewUser_admin', $type) ? 'checked' : ''); ?>>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="deleteAdmin">Delete</label> <input
                                                                        id="deleteAdmin" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="deleteUser_admin" <?php echo e(isPermission('deleteUser_admin', $type) ? 'checked' : ''); ?>>
                                                                </div>
                                                                <div class="col-sm-8">
                                                                    <label for="deactivateAdmin">Deactivate</label>
                                                                    <input id="deactivateAdmin" type="checkbox"
                                                                           name="user_permissions[]"
                                                                           value="deactivateUser_admin" <?php echo e(isPermission('deactivateUser_admin', $type) ? 'checked' : ''); ?>>
                                                                </div>
                                                            </div>
                                                        </fieldset>
                                                    </div>
                                                    <div class="col-sm-6">
                                                        <fieldset>
                                                            <legend><h5 class="text-primary">Staff</h5></legend>
                                                            <div class="row">
                                                                <div class="col-sm-4">
                                                                    <label for="addStaff">Add</label> <input
                                                                        id="addStaff" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="addUser_staff" <?php echo e(isPermission('addUser_staff', $type) ? 'checked' : ''); ?>>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="editStaff">Edit</label> <input
                                                                        id="editStaff" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="editUser_staff" <?php echo e(isPermission('editUser_staff', $type) ? 'checked' : ''); ?>>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="viewStaff">View</label> <input
                                                                        id="viewStaff" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="viewUser_staff" <?php echo e(isPermission('viewUser_staff', $type) ? 'checked' : ''); ?>>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="deleteStaff">Delete</label> <input
                                                                        id="deleteStaff" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="deleteUser_staff" <?php echo e(isPermission('deleteUser_staff', $type) ? 'checked' : ''); ?>>
                                                                </div>
                                                                <div class="col-sm-8">
                                                                    <label for="deactivateStaff">Deactivate</label>
                                                                    <input id="deactivateStaff" type="checkbox"
                                                                           name="user_permissions[]"
                                                                           value="deactivateUser_staff" <?php echo e(isPermission('deactivateUser_staff', $type) ? 'checked' : ''); ?>>
                                                                </div>
                                                            </div>
                                                        </fieldset>
                                                    </div>
                                                    <div class="col-sm-6">
                                                        <fieldset>
                                                            <legend><h5 class="text-primary">Client</h5></legend>
                                                            <div class="row">
                                                                <div class="col-sm-4">
                                                                    <label for="addClient">Add</label> <input
                                                                        id="addClient" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="addUser_client" <?php echo e(isPermission('addUser_client', $type) ? 'checked' : ''); ?>>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="editClient">Edit</label> <input
                                                                        id="editClient" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="editUser_client" <?php echo e(isPermission('editUser_client', $type) ? 'checked' : ''); ?>>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="viewClient">View</label> <input
                                                                        id="viewClient" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="viewUser_client" <?php echo e(isPermission('viewUser_client', $type) ? 'checked' : ''); ?>>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="deleteClient">Delete</label> <input
                                                                        id="deleteClient" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="deleteUser_client" <?php echo e(isPermission('deleteUser_client', $type) ? 'checked' : ''); ?>>
                                                                </div>
                                                                <div class="col-sm-8">
                                                                    <label for="deactivateClient">Deactivate</label>
                                                                    <input id="deactivateClient" type="checkbox"
                                                                           name="user_permissions[]"
                                                                           value="deactivateUser_client" <?php echo e(isPermission('deactivateUser_client', $type) ? 'checked' : ''); ?>>
                                                                </div>
                                                            </div>
                                                        </fieldset>
                                                    </div>
                                                </div>
                                            </fieldset>
                                            <div class="row mb-4 mt-4">
                                                <div class="col-sm-6">
                                                    <fieldset class="mb-4 mt-4">
                                                        <legend><h4 class="text-primary">Task Sheets</h4></legend>
                                                        <div class="row">
                                                            <div class="col-sm-4">
                                                                <label for="addNewSheet">Add</label> <input
                                                                    id="addNewSheet" type="checkbox"
                                                                    name="user_permissions[]"
                                                                    value="addNewSheet_<?php echo e($type); ?>" <?php echo e(isPermission('addNewSheet_'.$type, $type) ? 'checked' : ''); ?>>
                                                            </div>
                                                            <div class="col-sm-4">
                                                                <label for="editSheet">Edit</label> <input
                                                                    id="editSheet" type="checkbox"
                                                                    name="user_permissions[]"
                                                                    value="editSheet_<?php echo e($type); ?>" <?php echo e(isPermission('editSheet_'.$type, $type) ? 'checked' : ''); ?>>
                                                            </div>
                                                            <div class="col-sm-4">
                                                                <label for="viewSheetUser">View</label> <input
                                                                    id="viewSheetUser" type="checkbox"
                                                                    name="user_permissions[]"
                                                                    value="viewSheetUser_<?php echo e($type); ?>" <?php echo e(isPermission('viewSheetUser_'.$type, $type) ? 'checked' : ''); ?>>
                                                            </div>
                                                            <div class="col-sm-4">
                                                                <label for="deleteSheet">Delete</label> <input
                                                                    id="deleteSheet" type="checkbox"
                                                                    name="user_permissions[]"
                                                                    value="deleteSheet_<?php echo e($type); ?>" <?php echo e(isPermission('deleteSheet_'.$type, $type) ? 'checked' : ''); ?>>
                                                            </div>
                                                            <div class="col-sm-8">
                                                                <label for="addAppSheet">Submit via app</label> <input
                                                                    id="addAppSheet" type="checkbox"
                                                                    name="user_permissions[]"
                                                                    value="addAppSheet_<?php echo e($type); ?>" <?php echo e(isPermission('addAppSheet_'.$type, $type) ? 'checked' : ''); ?>>
                                                            </div>
                                                        </div>
                                                    </fieldset>
                                                </div>
                                                <div class="col-sm-6">
                                                    <fieldset class="mb-4 mt-4">
                                                        <legend><h4 class="text-primary">Tasks</h4></legend>
                                                        <div class="row">
                                                            <div class="col-sm-6">
                                                                <label for="addTask">Add</label> <input id="addTask"
                                                                                                        type="checkbox"
                                                                                                        name="user_permissions[]"
                                                                                                        value="addTask_<?php echo e($type); ?>" <?php echo e(isPermission('addTask_'.$type, $type) ? 'checked' : ''); ?>>
                                                            </div>
                                                            <div class="col-sm-6">
                                                                <label for="editTask">Edit</label> <input id="editTask"
                                                                                                          type="checkbox"
                                                                                                          name="user_permissions[]"
                                                                                                          value="editTask_<?php echo e($type); ?>" <?php echo e(isPermission('editTask_'.$type, $type) ? 'checked' : ''); ?>>
                                                            </div>
                                                            <div class="col-sm-6">
                                                                <label for="viewTask">View</label> <input id="viewTask"
                                                                                                          type="checkbox"
                                                                                                          name="user_permissions[]"
                                                                                                          value="viewTask_<?php echo e($type); ?>" <?php echo e(isPermission('viewTask_'.$type, $type) ? 'checked' : ''); ?>>
                                                            </div>
                                                            <div class="col-sm-6">
                                                                <label for="deleteTask">Delete</label> <input
                                                                    id="deleteTask" type="checkbox"
                                                                    name="user_permissions[]"
                                                                    value="deleteTask_<?php echo e($type); ?>" <?php echo e(isPermission('deleteTask_'.$type, $type) ? 'checked' : ''); ?>>
                                                            </div>
                                                        </div>
                                                    </fieldset>
                                                </div>
                                            </div>



























































                                            <fieldset class="mb-4 mt-4">
                                                <legend><h4 class="text-primary">Others</h4></legend>
                                                <div class="row">
                                                    <div class="col-sm-6">
                                                        <label for="loginViaApp">Login via App?</label> <input
                                                            id="loginViaApp" type="checkbox" name="user_permissions[]"
                                                            value="loginViaApp_<?php echo e($type); ?>" <?php echo e(isPermission('loginViaApp_'.$type, $type) ? 'checked' : ''); ?>>
                                                    </div>
                                                </div>
                                            </fieldset>

                                            <fieldset class="mb-4 mt-4">
                                                <legend><h4 class="text-primary">Password</h4></legend>
                                                <div class="row">
                                                    <div class="col-sm-6">
                                                        <label for="password">Can Change Password?</label> <input
                                                            id="password" type="checkbox" name="user_permissions[]"
                                                            value="password_<?php echo e($type); ?>" <?php echo e(isPermission('password_'.$type, $type) ? 'checked' : ''); ?>>
                                                    </div>
                                                    <div class="col-sm-6">
                                                        <label for="passwordReset">Reset Password?</label> <input
                                                            id="passwordReset" type="checkbox" name="user_permissions[]"
                                                            value="passwordReset_<?php echo e($type); ?>" <?php echo e(isPermission('passwordReset_'.$type, $type) ? 'checked' : ''); ?>>
                                                    </div>
                                                </div>
                                            </fieldset>
                                            <input type="submit" class="btn btn-primary" name="submit" value="Save"/>
                                        </form>

                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footerSource'); ?>
    <!-- Daterangepicker -->
    <!-- momment js is must -->
    <script src="<?php echo asset('admin-assets/vendor/moment/moment.min.js'); ?>"></script>
    <script src="<?php echo asset('admin-assets/vendor/bootstrap-daterangepicker/daterangepicker.js'); ?>"></script>
    <script>


        $(document).ready(function () {


            $("#roleChanger").change(function (e) {
                let value = $(this).val();
                window.location = "<?php echo e(url("admin/dashboard/users/permissions")); ?>/" + $(this).val();
            });

            // add user form submit
            $("#userPermissions").submit(function (e) {
                e.preventDefault();
                let data = new FormData($(this)[0]);
                axios.post('<?php echo e(route("portal.addUserPermissions")); ?>', data)
                    .then(function (response) {
                        if (response.data.response_code == 1) {
                            successMsg(response.data.message);
                        } else {
                            errorMsg(response.data.message);
                        }
                    })
                    .catch(function (error) {

                    });
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/bbcareapp/resources/views/portal/users/permissions.blade.php ENDPATH**/ ?>