<?php

namespace App\Providers;

use Laravel\Passport\Passport;
use Illuminate\Support\Facades\Gate;
use App\Policies\SitePolicy;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The policy mappings for the application.
     *
     * @var array
     */
    protected $policies = [
        Site::class => SitePolicy::class,
    ];

    /**
     * Register any authentication / authorization services.
     *
     * @return void
     */
    public function boot()
    {
        $this->registerPolicies();



        Gate::define('admin/dashboard/users/filter/executive', function ($user,$role) {
            return $user->role == $role;
        });
        Gate::define('admin/dashboard/users/filter/admin', function ($user,$role) {
            return $user->role == $role;
        });
        Gate::define('admin/dashboard/users/filter/superadmin', function ($user,$role) {
            return $user->role == $role;
        });
    }


}
