<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name');
            $table->string('email')->unique();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('username')->unique();
            $table->string('password');
            $table->string('date_of_birth')->nullable();
            $table->enum('gender', ['Male', 'Female'])->default('Male');
            $table->string('address')->nullable();
            $table->string('emergency_contact')->nullable();
            $table->string('phone_number')->nullable();
            $table->string('employee_id')->nullable();
            $table->string('ddd_id')->nullable();
            $table->enum('role', ['Admin', 'Staff', 'Client'])->default('Staff');
            $table->string('thumbnail')->nullable();
            $table->enum('login_from', ['Android', 'IOS', 'Web'])->default('Web');
            $table->boolean('status')->default(1);
            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
