<?php $__env->startSection('title', 'Edit Sheet Task'); ?>

<?php $__env->startSection('headSource'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row page-titles mx-0">
        <div class="col-sm-6 p-md-0">
            <div class="welcome-text">
                <h4>Edit Task</h4>
            </div>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('portal.dashboard')); ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route('portal.dataSheetListPage')); ?>">Data Sheets</a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route('portal.viewDataSheetPage', ["id" => $record->data_sheet_id])); ?>">View Tasks</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Edit Task</a></li>
            </ol>
        </div>
    </div>

    <div class="row">
        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 col-xl-12">
            <div class="card mb-3">
                <div class="card-header">
                    <h3><i class="fa fa-list-alt"></i> Task detail</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-8">
                            <form id="sheetTaskEditForm" method="post">
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label>Title (required)</label>
                                            <textarea class="form-control" name="title" required><?php echo e($record->title); ?></textarea>
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label>Progress Note (required)</label>
                                            <textarea id="progressNote" class="form-control" name="progress_note" required><?php echo e($record->progress_note); ?></textarea>
                                        </div>
                                        <div class="mb-3">
                                            <span class="badge badge-secondary insertTag" data-toggle="tooltip" title="Jhon Doe" style="cursor: pointer;" data-tag="##ClientFullName##">##ClientFullName##</span>
                                            <span class="badge badge-secondary insertTag" data-toggle="tooltip" title="Jhon" style="cursor: pointer;" data-tag="##ClientFirstName##">##ClientFirstName##</span>
                                            <span class="badge badge-secondary insertTag" data-toggle="tooltip" title="He/She" style="cursor: pointer;" data-tag="##ClientGenderNoun##">##ClientGenderNoun##</span>
                                            <span class="badge badge-secondary insertTag" data-toggle="tooltip" title="Selected Answer" style="cursor: pointer;" data-tag="##AnswerPrompt##">##AnswerPrompt##</span>
                                        </div>
                                    </div>
                                    <div class="col-lg-12 mt-3">
                                        <div class="form-group">
                                            <label>Progress Note For Independent Prompt (required)</label>
                                            <textarea id="progressNoteIndependent" class="form-control" name="progress_note_independent" required><?php echo e($record->progress_note_independent); ?></textarea>
                                        </div>
                                        <div class="mb-3">
                                            <span class="badge badge-secondary insertTagInd" data-toggle="tooltip" title="Jhon Doe" style="cursor: pointer;" data-tag="##ClientFullName##">##ClientFullName##</span>
                                            <span class="badge badge-secondary insertTagInd" data-toggle="tooltip" title="Jhon" style="cursor: pointer;" data-tag="##ClientFirstName##">##ClientFirstName##</span>
                                            <span class="badge badge-secondary insertTagInd" data-toggle="tooltip" title="He/She" style="cursor: pointer;" data-tag="##ClientGenderNoun##">##ClientGenderNoun##</span>
                                            
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Status</label>
                                            <select class="form-control form-control-lg" name="status">
                                                <option value="1" <?php echo e(($record->status == 1)? "selected": ""); ?>>Active</option>
                                                <option value="0" <?php echo e(($record->status == 0)? "selected": ""); ?>>Inactive</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-12">
                                        <a href="<?php echo e(route('portal.viewDataSheetPage', ["id" => $record->data_sheet_id])); ?>" class="btn btn-secondary">Back To Task Sheet</a>
                                        <button type="submit" class="btn btn-primary">Update Task</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="col-lg-4">
                            
                            <label class="mt-4">Prompts</label>
                            <div class="basic-list-group">
                                <ul class="list-group">
                                    <?php $__currentLoopData = $record->answers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $answer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="list-group-item d-flex justify-content-between align-items-center">
                                            <?php echo e($answer->answer); ?> 
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- end card-body -->
            </div>
            <!-- end card -->
        </div>
        <!-- end col -->
    </div>
    <!-- end row -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footerSource'); ?>

<script>
    $(document).ready(function () {
        // insert tag in progress note
        $(".insertTag").click(function (e) {
            let tag = $(this).data("tag");
            let noteTxt = $("#progressNote").val();
            let upDateNoteTxt = noteTxt+' '+tag+' ';
            $("#progressNote").val(upDateNoteTxt);
        });
        $(".insertTagInd").click(function (e) {
            let tag = $(this).data("tag");
            let noteTxt = $("#progressNoteIndependent").val();
            let upDateNoteTxt = noteTxt+' '+tag+' ';
            $("#progressNoteIndependent").val(upDateNoteTxt);
        });
        // tooltip
        $('[data-toggle="tooltip"]').tooltip();

        // edit sheet task form submit
        $("#sheetTaskEditForm").submit(function (e) {
            e.preventDefault();
            let data = $(this).serialize()+"&id=<?php echo e($record->id); ?>";
            axios.put('<?php echo e(route("portal.updateSheetTaskRequest")); ?>', data)
                .then(function (response) {
                    if(response.data.response_code == 1){
                        successMsg(response.data.message);
                        setTimeout(function () {
                            location.reload();
                        }, 1000);
                    } else {
                        errorMsg(response.data.message);
                    }
                })
                .catch(function (error) {

                });
        });

        // add answer form submit
        $("#taskAnswerForm").submit(function (e) {
            e.preventDefault();
            let data = $(this).serialize()+"&id=<?php echo e($record->id); ?>";
            axios.post('<?php echo e(route("portal.addAnswerInTaskRequest")); ?>', data)
                .then(function (response) {
                    if(response.data.response_code == 1){
                        successMsg(response.data.message);
                        setTimeout(function () {
                            location.reload();
                        }, 1000);
                    } else {
                        errorMsg(response.data.message);
                    }
                })
                .catch(function (error) {

                });
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\health_app\resources\views/portal/dataSheets/sheetTasks/editSheetTask.blade.php ENDPATH**/ ?>