<?php $__env->startSection('title', 'Edit User'); ?>

<?php $__env->startSection('headSource'); ?>
    <!-- Daterange picker -->
    <link href="<?php echo asset('admin-assets/vendor/bootstrap-daterangepicker/daterangepicker.css'); ?>" rel="stylesheet">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row page-titles mx-0">
        <div class="col-sm-6 p-md-0">
            <div class="welcome-text">
                <h4> Edit <?php echo e($user->role); ?> </h4>
            </div>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('portal.dashboard')); ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route("portal.userFilterList")); ?>/<?php echo e(Session('type')); ?>">Users</a></li>
                <li class="breadcrumb-item"> <a href="<?php echo e(route("portal.userFilterList", ["type" => Session('type'),"id" => Session('branch')])); ?>">   <strong> <?php echo e($branchName); ?> </strong> <?php echo e($user->role); ?></a></li>

                <li class="breadcrumb-item active"><a href="javascript:void(0)">Edit <?php echo e($user->role); ?></a></li>
            </ol>
        </div>
    </div>

    <div class="row">
        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 col-xl-12">
            <div class="card mb-3">
                <div class="card-header">
                    <h3><i class="fa fa-user"></i> <?php echo e($user->role); ?> details</h3>
                </div>
                <div class="card-body">
                    <form id="userEditForm" method="post" enctype="multipart/form-data">
                        <input type="hidden" name="id" value="<?php echo e($user->id); ?>">
                        <div class="row">
                            <div class="col-lg-9 col-xl-9">
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Full name (required)</label>
                                            <input class="form-control" name="name" type="text" value="<?php echo e($user->name); ?>" required />
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Valid Email (required)</label>
                                            <input class="form-control" name="email" type="email" value="<?php echo e($user->email); ?>" required />
                                        </div>
                                    </div>
                                </div>
                                <div class="row" style="display:<?php echo e($user->role == 'Client'?'none;':''); ?>">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Username (required)</label>
                                            <input class="form-control" name="username" type="text" value="<?php echo e($user->username); ?>" required />
                                        </div>
                                    </div>

                                    <?php if(checkPermission('password',Auth::user()->role) || Auth::user()->role=='SuperAdmin'): ?>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Password (leave empty not to change) </label>
                                            <input class="form-control" name="password" type="password" />
                                        </div>
                                    </div>
                                    <?php endif; ?>
                                </div>
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Date Of Birth</label>
                                            <input class="form-control" name="date_of_birth" type="text" value="<?php echo e($user->date_of_birth); ?>" />
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Gender</label>
                                            <select class="form-control form-control-lg" name="gender">
                                                <option value="Male" <?php echo e(($user->gender == 'Male')? "selected": ""); ?>>Male</option>
                                                <option value="Female" <?php echo e(($user->gender == 'Female')? "selected": ""); ?>>Female</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label>Address</label>
                                            <input class="form-control" name="address" type="text" value="<?php echo e($user->address); ?>" />
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Phone Number</label>
                                            <input class="form-control" name="phone_number" type="text" value="<?php echo e($user->phone_number); ?>" />
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Emergency Phone Number</label>
                                            <input class="form-control" name="emergency_contact" type="text" value="<?php echo e($user->emergency_contact); ?>" />
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-6">
                                        <?php if($user->id != '1'): ?>
                                            <div class="form-group">
                                                <label>Status</label>
                                                <select class="form-control form-control-lg" name="status">
                                                    <option value="1" <?php echo e(($user->status == 1)? "selected": ""); ?>>Active</option>
                                                    <option value="0" <?php echo e(($user->status == 0)? "selected": ""); ?>>Inactive</option>
                                                </select>
                                            </div>
                                        <?php else: ?>
                                        <?php endif; ?>
                                    </div>
                                    <div class="col-lg-6">
                                        <?php if($user->role == "Staff"): ?>
                                            <div class="form-group">
                                                <label>Employee Id (required)</label>
                                                <input class="form-control" name="employee_id" type="text" value="<?php echo e($user->employee_id); ?>" required/>
                                            </div>
                                        <?php endif; ?>
                                        <?php if($user->role == "Client"): ?>
                                            <div class="form-group">
                                                <label>Identification Number  (required)</label>
                                                <input class="form-control" name="ddd_id" type="text" value="<?php echo e($user->ddd_id); ?>" required />
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-3 col-xl-3 border-left">
                                
                                <strong>Role</strong>: <?php echo e($user->role); ?>

                                <div class="mb-5"></div>
                                <div id="avatar_image">
                                    <img id="thumbnailImg" alt="image" style="max-width:100px; height:auto;" src="<?php echo $user->thumbnail; ?>" />
                                </div>
                                <div class="m-b-10"></div>
                                <div class="form-group">
                                    <label>Profile Image</label>
                                    <input type="file" name="thumbnail" class="form-control previewInput" data-target="#thumbnailImg">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <button type="submit" class="btn btn-primary">Update</button>
                            </div>
                        </div>
                    </form>
                </div>
                <!-- end card-body -->
            </div>
            <!-- end card -->
        </div>
        <!-- end col -->
    </div>
    <!-- end row -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footerSource'); ?>
    <!-- Daterangepicker -->
    <!-- momment js is must -->
    <script src="<?php echo asset('admin-assets/vendor/moment/moment.min.js'); ?>"></script>
    <script src="<?php echo asset('admin-assets/vendor/bootstrap-daterangepicker/daterangepicker.js'); ?>"></script>
    <script>
        $(document).ready(function () {
            // date picker
            $('input[name="date_of_birth"]').daterangepicker({
                singleDatePicker: true,
                showDropdowns: true
            });

            // edit user form submit
            $("#userEditForm").submit(function (e) {
                e.preventDefault();
                let data = new FormData($(this)[0]);
                axios.post('<?php echo e(route("portal.updateUserRequest")); ?>', data)
                    .then(function (response) {
                        if(response.data.response_code == 1){
                            successMsg(response.data.message);
                            setTimeout(function () {
                                location.reload();
                            }, 1000);
                        } else {
                            errorMsg(response.data.message);
                        }
                    })
                    .catch(function (error) {

                    });
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\health_app\resources\views/portal/users/editUser.blade.php ENDPATH**/ ?>