<?php $__env->startSection('title', 'View User'); ?>

<?php $__env->startSection('headSource'); ?>
    <link rel="stylesheet" href="<?php echo asset('admin-assets/vendor/select2/css/select2.min.css'); ?>">
    <link href="<?php echo asset('admin-assets/vendor/bootstrap-select/dist/css/bootstrap-select.min.css'); ?>" rel="stylesheet">
    <!-- Datatable -->
    <link rel="stylesheet" href="<?php echo asset('admin-assets/vendor/datatables/css/jquery.dataTables.min.css'); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row page-titles mx-0">
        <div class="col-sm-6 p-md-0">
            <div class="welcome-text">
                <h4>Role Grant Access</h4>
            </div>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('portal.dashboard')); ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route('portal.userFilterList', ["type" => $type])); ?>">Users</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Permissions</a></li>
            </ol>
        </div>
    </div>



    <div class="row">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">
                    <div class="profile-tab">
                        <div class="custom-tab-1">

                            <div class="tab-content">
                                <div id="aboutTab" class="tab-pane fade active show">
                                    <div class="profile-personal-info">
                                        <form id="userPermissions" method="post">
                                            <p style="width:300px">Role: <select id="roleChanger" class="form-control form-control-lg" name="role">
                                                    <option value="SuperAdmin" <?php if($type=='SuperAdmin'): ?> selected="selected" <?php endif; ?>>Super Admin</option>
                                                    <option value="Executive" <?php if($type=='Executive'): ?> selected="selected" <?php endif; ?>>Executive</option>
                                                    <option value="Admin" <?php if($type=='Admin'): ?> selected="selected" <?php endif; ?>>Admin</option>
                                                    <option value="Staff" <?php if($type=='Staff'): ?> selected="selected" <?php endif; ?>>Staff</option>
                                                    <option value="Client" <?php if($type=='Client'): ?> selected="selected" <?php endif; ?>>Client</option>
                                                </select></p>
                                        <h4 class="text-primary mb-4 mt-4">Users </h4>
                                        <div class="row mb-2" style="padding:15px">

                                            <table style="width:100%">
                                                <tr>
                                                    <th style="width:40%">Permission</th><th>Add</th><th>Update</th><th>View</th><th>Delete</th>
                                                </tr>
                                                <tr>
                                                    <td>Super Admin User</td>
                                                    <td>
                                                        <input type="checkbox" name="user_permissions[]" value="addUser_superadmin"  <?php echo e(isPermission('addUser_superadmin', $type) ? 'checked' : ''); ?>> </td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="editUser_superadmin" <?php echo e(isPermission('editUser_superadmin', $type) ? 'checked' : ''); ?>> </td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="viewUser_superadmin" <?php echo e(isPermission('viewUser_superadmin', $type) ? 'checked' : ''); ?>> </td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="deleteUser_superadmin" <?php echo e(isPermission('deleteUser_superadmin', $type) ? 'checked' : ''); ?>> </td>
                                                </tr>
                                                <tr>
                                                    <td>Executive User</td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="addUser_executive" <?php echo e(isPermission('addUser_executive', $type) ? 'checked' : ''); ?>> </td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="editUser_executive" <?php echo e(isPermission('editUser_executive', $type) ? 'checked' : ''); ?>> </td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="viewUser_executive" <?php echo e(isPermission('viewUser_executive', $type) ? 'checked' : ''); ?>> </td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="deleteUser_executive" <?php echo e(isPermission('deleteUser_executive', $type) ? 'checked' : ''); ?>> </td>
                                                </tr>
                                                <tr>
                                                    <td>Admin User</td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="addUser_admin" <?php echo e(isPermission('addUser_admin', $type) ? 'checked' : ''); ?>> </td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="editUser_admin" <?php echo e(isPermission('editUser_admin', $type) ? 'checked' : ''); ?>> </td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="viewUser_admin" <?php echo e(isPermission('viewUser_admin', $type) ? 'checked' : ''); ?>> </td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="deleteUser_admin" <?php echo e(isPermission('deleteUser_admin', $type) ? 'checked' : ''); ?>> </td>
                                                </tr>
                                                <tr>
                                                    <td>Staff User</td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="addUser_staff" <?php echo e(isPermission('addUser_staff', $type) ? 'checked' : ''); ?>> </td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="editUser_staff" <?php echo e(isPermission('editUser_staff', $type) ? 'checked' : ''); ?>> </td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="viewUser_staff" <?php echo e(isPermission('viewUser_staff', $type) ? 'checked' : ''); ?>> </td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="deleteUser_staff" <?php echo e(isPermission('deleteUser_staff', $type) ? 'checked' : ''); ?>> </td>
                                                </tr>
                                                <tr>
                                                    <td>Client User</td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="addUser_client" <?php echo e(isPermission('addUser_client', $type) ? 'checked' : ''); ?>> </td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="editUser_client" <?php echo e(isPermission('editUser_client', $type) ? 'checked' : ''); ?>> </td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="viewUser_client" <?php echo e(isPermission('viewUser_client', $type) ? 'checked' : ''); ?>> </td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="deleteUser_client" <?php echo e(isPermission('deleteUser_client', $type) ? 'checked' : ''); ?>> </td>
                                                </tr>
                                            </table>

                                        </div>
                                            <div style="height: 20px"></div>

                                        <h4 class="text-primary mb-4 mt-4">Task Sheets </h4>
                                        <div class="row mb-2" style="padding:15px">
                                            <table style="width:100%">
                                                <tr>
                                                    <th style="width:40%">Permission</th><th>Add</th><th>Update</th><th>View</th><th>Delete</th>
                                                </tr>
                                                <tr>
                                                    <td>Task Sheet</td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="addNewSheet_<?php echo e($type); ?>" <?php echo e(isPermission('addNewSheet_'.$type, $type) ? 'checked' : ''); ?>> </td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="editSheet_<?php echo e($type); ?>" <?php echo e(isPermission('editSheet_'.$type, $type) ? 'checked' : ''); ?>> </td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="viewSheetUser_<?php echo e($type); ?>" <?php echo e(isPermission('viewSheetUser_'.$type, $type) ? 'checked' : ''); ?>> </td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="deleteSheet_<?php echo e($type); ?>" <?php echo e(isPermission('deleteSheet_'.$type, $type) ? 'checked' : ''); ?>> </td>
                                                </tr>

                                            </table>


                                            <table style="width:100%">
                                                <tr>
                                                    <th style="width:40%">Permission</th><th>Add</th><th>Update</th><th>View</th><th>Delete</th>
                                                </tr>
                                                <tr>
                                                    <td>Tasks</td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="addTask_<?php echo e($type); ?>" <?php echo e(isPermission('addTask_'.$type, $type) ? 'checked' : ''); ?>> </td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="editTask_<?php echo e($type); ?>" <?php echo e(isPermission('editTask_'.$type, $type) ? 'checked' : ''); ?>> </td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="viewTask_<?php echo e($type); ?>" <?php echo e(isPermission('viewTask_'.$type, $type) ? 'checked' : ''); ?>> </td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="deleteTask_<?php echo e($type); ?>" <?php echo e(isPermission('deleteTask_'.$type, $type) ? 'checked' : ''); ?>> </td>
                                                </tr>

                                            </table>
                                        </div>
                                        <h4 class="text-primary mb-4 mt-4">Password </h4>
                                        <div class="row mb-2" style="padding:15px">
                                            <div style="height: 20px"></div>

                                            <table style="width:100%">
                                                <tr>
                                                    <td style="width:40%">Can Change Password?</td><td><input type="checkbox" name="user_permissions[]" value="password_<?php echo e($type); ?>" <?php echo e(isPermission('password_'.$type, $type) ? 'checked' : ''); ?>> </td>
                                                </tr>


                                            </table>

                                        </div>
                                        <input type="submit" class="btn btn-primary" name="submit" value="Save"/>
                                        </form>

                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footerSource'); ?>
    <!-- Daterangepicker -->
    <!-- momment js is must -->
    <script src="<?php echo asset('admin-assets/vendor/moment/moment.min.js'); ?>"></script>
    <script src="<?php echo asset('admin-assets/vendor/bootstrap-daterangepicker/daterangepicker.js'); ?>"></script>
    <script>


        $(document).ready(function () {


            $("#roleChanger").change(function(e){
               let value = $(this).val();
                window.location = "<?php echo e(url("admin/dashboard/users/permissions")); ?>/" + $(this).val();
            });

            // add user form submit
            $("#userPermissions").submit(function (e) {
                e.preventDefault();
                let data = new FormData($(this)[0]);
                axios.post('<?php echo e(route("portal.addUserPermissions")); ?>', data)
                    .then(function (response) {
                        if(response.data.response_code == 1){
                            successMsg(response.data.message);
                        } else {
                            errorMsg(response.data.message);
                        }
                    })
                    .catch(function (error) {

                    });
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\health_app\resources\views/portal/users/permissions.blade.php ENDPATH**/ ?>