<?php

use App\Notifications;
use App\Permission;
use Illuminate\Support\Facades\Auth;

    function checkPermission($access, $type)
    {
        if (null === Auth::check()) {
            return false;
        }

        $user_role = Auth::user()->role;
        if (!empty($type)) {
            $access = $access . '_' . $type;
        } else {
            $access = $access . '_' . strtolower($user_role);
        }
        //echo $access;


        $permission = Permission::where("role", $user_role)->where("role_key", $access)->count();
        if ($permission > 0) {
            return true;
        }
        return false;
    }

    function isPermission($permission, $role)
    {

        $is_permission = Permission::where('role', $role)->where('role_key', $permission)->count();

        if ($is_permission > 0) {
            return true;
        }
        return false;
    }

function sendEmail($data) {
    $postObj = new stdClass();
    $sendTo = [ (object) ['email' => $data['email']], (object)['email' => $data['coordinatorEmail']]];
    $sender = ['email' => 'info@bbcareadmin.com', 'name' => 'BBCareAdmin'] ;
    $postObj->from = (object) $sender;
    $postObj->to = $sendTo;
    $postObj->category = 'Integration Test';
    $postObj->subject = 'Task Submitted By ' . $data['submittedBy'];
    $postObj->html = emailHTML($data);
    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://send.api.mailtrap.io/api/send',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => json_encode($postObj),
        CURLOPT_HTTPHEADER => array(
            'Authorization: Bearer c8e9c96ac895bbf22a2f9537c7b091d7',
            'Content-Type: application/json'
        ),
    ));
    $response = curl_exec($curl);
    curl_close($curl);
    return $response;
}

function emailHTML($data) {
    $html = "<!DOCTYPE html>
        <html>
        <head>
            <title>Task Submitted</title>
        </head>
        <body>
        Hello <strong>".$data['name']."</strong> <br /><br />
        Task Submitted by <strong>".$data['submittedBy']."</strong> <br /><br />
        <strong>Client Name:</strong><br />".$data['clientName']." <br /><br />
        <strong>Sheet Name:</strong><br />".$data['SheetName']." <br /><br />
        <strong>Progress Note: </strong>".html_entity_decode($data['progressNote'])."
        <br /><br />
        Thanks<br /><br />
        BBCare
        </body>
        </html>";
    return $html;
}





