<?php

namespace App\Http\Controllers\ApiController\ClientController;

use App\Services\HelperServices;
use App\Services\UserService;
use App\Services\TaskReportService;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class DashboardController extends Controller
{
    // get client dashboard data
    public function clientDashboard(Request $request, UserService $userService, TaskReportService $reportService) {
        $clientId = $request->user()->id;
        $staffs = $userService->clientStaffListing($clientId);
        $whereCondition = ['client_id' => $clientId];
        $startDate = Carbon::now()->format('Y-m-d 00:00:00');
        $endDate = Carbon::now()->format('Y-m-d 23:59:59');
        $todayReportCount = $reportService->getTaskHistoryReportCount($startDate, $endDate, $whereCondition);
        $monthStartDate = Carbon::now()->startOfMonth()->format('Y-m-d 00:00:00');
        $monthlyReportCount = $reportService->getTaskHistoryReportCount($monthStartDate, $endDate, $whereCondition);
        return HelperServices::returnJsonResponse(1, 'Success', ['careGivers' => $staffs, 'taskReport' => ['today' => $todayReportCount, 'monthly' => $monthlyReportCount]]);
    }

    public function sheetReports(Request $request, TaskReportService $reportService) {
        return $reportService->getSheetReports($request, $request->user());
    }
}
