<?php

namespace App\Http\Controllers\ApiController\StaffController;

use App\Services\HelperServices;
use App\Services\TaskReportService;
use App\Services\UserService;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class DashboardController extends Controller
{
    // get profile detail
    public function profileDetail(UserService $userService){
        return $userService->getStaffProfile(request()->user());
    }

    // update user profile detail
    public function updateProfile(Request $request, UserService $userService){
        return $userService->staffProfileUpdate($request);
    }

    // update user profile image
    public function updateProfileImg(Request $request, UserService $userService){
        return $userService->updateProfileImg($request);
    }

    // get client listing of current staff
    public function staffClientListing(Request $request, UserService $userService, TaskReportService $reportService){
        $staffId = $request->user()->id;
        $clients = $userService->staffClientListing($request, $staffId, $request->type, false);
        $whereCondition = ['staff_id' => $staffId];
        $startDate = Carbon::now()->format('Y-m-d 00:00:00');
        $endDate = Carbon::now()->format('Y-m-d 23:59:59');
        $todayReportCount = $reportService->getTaskHistoryReportCount($startDate, $endDate, $whereCondition);
        $monthStartDate = Carbon::now()->startOfMonth()->format('Y-m-d 00:00:00');
        $monthlyReportCount = $reportService->getTaskHistoryReportCount($monthStartDate, $endDate, $whereCondition);
        $clients['taskReport'] = ['today' => $todayReportCount, 'monthly' => $monthlyReportCount];
        return HelperServices::returnJsonResponse(1, 'Success', $clients);
    }
}
