<?php


namespace App\Services;

use App\Category;
use App\Permission;
use App\StaffPivotClient;
use App\User;
use http\Env\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use App\UserCategory;
use Illuminate\Support\Arr;

class UserService{

    // Datatable filter users
    public function userFilterListAjax($type, $branch='')
    {
        $getCoordinatorData = User::select('id')->where(['id' => $branch, 'role' => 'Coordinator'])->first();
        if($getCoordinatorData && $type == 'client') {
            $getExecutiveIds = User::selectRaw('GROUP_CONCAT(id) as ids')->where(['branch_id' => $getCoordinatorData->id, 'role' => 'Executive'])->first();
            if($getExecutiveIds) {
                $idsArr = explode(',', $getExecutiveIds->ids);
                $data = User::where('role', 'client')->whereIn('branch_id', $idsArr)->get();
            } else {
                goto oldFlow;
            }
//            $getUserData = User::select('id', 'role')->where(['id' => $branch])->first();
//            $rolesArr = ['manager', 'admin', 'staff', 'client'];
//            if ($getUserData && in_array($type, $rolesArr)) {
//                if ($getUserData->role == 'Coordinator') {
//                    $getExecutiveIds = User::selectRaw('GROUP_CONCAT(id) as ids')->where(['branch_id' => $getUserData->id, 'role' => 'Executive'])->first();
//                    if ($getExecutiveIds) {
//                        $idsArr = explode(',', $getExecutiveIds->ids);
//                        $data = User::where('role', ucfirst($type))->whereIn('branch_id', $idsArr)->get();
//                    }
//                } else if($getUserData->role == 'Executive') {
//                    $data = User::where(['branch_id' => $getUserData->id, 'role' => ucfirst($type)])->get();
//                } else {
//                    goto oldFlow;
//                }
        } else {
            oldFlow:
            $data = User::query();
            if ($type != "all") {
                $data = $data->where("role", ucfirst($type));
            }

            if ($branch) {
                $data = $data->where("branch_id", $branch);
            }
        }

        return $this->returnDatatableResponse($data);
    }
    public function userBranchListAjax($type,$branch){
        $data = User::query();
        if($type != "all"){
            $data = $data->where("role", ucfirst($type));
        }
        if($branch) {
            $data = $data->where("branch_id", $branch);
        }



        return $this->returnDatatableResponse($data,$type);
    }

    private function returnDatatableResponse($data){
        return datatables()->of($data)
            ->addColumn('status', function($row){
                if(checkPermission('deactivateUser', strtolower($row->role))) {
                    $status = '<label class="cl-switch"><input type="checkbox" ' . ($row->status ? 'checked' : '') . ' onchange="updateUserStatus(this, ' . $row->id . ')"><span class="switcher"></span></label>';
                } else {
                    if($row->status)
                        $status = '<span class="badge light badge-success">ACTIVE</span>';
                    else
                        $status = '<span class="badge light badge-warning">INACTIVE</span>';
                }
                return $status;
            })
            ->addColumn('action', function($row){
                $btn = '<div class="d-flex">';
                $btn .= '<div class="custom-control custom-switch"><input type="checkbox" class="custom-control-input" id="customSwitches"></div>';
                $user_type = strtolower($row->role);
                if(Auth::user()->role == 'SuperAdmin' and $row->role == 'Coordinator') {
                    $btn .= '<a href="' . route("portal.userFilterList", ["type" => 'executive', "id" => $row->id]) . '" class="btn btn-info info shadow sharp mr-1"><i class="fa fa-user"></i> Executives</a>';
                    $btn .= '<a href="' . route("portal.userFilterList", ["type" => 'client', "id" => $row->id]) . '" class="btn btn-default shadow sharp mr-1"><i class="fa fa-user-circle"></i> Clients</a>';
                }
//                if(Auth::user()->role == 'SuperAdmin' and $row->role=='Executive') {
                if($row->role == 'Executive') {
                    $btn .= '<a href="' . route("portal.userFilterList", ["type" => 'manager',"id" => $row->id]) . '" class="btn btn-info info shadow sharp mr-1"><i class="fa fa-user"></i> Managers</a>';
                    $btn .= '<a href="' . route("portal.userFilterList", ["type" => 'admin',"id" => $row->id]) . '" class="btn btn-info info shadow sharp mr-1"><i class="fa fa-user"></i> Admins</a>';
                    $btn .= '<a href="' . route("portal.userFilterList", ["type" => 'staff',"id" => $row->id]) . '" class="btn btn-warning warning shadow sharp mr-1"><i class="fa fa-users"></i> Staff</a>';
                    $btn .= '<a href="' . route("portal.userFilterList", ["type" => 'client',"id" => $row->id]) . '" class="btn btn-default shadow sharp mr-1"><i class="fa fa-user-circle"></i> Clients</a>';
                }


                if(checkPermission('viewUser', $user_type)) {
                    $btn .= '<a href="' . route("portal.viewUserPage", ["id" => $row->id]) . '" class="btn btn-success shadow sharp mr-1"><i class="fa fa-cog"></i> Operations</a>';
                }
                if(checkPermission('editUser',$user_type)) {
                    $btn .= '<a href="' . route("portal.editUserPage", ["id" => $row->id]) . '" class="btn btn-primary shadow sharp mr-1"><i class="fa fa-pencil"></i> Edit</a>';
                }
                if ($row->id != Auth::id() and checkPermission('deleteUser',$user_type)) {
                        $btn .= '<a href="' . route("portal.deleteUser", ["id" => $row->id]) . '" class="deletedBtn btn btn-danger shadow sharp"><i class="fa fa-trash"></i> Delete</a>';
                }

                $btn .= '</div>';
                return $btn;
            })
            ->editColumn('created_at', function ($row){
                $user_type = strtolower($row->role);
                return $row->created_at ;
            })
            ->rawColumns(['action', 'status'])
            ->addIndexColumn()
            ->make(true);
    }

    // add new user
    public function addNewUserRequest($request){
        //print_r($request->all());exit;
        $customMsgs = [
            'name.required' => 'Please enter name.',
            'email.required' => 'Please enter email.',
            'email.email' => 'Please enter valid email address.',
            'email.unique' => 'User already exist with this email.',
            'username.required' => 'Please enter email.',
            'username.unique' => 'User already exist with this username.',
            'password.required' => 'Please enter password.',
            'role.required' => 'Please select role.',
            'employee_id.required_if' => 'Please enter employee id.',
            'ddd_id.required_if' => 'Please enter ddd id.',
            'thumbnail.mimetypes' => 'Only JPG or PNG file is allowed.',
            'thumbnail.max' => 'Maximum uploading profile image size limit is 1MB.',
        ];
        $rules = [
            'name'=>'required',
            'email'=>'required|email|unique:users',
            'username'=>'required|unique:users',
            'password'=>'required',
            'role'=>'required',
            'employee_id'=>'required_if:role,==,Staff',
            'ddd_id'=>'required_if:role,==,Client',
            'thumbnail'=>'nullable|mimetypes:image/jpeg,image/png|max:1000',
        ];
        $data = [];
//        if($request->role == 'Client'){
//            $rules['username'] = '';
//            $rules['password'] = '';
//            $data['username'] = 'client-'.rand(1000,9999).'-'.time();
//            $data['password'] = 'nopass';
//            $request->password = $data['password'];
//        }



        $validator = Validator::make($request->all(),$rules, $customMsgs);

        if ($validator->fails()) {
            $errorArray = HelperServices::validationErrorFormat($validator->errors());
            return HelperServices::returnJsonResponse(2, 'Validation Errors', [], $errorArray, 422);
        }


        $data['password'] = bcrypt($request->password);
        if($request->file('thumbnail')){
            $profileFile = $request->file('thumbnail');
            $profileFileExtension = $profileFile->getClientOriginalExtension();
            $profileImgName = 'profile-img'.time().'.'.$profileFileExtension;

            $data['thumbnail'] = $profileImgName;
        }
        $record = User::create($request->except("password", "thumbnail") + $data);
        if($record){
            $editUrl = route("portal.editUserPage", ["id" => $record->id]);

            if ($request->role == 'Coordinator') {
                $dataU['branch_id'] = $record->id;
            } else if (Auth::user()->role == 'Coordinator' && $request->role == 'Executive') {
                $dataU['branch_id'] = Auth::user()->id;
            } else {
                $dataU['branch_id'] = $request->branch_id;
            }
            User::Where('id', $record->id)->update($dataU);
            if(isset($profileFile)){
                $uploadingPath = public_path('/storage/user-data/user-'.$record->id);
                $imageUpload = $profileFile->move($uploadingPath, $profileImgName);
                if($imageUpload){
                    return HelperServices::returnJsonResponse(1, 'User created successfully.', ["edit_url" => $editUrl]);
                } else {
                    User::where(['id' => $record->id])->update(["thumbnail" => ""]);
                    return HelperServices::returnJsonResponse(1, 'Sorry, there was an error uploading your image but user created successfully', ["edit_url" => $editUrl]);
                }
            }
            return HelperServices::returnJsonResponse(1, 'User created successfully.', ["edit_url" => $editUrl]);
        } else {
            return HelperServices::returnJsonResponse(0, 'User not created.');
        }
    }

    public function addUserPermissions($request){

        $data['role']=$request->role;
        Permission::where('role',$request->role)->delete(); // Delete all role permission
        //dd($request->user_permissions);
        foreach($request->user_permissions as $key => $value){
           // Permission::create();
            $permission = new Permission;
            $permission->name = $value;
            $permission->role_key=$value;
            $permission->role=$request->role;
            $permission->save();
        }
        return HelperServices::returnJsonResponse(1, 'Role permission updated successfully.');

    }

    // edit user page
    public function editUserPage($id){
        $user = User::find($id);
        $branchName='';
        if($user->branch_id){
            $branchName = User::find($user->branch_id)->name;
        }
        if(!$user){
            abort(404);
        }
        return view("portal.users.editUser", compact("user","branchName"));
    }

    // update user request
    public function updateUserRequest($request){
        $customMsgs = [
            'id.required' => 'Something went wrong.',
            'name.required' => 'Please enter name.',
            'email.required' => 'Please enter email.',
            'email.email' => 'Please enter valid email address.',
            'email.unique' => 'User already exist with this email.',
            'username.required' => 'Please enter username.',
            'username.unique' => 'User already exist with this username.',
            'thumbnail.mimetypes' => 'Only JPG or PNG file is allowed.',
            'thumbnail.max' => 'Maximum uploading profile image size limit is 1MB.',
        ];
        $validator = Validator::make($request->all(),[
            'id'=>'required',
            'name'=>'required',
            'email'=>'required|email|unique:users,email,'.$request->id,
            'username'=>'required|unique:users,username,'.$request->id,
            'thumbnail'=>'nullable|mimetypes:image/jpeg,image/png|max:1000',
        ], $customMsgs);

        if ($validator->fails()) {
            $errorArray = HelperServices::validationErrorFormat($validator->errors());
            return HelperServices::returnJsonResponse(2, 'Validation Errors', [], $errorArray, 422);
        }

        $data = array();
        if($request->password != ""){
            $data['password'] = bcrypt($request->password);
        }
        if($request->file('thumbnail')){
            $profileFile = $request->file('thumbnail');
            $profileFileExtension = $profileFile->getClientOriginalExtension();
            $profileImgName = 'profile-img'.time().'.'.$profileFileExtension;

            $data['thumbnail'] = $profileImgName;
        }
        $data['updated_at'] = new \DateTime();
        if(User::where(['id' => $request->id])->update($request->except("id", "password", "thumbnail") + $data)){

            $exe_user = User::find($request->id);

            if($exe_user->role=='Coordinator' || $exe_user->role=='Executive'){
                $data['status']=$request->status;
                User::Where('branch_id', $exe_user->id)->update($data);
            }



            if(isset($profileFile)){
                $uploadingPath = public_path('/storage/user-data/user-'.$request->id);
                $imageUpload = $profileFile->move($uploadingPath, $profileImgName);
                if($imageUpload){
                    return HelperServices::returnJsonResponse(1, 'User updated successfully');
                } else {
                    User::where(['id' => $request->id])->update(["thumbnail" => ""]);
                    return HelperServices::returnJsonResponse(1, 'Sorry, there was an error uploading your image but user updated successfully');
                }
            }
            return HelperServices::returnJsonResponse(1, 'User updated successfully');
        } else {
            return HelperServices::returnJsonResponse(0, 'Nothing change');
        }
    }

    // update user status
    public function updateUserStatus($request){
        $customMsgs = ['id.required' => 'Something went wrong.', 'status.required' => 'Invalid request.'];
        $validator = Validator::make($request->all(),['id'=>'required', 'status'=>'required'], $customMsgs);
        if ($validator->fails()) {
            $errorArray = HelperServices::validationErrorFormat($validator->errors());
            return HelperServices::returnJsonResponse(2, 'Validation Errors', [], $errorArray, 422);
        }
        if(User::where(['id' => $request->id])->update(['status' => $request->status, 'updated_at' => new \DateTime()])){
            return HelperServices::returnJsonResponse(1, 'Status updated successfully');
        } else {
            return HelperServices::returnJsonResponse(0, 'Nothing change');
        }
    }

    // view user page
    public function viewUserPage($id){
        $user = User::find($id);
        $branchName='';
        if($user->branch_id){
            $branchName = User::find($user->branch_id)->name;
        }
        if(!$user){
            abort(404);
        }
        $clients = $categories = [];
        if($user->role == "Staff"){
            $alreadyAssClients = StaffPivotClient::where('staff_id','=',$id)->pluck("client_id");
            //echo '<pre>';
            //print_r($alreadyAssClients);exit;

            $clients = User::select("id", "name", "username")->where("branch_id", $user->branch_id)->where("role", "Client")->whereNotIn("id", $alreadyAssClients)->get();
        }
        if ($user->role == "Executive" && (checkPermission('addUserCategory', Auth::user()->role) || Auth::user()->role == 'SuperAdmin')) {
            $assignedCategories = UserCategory::where('user_id', $id)->pluck("category_id");
            $categories = Category::select("id", "title")->where("status", 1)->whereNotIn("id", $assignedCategories)->get();
        }
        return view("portal.users.viewUser", compact("user", "clients","branchName", "categories"));
    }

    // delete user
    public function deleteUser($id){
        $user = User::find($id);
        if(!$user){
            return HelperServices::returnJsonResponse(0, 'User not found.');
        }
        if($user->delete()){
            return HelperServices::returnJsonResponse(1, 'User deleted successfully.');
        } else {
            return HelperServices::returnJsonResponse(0, 'User not deleted.');
        }
    }

    public function assignClientToStaffRequest($request){
        $customMsgs = [
            'id.required' => 'Something went wrong.',
            'clients.required' => 'Please select client.',
        ];
        $validator = Validator::make($request->all(),[
            'id'=>'required',
            'clients'=>'required',
        ], $customMsgs);

        if ($validator->fails()) {
            $errorArray = HelperServices::validationErrorFormat($validator->errors());
            return HelperServices::returnJsonResponse(2, 'Validation Errors', [], $errorArray, 422);
        }

        $record = User::where(["id" => $request->id, "role" => "Staff"])->first();
        if($record){
            $record->staffClients()->attach($request->clients);
    // assign client to staff member
            return HelperServices::returnJsonResponse(1, 'Clients assigned successfully.');
        } else {
            return HelperServices::returnJsonResponse(0, 'Clients only assign to staff member.');
        }
    }

    // remove client from staff
    public function removeClientFromStaff($id){
        $record = StaffPivotClient::find($id);
        if(!$record){
            return HelperServices::returnJsonResponse(0, 'Relationship not found.');
        }
        $record->delete();
        return HelperServices::returnJsonResponse(1, 'Client successfully removed.');
    }

    // get staff profile detail
    public function getStaffProfile($user, $returnJson = true){
        if(is_object($user)){
            $userDetail = $user;
        } else {
            $userDetail = User::find($user);
        }
        if($returnJson){
            if(!$userDetail){
                return HelperServices::returnJsonResponse(0, 'Record not found');
            }
            $userDetail = HelperServices::arrayLoopGenModified($userDetail->toArray());
            return HelperServices::returnJsonResponse(1, 'Success', $userDetail);
        } else {
            return $userDetail;
        }
    }

    // update profile detail
    public function staffProfileUpdate($request){
        $currentUser = request()->user();
        $customMsgs = [
            'name.required' => 'Please enter name.',
            'email.required' => 'Please enter email.',
            'email.email' => 'Please enter valid email address.',
            'email.unique' => 'User already exist with this email.'
        ];
        $validator = Validator::make($request->all(),[
            'name'=>'required',
            'email'=>'required|email|unique:users,email,'.$currentUser->id,
        ], $customMsgs);

        if ($validator->fails()) {
            $errorArray = HelperServices::validationErrorFormat($validator->errors());
            return HelperServices::returnJsonResponse(2, 'Validation Errors', [], $errorArray);
        }

        $data = array();
        if($request->password != ""){
            $data['password'] = bcrypt($request->password);
        }
        $data['updated_at'] = new \DateTime();
        if(User::where(['id' => $currentUser->id])->update($request->only("name", "email", "phone_number", "gender", "address", "emergency_contact") + $data)){
            $profileDetail = $this->getStaffProfile($currentUser->id, false);
            $profileDetail = HelperServices::arrayLoopGenModified($profileDetail->toArray());
            return HelperServices::returnJsonResponse(1, 'Profile updated successfully', $profileDetail);
        } else {
            return HelperServices::returnJsonResponse(0, 'Nothing change.');
        }
    }

    // profile image update
    public function updateProfileImg($request){
        $currentUser = request()->user();
        $customMsgs = [
            'thumbnail.required' => 'Please select image.',
            'thumbnail.mimetypes' => 'Only JPG or PNG file is allowed.',
            'thumbnail.max' => 'Maximum uploading profile image size limit is 1MB.',
        ];
        $validator = Validator::make($request->all(),[
            'thumbnail'=>'required|mimetypes:image/jpeg,image/png|max:1000',
        ], $customMsgs);

        if ($validator->fails()) {
            $errorArray = HelperServices::validationErrorFormat($validator->errors());
            return HelperServices::returnJsonResponse(2, 'Validation Errors', [], $errorArray);
        }

        $profileFile = $request->file('thumbnail');
        $profileFileExtension = $profileFile->getClientOriginalExtension();
        $profileImgName = 'profile-img'.time().'.'.$profileFileExtension;
        $uploadingPath = public_path('/storage/user-data/user-'.$currentUser->id);
        $imageUpload = $profileFile->move($uploadingPath, $profileImgName);
        if($imageUpload){
            $data = [];
            $data['thumbnail'] = $profileImgName;
            $data['updated_at'] = new \DateTime();
            if($currentUser->id) {
                User::where(['id' => $currentUser->id])->update($data);
            }
            //$proImg = asset('storage/user-data/user-'.$currentUser->id.'/'.$profileImgName);
            $profileDetail = $this->getStaffProfile($currentUser->id, false);
            $profileDetail = HelperServices::arrayLoopGenModified($profileDetail->toArray());
            return HelperServices::returnJsonResponse(1, 'Profile image updated successfully', $profileDetail);
        } else {
            return HelperServices::returnJsonResponse(0, 'Nothing change.');
        }
    }

    // get client listing of staff member
    public function staffClientListing($request, $userId, $type, $returnJson = true){
        $page = ($request->get('page')) ? $request->get('page') : '1';
        $type = $request->get('type');
        if ($type == 'Staff') {
            $staff = User::find($userId);
            $clients = $staff->staffClients()->where('status', '=', '1')->paginate(env('API_PER_PAGE_LIMIT'))->toArray();
        } else {
            $rolesArr = ['Coordinator', 'Executive', 'Manager', 'Admin'];
            if (in_array($type, $rolesArr)) {
                if ($type == 'Coordinator') {
                    $getExecutiveIds = User::selectRaw('GROUP_CONCAT(id) as ids')->where(['branch_id' => $userId, 'role' => 'Executive'])->first();
                    $idsArr = $getExecutiveIds ? explode(',', $getExecutiveIds->ids) : [];
                    $clientsD = User::where(['role' => 'client', 'status' => 1])->whereIn('branch_id', $idsArr)->paginate(env('API_PER_PAGE_LIMIT'));
                } else {
                    $user = User::find($userId);
                    $branchId = $type == 'Executive' ? $user->id : $user->branch_id;
                    $clientsD = User::where(['branch_id' => $branchId, 'role' => 'Client', 'status' => 1])->paginate(env('API_PER_PAGE_LIMIT'));
                }
                $clientsDD = [];
                foreach ($clientsD as $row) {
                    $row['pivot'] = DB::table('staff_pivot_clients')->where('client_id', $row->id)->first();
                    $clientsDD[] = $row;
                }
                $clientsD = $clientsD->toArray();

                $clients['current_page'] = $clientsD['current_page'];
                $clients['data'] = $clientsDD;
                $clients['first_page_url'] = $clientsD['first_page_url'];
                $clients['from'] = $clientsD['from'];
                $clients['last_page'] = $clientsD['last_page'];
                $clients['last_page_url'] = $clientsD['last_page_url'];
                $clients['next_page_url'] = $clientsD['next_page_url'];
                $clients['path'] = $clientsD['path'];
                $clients['per_page'] = $clientsD['per_page'];
                $clients['prev_page_url'] = $clientsD['prev_page_url'];
                $clients['total'] = $clientsD['total'];
                $clients['to'] = $clientsD['to'];
            } else {
                $staff = User::find($userId);
                $clients = $staff->staffClients()->where('status', '=', '1')->paginate(env('API_PER_PAGE_LIMIT'))->toArray();
            }
        }
        $clients = HelperServices::arrayLoopGenModified($clients);
        if($returnJson) {
            return HelperServices::returnJsonResponse(1, 'Success', $clients);
        } else {
            return $clients;
        }
    }

    public function moveClientsPage() {
        $whereCondition = ['users.role' => 'Executive', 'users.status' => 1];
        if (Auth::user()->role == 'Coordinator')
            $whereCondition['users.branch_id'] = Auth::user()->id;
        $executives = User::select('users.id', 'users.name', 'c.name AS coordinatorName')
            ->join('users AS c', 'users.branch_id', '=', 'c.id')
            ->where($whereCondition)->get();
        return view("portal.users.moveClients", compact("executives"));
    }

    public function getExecutiveClientsRequest($request) {
        $whereCondition = ['users.role' => 'Client', 'users.status' => 1];
        if (Auth::user()->role == 'Coordinator') {
            $getExecutiveIds = User::selectRaw('GROUP_CONCAT(id) as ids')->where(['branch_id' => Auth::user()->id, 'role' => 'Executive'])->whereNotIn('id', [$request->id])->first();
            $idsArr = $getExecutiveIds ? explode(',', $getExecutiveIds->ids) : [];
            $clients = User::select('users.id', 'users.name', 'e.name AS executiveName')
                ->join('users AS e', 'users.branch_id', '=', 'e.id')
                ->where($whereCondition)->whereIn('branch_id', $idsArr)->get();
        } else {
            $clients = User::select('users.id', 'users.name', 'e.name AS executiveName')
                ->join('users AS e', 'users.branch_id', '=', 'e.id')
                ->where($whereCondition)->where('users.branch_id', '!=', $request->id)->get();
        }
        return HelperServices::returnJsonResponse(1, '', $clients);
    }

    public function moveExecutiveClientsRequest($request)
    {
        $clientsArr = $request->clients;
        if (Auth::user()->role == 'SuperAdmin')
            $redirectUrl = route('portal.userFilterList', ["type" => "client"]);
        else
            $redirectUrl = route('portal.userFilterList', ["type" => "client", "id" => Auth::user()->id]);
        if (User::whereIn('id', $clientsArr)->update(['branch_id' => $request->executive])) {
            StaffPivotClient::whereIn('client_id', $clientsArr)->delete();
            return HelperServices::returnJsonResponse(1, 'Clients moved successfully.', ['redirect_url' => $redirectUrl]);
        } else
            return HelperServices::returnJsonResponse(0, 'Unable to move clients. Please try again later.');
    }


    public function assignCategoryToUserRequest($request){
        $customMsgs = [
            'id.required' => 'Something went wrong.',
            'categories.required' => 'Please select at-least one category.',
        ];
        $validator = Validator::make($request->all(),[
            'id'=>'required',
            'categories'=>'required',
        ], $customMsgs);

        if ($validator->fails()) {
            $errorArray = HelperServices::validationErrorFormat($validator->errors());
            return HelperServices::returnJsonResponse(2, 'Validation Errors', [], $errorArray, 422);
        }

        $record = User::where(["id" => $request->id, "role" => "Executive"])->first();
        if ($record) {
            $record->userCategories()->attach($request->categories);
            // assign category to user
            return HelperServices::returnJsonResponse(1, 'Categories assigned successfully.');
        } else {
            return HelperServices::returnJsonResponse(0, 'Invalid request.');
        }
    }

    // remove category from user
    public function removeCategoryFromUser($id){
        $record = UserCategory::find($id);
        if(!$record){
            return HelperServices::returnJsonResponse(0, 'Invalid request.');
        }
        $record->delete();
        return HelperServices::returnJsonResponse(1, 'Category successfully removed.');
    }

    public function getUsers($request)
    {
        $users = User::select('id', 'name', 'username', 'email', 'role')->where('status', 1);
        if ($request->branchId) {
            $users = $users->where('branch_id', $request->get('branchId'));
        }
        if ($request->get('role')) {
            $users = $users->whereIn('role', explode(',', $request->get('role')));
        }
        $users = $users->get();
        $parent = '';
        if ($request->branchId && $request->appendParent) {
            $parent = User::select('id', 'name', 'username', 'email', 'role')->where(['id' => $request->branchId, 'status' => 1])->first();
        }

        return HelperServices::returnJsonResponse(1, 'success', ['users' => $users, 'parent' => $parent]);
    }

    public function clientStaffListing($clientId) {
        $client = User::find($clientId);
//      $staffs = $client->relateStaff()->where(['status' => 1])->paginate(env('API_PER_PAGE_LIMIT'))->toArray();
        $staffs = $client->relateStaff()->where(['status' => 1])->get();
        return HelperServices::arrayLoopGenModified($staffs);
    }

}
