@extends('layouts.app')

@section('title', 'Add Sheet Task')

@section('headSource')

@endsection

@section('content')
<style>
    .prompt-tags span {
        margin-top: 2px;
    }
</style>
    <div class="row page-titles mx-0">
        <div class="col-sm-6 p-md-0">
            <div class="welcome-text">
                <h4>Add New Task</h4>
            </div>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{route('portal.dashboard')}}">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="{{route('portal.dataSheetListPage')}}">Task Sheets</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">View Task Sheets</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Add New Task</a></li>
            </ol>
        </div>
    </div>

    <div class="row">
        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 col-xl-12">
            <div class="card mb-3">
                <div class="card-header">
                    <h3><i class="fa fa-list-alt"></i> Task detail</h3>
                </div>
                <div class="card-body">
                    <form id="sheetTaskAddForm" method="post">
                        <div class="row">
                            <div class="col-lg-12 col-xl-12">
                                <div class="row">
                                    <div class="col-lg-8">
                                        <div class="form-group">
                                            <label>Title (required)</label>
                                            <textarea class="form-control" name="title" required></textarea>
                                        </div>
                                    </div>
                                    <div class="col-lg-4">
                                        <div class="form-group">
                                            <label>Select Sheet Type (required)</label>
                                            <select id="sheetType" class="form-control form-control-lg" name="sheet_type" required>
                                                @foreach($sheetTypes as $type)
                                                    <option value="{{$type->id}}" data-options="{{strtoupper($type->options)}}">{{$type->title}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label><span id="noteLabel1">Progress Note</span> (required)</label>
                                            <textarea id="progressNote" class="form-control" name="progress_note" required></textarea>
                                        </div>
                                        <div class="mb-3 prompt-tags">
                                            <span class="badge badge-secondary insertTag" data-toggle="tooltip" title="Jhon Doe" style="cursor: pointer;" data-tag="##ClientFullName##">##ClientFullName##</span>
                                            <span class="badge badge-secondary insertTag" data-toggle="tooltip" title="Jhon" style="cursor: pointer;" data-tag="##ClientFirstName##">##ClientFirstName##</span>
                                            <span class="badge badge-secondary insertTag" data-toggle="tooltip" title="He/She" style="cursor: pointer;" data-tag="##ClientGenderNoun##">##ClientGenderNoun##</span>
                                            <span class="badge badge-secondary insertTag" data-toggle="tooltip" title="His/Her" style="cursor: pointer;" data-tag="##HIS-HER-GenderNoun##">##HIS-HER-GenderNoun##</span>
                                            <span class="badge badge-secondary insertTag" data-toggle="tooltip" title="Him/Her" style="cursor: pointer;" data-tag="##HIM-HER-Objective##">##HIM-HER-Objective##</span>
                                            <span class="badge badge-secondary insertTag" data-toggle="tooltip" title="Selected Answer" style="cursor: pointer;" data-tag="##AnswerPrompt##">##AnswerPrompt##</span>
                                        </div>
                                    </div>
                                    <div class="col-lg-12 mt-3">
                                        <div class="form-group">
                                            <label><span id="noteLabel2">Progress Note For Independent Prompt</span> (required)</label>
                                            <textarea id="progressNoteIndependent" class="form-control" name="progress_note_independent" required></textarea>
                                        </div>
                                        <div class="mb-3 prompt-tags">
                                            <span class="badge badge-secondary insertTagInd" data-toggle="tooltip" title="Jhon Doe" style="cursor: pointer;" data-tag="##ClientFullName##">##ClientFullName##</span>
                                            <span class="badge badge-secondary insertTagInd" data-toggle="tooltip" title="Jhon" style="cursor: pointer;" data-tag="##ClientFirstName##">##ClientFirstName##</span>
                                            <span class="badge badge-secondary insertTagInd" data-toggle="tooltip" title="He/She" style="cursor: pointer;" data-tag="##ClientGenderNoun##">##ClientGenderNoun##</span>
                                            <span class="badge badge-secondary insertTagInd" data-toggle="tooltip" title="His/Her" style="cursor: pointer;" data-tag="##HIS-HER-GenderNoun##">##HIS-HER-GenderNoun##</span>
                                            <span class="badge badge-secondary insertTagInd" data-toggle="tooltip" title="Him/Her" style="cursor: pointer;" data-tag="##HIM-HER-Objective##">##HIM-HER-Objective##</span>
                                            <span id="answerPrompt" class="badge badge-secondary insertTagInd" data-toggle="tooltip" title="Selected Answer" style="cursor: pointer;" data-tag="##AnswerPrompt##">##AnswerPrompt##</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <button type="submit" class="btn btn-primary">Add Task</button>
                            </div>
                        </div>
                    </form>
                </div>
                <!-- end card-body -->
            </div>
            <!-- end card -->
        </div>
        <!-- end col -->
    </div>
    <!-- end row -->

@endsection

@section('footerSource')

<script>
    // Select first option on page load
    $("#sheetType").val($("#sheetType option:first").val());

    $(document).ready(function () {
        // insert tag in progress note
        $(".insertTag").click(function (e) {
            let tag = $(this).data("tag");
            let noteTxt = $("#progressNote").val();
            let upDateNoteTxt = noteTxt+' '+tag+' ';
            $("#progressNote").val(upDateNoteTxt);
        });
        $(".insertTagInd").click(function (e) {
            let tag = $(this).data("tag");
            let noteTxt = $("#progressNoteIndependent").val();
            let upDateNoteTxt = noteTxt+' '+tag+' ';
            $("#progressNoteIndependent").val(upDateNoteTxt);
        });

        // tooltip
        $('[data-toggle="tooltip"]').tooltip();

        // add sheet task form submit
        $("#sheetTaskAddForm").submit(function (e) {
            e.preventDefault();
            let data = $(this).serialize()+"&data_sheet_id={{$sheetId}}";
            axios.post('{{route("portal.addSheetTaskRequest")}}', data)
                .then(function (response) {
                    if(response.data.response_code == 1){
                        successMsg(response.data.message);
                        setTimeout(function () {
                            location.href = response.data.data.redirect_url;
                        }, 1000);
                    } else {
                        errorMsg(response.data.message);
                    }
                })
                .catch(function (error) {

                });
        });

        // sheet type change event
        $('#sheetType').change(function (e) {
            let optionStr = $(this).find('option:selected').data('options'),
                optionArr = optionStr.split(',');
            if (optionArr.length === 2) {
                $('#noteLabel1').html('Progress Note for ' + optionArr[0] + ' case');
                $('#noteLabel2').html('Progress Note for ' + optionArr[1] + ' case');
                $('#answerPrompt').show();
            } else {
                $('#noteLabel1').html('Progress Note');
                $('#noteLabel2').html('Progress Note For Independent Prompt');
                $('#answerPrompt').hide();
            }
        });
    });
</script>
@endsection
