@extends('layouts.app')

@section('title', 'View Data Sheet')

@section('headSource')
    <link rel="stylesheet" href="{!! asset('admin-assets/vendor/select2/css/select2.min.css') !!}">
    <link href="{!! asset('admin-assets/vendor/bootstrap-select/dist/css/bootstrap-select.min.css') !!}" rel="stylesheet">
    <!-- Datatable -->
    <link rel="stylesheet" href="{!! asset('admin-assets/vendor/datatables/css/jquery.dataTables.min.css') !!}">
@endsection

@section('content')

    <div class="row page-titles mx-0">
        <div class="col-sm-6 p-md-0">
            <div class="welcome-text">
                <h4>{{$record->name}} Task Sheet</h4>
            </div>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{route('portal.dashboard')}}">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="{{route('portal.dataSheetListPage')}}">Task Sheets</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">View Task Sheet</a></li>
            </ol>
        </div>
    </div>

    <!-- row -->
    <div class="row">
        <div class="col-lg-12">
            <div class="profile card card-body px-3 pt-3 pb-0">
                <div class="profile-head">
                    <div class="profile-info">
                        <div class="profile-details">
                            <div class="profile-name px-3 pt-2">
                                <h4 class="text-primary mb-0">{{$record->name}}</h4>
                            </div>
                            @if (checkPermission('editSheet',Auth::user()->role) || Auth::user()->role=='SuperAdmin')
                            <div class="dropdown ml-auto">
                                <a href="#" class="btn btn-primary light sharp" data-toggle="dropdown" aria-expanded="true"><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="18px" height="18px" viewBox="0 0 24 24" version="1.1"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><rect x="0" y="0" width="24" height="24"></rect><circle fill="#000000" cx="5" cy="12" r="2"></circle><circle fill="#000000" cx="12" cy="12" r="2"></circle><circle fill="#000000" cx="19" cy="12" r="2"></circle></g></svg></a>
                                <ul class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(-169px, 30px, 0px);">
                                    <li><a class="dropdown-item" href="{!! route("portal.editDataSheetPage", ["id" => $record->id]) !!}"> <i class="fa fa-pencil text-primary mr-2"></i> Edit </a></li>
                                </ul>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="profile-tab">
                <div class="custom-tab-1">
                    <ul class="nav nav-tabs">
                        <li class="nav-item"><a href="#tasksTab" data-toggle="tab" class="nav-link active show">Tasks</a>
                        </li>
                        <li class="nav-item"><a href="#categoryTab" data-toggle="tab" class="nav-link">Categories</a>
                        </li>
                    </ul>
                    <div class="tab-content">
                        <div id="tasksTab" class="tab-pane fade active show">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">Tasks</h4>
                                    @if (checkPermission('addTask',Auth::user()->role) || Auth::user()->role=='SuperAdmin')
                                        <span class="pull-right"><a
                                                href="{{route("portal.addSheetTaskPage", ["id" => $record->id])}}"
                                                class="btn btn-primary btn-sm">
                            <i class="fa fa-plus-circle" aria-hidden="true"></i> Add new task</a></span>
                                    @endif
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="display listing-table" style="min-width: 845px">
                                            <thead>
                                            <tr>
                                                <th>Sr</th>
                                                <th>Title</th>
                                                <th>Progress Note</th>
                                                {{--<th>Total Statuses</th>--}}
                                                <th>Status</th>
                                                <th>Created At</th>
                                                <th>Action</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            @foreach($record->tasks as $task)
                                                <tr>
                                                    <td>{{$loop->iteration}}</td>
                                                    <td>{{$task->title}}</td>
                                                    <td>{{substr($task->progress_note, 0, 50)}}</td>
                                                    {{--<td>{{$task->answers->count()}}</td>--}}
                                                    <td> {!! ($task->status == 1)? '<span class="badge light badge-success">Active</span>': '<span class="badge light badge-warning">Inactive</span>' !!} </td>
                                                    <td>{{ Carbon\Carbon::parse($record->created_at)->format('d M, Y h:i A')}}</td>
                                                    <td width="20%">
                                                        <div class="d-flex">
                                                            @if (checkPermission('editTask',Auth::user()->role) || Auth::user()->role=='SuperAdmin')
                                                                <a href="{{route('portal.editSheetTaskPage', ["id" => $task->id])}}"
                                                                   class="btn btn-primary shadow sharp mr-1"><i
                                                                        class="fa fa-pencil"></i> Edit</a>
                                                            @endif
                                                            @if (checkPermission('deleteTask',Auth::user()->role) || Auth::user()->role=='SuperAdmin')
                                                                <a href="{{route('portal.deleteSheetTask', ["id" => $task->id])}}"
                                                                   class="deletedBtn btn btn-danger shadow sharp"><i
                                                                        class="fa fa-trash"></i> Delete</a>
                                                            @endif
                                                        </div>
                                                    </td>
                                                </tr>
                                            @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div id="categoryTab" class="tab-pane fade">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">Categories</h4>
                                </div>
                                <div class="card-body">
                                    <div class="pt-4">
                                        <div class="settings-form">
                                            <h4 class="text-primary">Assign New Categories</h4>
                                            <form id="assignCategoryToSheetForm">
                                                <div class="row">
                                                    <div class="col-sm-8">
                                                        <div class="form-group">
                                                            <label>Choose Categories</label>
                                                            <select class="multi-select select2-dropdown"
                                                                    name="categories[]" multiple="multiple" required>
                                                                @foreach($categories as $category)
                                                                    <option value="{{$category->id}}">{{$category->title}}</option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4" style="margin-top: 30px">
                                                        <button class="btn btn-sm btn-primary" type="submit">Assign</button>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                    <div class="mt-4">
                                        <h4 class="text-primary mb-4">Assigned Categories</h4>
                                        <div class="table-responsive">
                                            <table class="display listing-table" style="min-width: 845px">
                                                <thead>
                                                <tr>
                                                    <th>Sr</th>
                                                    <th>Title</th>
                                                    <th>Action</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                @foreach($record->categories as $item)
                                                    <tr>
                                                        <td>{{$loop->iteration}}</td>
                                                        <td>{{$item->title}}</td>
                                                        <td>
                                                            <a href="{{ route("portal.removeCategoryFromSheetRequest", ["id" => $item->pivot->id]) }}" class="deletedBtn btn btn-danger mr-1 shadow sharp"><i class="fa fa-trash"></i> Remove</a>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('footerSource')
    <script src="{!! asset('admin-assets/vendor/select2/js/select2.full.min.js') !!}"></script>
    <!-- Datatable -->
    <script src="{!! asset('admin-assets/vendor/datatables/js/jquery.dataTables.min.js') !!}"></script>
    <script>
        $(document).ready(function (e) {
            // question listing
            $('.select2-dropdown').select2({placeholder: 'Select Categories'});
            $('.listing-table').DataTable();

            $("#assignCategoryToSheetForm").submit(function (e) {
                e.preventDefault();
                let data = $(this).serialize()+"&id={{$record->id}}";
                axios.post('{{route("portal.assignCategoryToSheetRequest")}}', data)
                    .then(function (response) {
                        if(response.data.response_code == 1){
                            successMsg(response.data.message);
                            setTimeout(function () {
                                location.reload();
                            }, 1000);
                        } else {
                            errorMsg(response.data.message);
                        }
                    })
                    .catch(function (error) {

                    });
            });
        });
    </script>
@endsection
