<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::redirect('/', url('/admin/login'))->name("home");
Route::get('test-email', 'EmailTestController@index')->name('testEmail');


Route::prefix('admin')->namespace('PortalController')->name('portal.')->group(function () {

    Route::middleware("guest")->group(function (){
        Route::get('/login', 'AuthController@loginPage')->name('loginPage');
        Route::post('/login', 'AuthController@loginRequest')->name('loginRequest');

    });

    Route::prefix('dashboard')->middleware("check.portal.access")->group(function (){
        Route::get('/', 'DashboardController@index')->name('dashboard');
        Route::get('/my-profile', 'DashboardController@editProfile')->name('editProfile');
        Route::get('/logout', 'AuthController@logoutRequest')->name('logoutRequest');

        // users
        Route::prefix('users')->group(function (){

            Route::get('/test-email', 'UserController@testEmail')->name('testEmail');

            Route::redirect('/', '/admin/users/filter/all');
            Route::redirect('/filter', '/admin/users/filter/all');
            Route::get('/filter/{type?}/{branchId?}', 'UserController@userFilterList')->name('userFilterList');
            Route::get('/branch/{branchId?}/{type?}', 'UserController@userFilterBranchList')->name('userFilterBranchList');
            Route::get('/permissions/{type?}', 'UserController@userPermissionList')->name('userPermissionList');
            Route::get('/user-datatable/{type}/{branch?}', 'UserController@userFilterListRequest')->name('userFilterListDatatable');
            Route::get('/add-new-user', 'UserController@addNewUser')->name('addNewUserPage');
            Route::post('/add-new-user-request', 'UserController@addNewUserRequest')->name('addNewUserRequest');
            Route::post('/add-user-permissions', 'UserController@addUserPermissions')->name('addUserPermissions');
            Route::get('/edit-user/{id}', 'UserController@editUser')->name('editUserPage');
            Route::post('/update-user-request', 'UserController@updateUserRequest')->name('updateUserRequest');
            Route::get('/view-user/{id}', 'UserController@viewUser')->name('viewUserPage');
            Route::delete('/delete-user/{id}', 'UserController@deleteUser')->name('deleteUser');
            Route::post('/update-status', 'UserController@updateUserStatus')->name('updateUserStatus');
            Route::post('/assign-client-to-staff', 'UserController@assignClientToStaffRequest')->name('assignClientToStaffRequest');
            Route::delete('/remove-client-from-staff/{id}', 'UserController@removeClientFromStaff')->name('removeClientFromStaffRequest');
            Route::get('/move-clients', 'UserController@moveClients')->name('moveClientsPage');
            Route::post('/get-executive-clients-request', 'UserController@getExecutiveClientsRequest')->name('getExecutiveClientsRequest');
            Route::post('/move-executive-clients-request', 'UserController@moveExecutiveClientsRequest')->name('moveExecutiveClientsRequest');

            Route::post('/assign-category-to-user', 'UserController@assignCategoryToUserRequest')->name('assignCategoryToUserRequest');
            Route::delete('/remove-category-from-user/{id}', 'UserController@removeCategoryFromUser')->name('removeCategoryFromUserRequest');

            Route::get('/get-users', 'UserController@getUsers')->name('getUsers');
        });

        // data sheets
        Route::prefix('data-sheets')->group(function (){
            Route::get('/', 'DataSheetController@dataSheetPage')->name('dataSheetListPage');
            Route::get('/add-new-data-sheet', 'DataSheetController@addNewDataSheet')->name('addNewDataSheetPage');
            Route::post('/add-new-data-sheet-request', 'DataSheetController@addNewDataSheetRequest')->name('addNewDataSheetRequest');
            Route::get('/edit-data-sheet/{id}', 'DataSheetController@editDataSheet')->name('editDataSheetPage');
            Route::put('/update-data-sheet-request', 'DataSheetController@updateDataSheetRequest')->name('updateDataSheetRequest');
            Route::delete('/delete-data-sheet/{id}', 'DataSheetController@deleteDataSheet')->name('deleteDataSheet');
            Route::get('/view-data-sheet/{id}', 'DataSheetController@viewDataSheet')->name('viewDataSheetPage');

            Route::post('/assign-category-to-data-sheet', 'DataSheetController@assignCategoryToSheetRequest')->name('assignCategoryToSheetRequest');
            Route::delete('/remove-client-from-data-sheet/{id}', 'DataSheetController@removeCategoryFromSheet')->name('removeCategoryFromSheetRequest');
            // sheet tasks
            Route::prefix('view-data-sheet')->group(function (){
                Route::get('/{id}/add-sheet-task', 'DataSheetController@addSheetTask')->name('addSheetTaskPage');
                Route::post('/add-sheet-task-request', 'DataSheetController@addSheetTaskRequest')->name('addSheetTaskRequest');
                Route::get('/edit-sheet-task/{id}', 'DataSheetController@editSheetTask')->name('editSheetTaskPage');
                Route::put('/update-sheet-task-request', 'DataSheetController@updateSheetTaskRequest')->name('updateSheetTaskRequest');
                Route::delete('/delete-sheet-task/{id}', 'DataSheetController@deleteSheetTask')->name('deleteSheetTask');
                // answers
                Route::post('/add-answer-in-task-request', 'DataSheetController@addAnswerInTaskRequest')->name('addAnswerInTaskRequest');
                Route::delete('/delete-answer-in-task/{id}', 'DataSheetController@deleteAnswerInTask')->name('deleteAnswerInTask');
            });
        });
        Route::prefix('categories')->group(function () {
            Route::get('/', 'CategoryController@listing')->name('categoryListPage');
            Route::get('/add-category', 'CategoryController@addPage')->name('addCategoryPage');
            Route::post('/add-category-request', 'CategoryController@addRequest')->name('addCategoryRequest');
            Route::get('/edit-category/{id}', 'CategoryController@editPage')->name('editCategoryPage');
            Route::put('/update-category-request', 'CategoryController@updateRequest')->name('updateCategoryRequest');
            Route::delete('/delete-category/{id}', 'CategoryController@deleteRequest')->name('deleteCategoryRequest');
        });
        Route::prefix('task-reports')->group(function (){
            Route::get('/', 'TaskReportController@taskHistoryReport')->name('taskHistoryReportPage');
            Route::get('/get-history-report', 'TaskReportController@getTaskHistoryReport')->name('getTaskHistoryReportRequest');
            Route::get('/task-history-datatable/{id}', 'TaskReportController@userTaskHistoryRequest')->name('userTaskHistoryDatatable');
            Route::get('/view-task-report/{id}', 'TaskReportController@viewTaskReport')->name('viewTaskReportPage');
        });
    });

});
