<?php $__env->startSection('title', 'View User'); ?>

<?php $__env->startSection('headSource'); ?>
    <link rel="stylesheet" href="<?php echo asset('admin-assets/vendor/select2/css/select2.min.css'); ?>">
    <link href="<?php echo asset('admin-assets/vendor/bootstrap-select/dist/css/bootstrap-select.min.css'); ?>" rel="stylesheet">
    <!-- Datatable -->
    <link rel="stylesheet" href="<?php echo asset('admin-assets/vendor/datatables/css/jquery.dataTables.min.css'); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row page-titles mx-0">
        <div class="col-sm-6 p-md-0">
            <div class="welcome-text">
                <h4>View <?php echo e($user->role); ?></h4>
            </div>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('portal.dashboard')); ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route("portal.userFilterList")); ?>/<?php echo e(strtolower($user->role)); ?>/<?php echo e($user->branch_id); ?>"> <?php echo e($branchName); ?> Users</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)"><?php echo e($user->role); ?></a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Detail</a></li>
            </ol>
        </div>
    </div>

    <!-- row -->
    <div class="row">
        <div class="col-lg-12">
            <div class="profile card card-body px-3 pt-3 pb-0">
                <div class="profile-head">
                    <div class="profile-info">
                        <div class="profile-photo">
                            <img src="<?php echo $user->thumbnail; ?>" class="rounded-circle" alt="" style="width: 100px; height: 100px;">
                        </div>
                        <div class="profile-details">
                            <div class="profile-name px-3 pt-2">
                                <h4 class="text-primary mb-0"><?php echo e($user->name); ?></h4>
                                <p><?php echo e($user->role); ?></p>
                            </div>
                            <div class="profile-email px-2 pt-2">
                                <h4 class="text-muted mb-0"><?php echo e($user->email); ?></h4>
                                <p><?php echo e($user->username); ?></p>
                            </div>
                            <div class="dropdown ml-auto">
                                <a href="#" class="btn btn-primary light sharp" data-toggle="dropdown" aria-expanded="true"><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="18px" height="18px" viewBox="0 0 24 24" version="1.1"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><rect x="0" y="0" width="24" height="24"></rect><circle fill="#000000" cx="5" cy="12" r="2"></circle><circle fill="#000000" cx="12" cy="12" r="2"></circle><circle fill="#000000" cx="19" cy="12" r="2"></circle></g></svg></a>
                                <ul class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(-169px, 30px, 0px);">
                                    <li><a class="dropdown-item" href="<?php echo route("portal.editUserPage", ["id" => $user->id]); ?>"> <i class="fa fa-pencil text-primary mr-2"></i> Edit </a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">
                    <div class="profile-tab">
                        <div class="custom-tab-1">
                            <ul class="nav nav-tabs">
                                <?php if($user->role == "SuperAdmin" || $user->role == 'Client'): ?>
                                    <li class="nav-item"><a href="#aboutTab" data-toggle="tab" class="nav-link active show">About</a></li>
                                <?php else: ?>
                                    <li class="nav-item"><a href="#taskHistoryTab" data-toggle="tab" class="nav-link active show">Task History</a></li>
                                    <?php if($user->role == "Executive" && (checkPermission('addUserCategory', Auth::user()->role) || Auth::user()->role == 'SuperAdmin')): ?>
                                        <li class="nav-item"><a href="#categoryTab" data-toggle="tab" class="nav-link">Categories</a></li>
                                    <?php endif; ?>
                                    <?php if($user->role == "Staff"): ?>
                                        <li class="nav-item"><a href="#clientsTab" data-toggle="tab" class="nav-link">Clients</a></li>
                                    <?php endif; ?>
                                    <li class="nav-item"><a href="#aboutTab" data-toggle="tab" class="nav-link">About</a></li>
                                <?php endif; ?>
                            </ul>
                            <div class="tab-content">
                                <div id="aboutTab" class="tab-pane fade <?php echo e(($user->role == "SuperAdmin" || $user->role == 'Client') ? 'active show' : ''); ?>">
                                    <div class="profile-personal-info">
                                        <h4 class="text-primary mb-4 mt-4">Information</h4>
                                        <div class="row mb-2">
                                            <div class="col-3">
                                                <h5 class="f-w-500">Name <span class="pull-right">:</span>
                                                </h5>
                                            </div>
                                            <div class="col-9"><span><?php echo e($user->name); ?></span>
                                            </div>
                                        </div>
                                        <div class="row mb-2">
                                            <div class="col-3">
                                                <h5 class="f-w-500">Email <span class="pull-right">:</span>
                                                </h5>
                                            </div>
                                            <div class="col-9"><span><?php echo e($user->email); ?></span>
                                            </div>
                                        </div>
                                        <div class="row mb-2">
                                            <div class="col-3">
                                                <h5 class="f-w-500">Username <span class="pull-right">:</span></h5>
                                            </div>
                                            <div class="col-9"><span><?php echo e($user->username); ?></span>
                                            </div>
                                        </div>
                                        <div class="row mb-2">
                                            <div class="col-3">
                                                <h5 class="f-w-500">Date of birth <span class="pull-right">:</span>
                                                </h5>
                                            </div>
                                            <div class="col-9"><span><?php echo e($user->date_of_birth); ?></span>
                                            </div>
                                        </div>
                                        <div class="row mb-2">
                                            <div class="col-3">
                                                <h5 class="f-w-500">Gender <span class="pull-right">:</span>
                                                </h5>
                                            </div>
                                            <div class="col-9"><span><?php echo e($user->gender); ?></span>
                                            </div>
                                        </div>
                                        <div class="row mb-2">
                                            <div class="col-3">
                                                <h5 class="f-w-500">Address <span class="pull-right">:</span>
                                                </h5>
                                            </div>
                                            <div class="col-9"><span><?php echo e($user->address); ?></span>
                                            </div>
                                        </div>
                                        <div class="row mb-2">
                                            <div class="col-3">
                                                <h5 class="f-w-500">Phone Number <span class="pull-right">:</span>
                                                </h5>
                                            </div>
                                            <div class="col-9"><span><?php echo e($user->phone_number); ?></span>
                                            </div>
                                        </div>
                                        <div class="row mb-2">
                                            <div class="col-3">
                                                <h5 class="f-w-500">Emergency Contact <span class="pull-right">:</span>
                                                </h5>
                                            </div>
                                            <div class="col-9"><span><?php echo e($user->emergency_contact); ?></span>
                                            </div>
                                        </div>
                                        <?php if($user->role == "Staff"): ?>
                                            <div class="row mb-2">
                                                <div class="col-3">
                                                    <h5 class="f-w-500">Employee Id <span class="pull-right">:</span>
                                                    </h5>
                                                </div>
                                                <div class="col-9"><span><?php echo e($user->employee_id); ?></span>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                        <?php if($user->role == "Client"): ?>
                                            <div class="row mb-2">
                                                <div class="col-3">
                                                    <h5 class="f-w-500">Staff <span class="pull-right">:</span>
                                                    </h5>
                                                </div>
                                                <div class="col-9">
                                                    <?php if($user->relateStaff()->first()): ?>
                                                        <span><?php echo e($user->relateStaff()->first()->name); ?></span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                            <div class="row mb-2">
                                                <div class="col-3">
                                                    <h5 class="f-w-500">Identification Number  <span class="pull-right">:</span>
                                                    </h5>
                                                </div>
                                                <div class="col-9"><span><?php echo e($user->ddd_id); ?></span>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                        
                                        <div class="row mb-2">
                                            <div class="col-3">
                                                <h5 class="f-w-500">Role <span class="pull-right">:</span>
                                                </h5>
                                            </div>
                                            <div class="col-9"><span><?php echo e($user->role); ?></span>
                                            </div>
                                        </div>
                                        <div class="row mb-2">
                                            <div class="col-3">
                                                <h5 class="f-w-500">Status <span class="pull-right">:</span>
                                                </h5>
                                            </div>
                                            <div class="col-9"><span><?php echo ($user->status == 1)? '<span class="badge light badge-success">Active</span>': '<span class="badge light badge-warning">Inactive</span>'; ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php if($user->role != "SuperAdmin" && $user->role != 'Client'): ?>
                                    <?php if($user->role == "Executive" && (checkPermission('addUserCategory', Auth::user()->role) || Auth::user()->role == 'SuperAdmin')): ?>
                                        <div id="categoryTab" class="tab-pane fade">
                                            <div class="pt-4">
                                                <div class="settings-form col-sm-6">
                                                    <h4 class="text-primary">Assign New Categories</h4>
                                                    <form id="assignCategoryToUserForm">
                                                        <div class="form-group">
                                                            <label>Choose Categories</label>
                                                            <select class="multi-select select2-dropdown" name="categories[]" multiple="multiple" required>
                                                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <option value="<?php echo e($category->id); ?>"><?php echo e($category->title); ?></option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>
                                                        </div>
                                                        <button class="btn btn-primary" type="submit">Assign</button>
                                                    </form>
                                                </div>
                                            </div>
                                            <div class="mt-4">
                                                <h4 class="text-primary mb-4">Assigned Categories</h4>
                                                <div class="table-responsive">
                                                    <table class="display listing-table" style="min-width: 845px">
                                                        <thead>
                                                        <tr>
                                                            <th>Sr</th>
                                                            <th>Title</th>
                                                            <th>Action</th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        <?php $__currentLoopData = $user->userCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <tr>
                                                                <td><?php echo e($loop->iteration); ?></td>
                                                                <td><?php echo e($item->title); ?></td>
                                                                <td>
                                                                    <a href="<?php echo e(route("portal.removeCategoryFromUserRequest", ["id" => $item->pivot->id])); ?>" class="deletedBtn btn btn-danger mr-1 shadow sharp"><i class="fa fa-trash"></i> Remove</a>
                                                                </td>
                                                            </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                <?php if($user->role == "Staff"): ?>
                                    <div id="clientsTab" class="tab-pane fade">
                                        <div class="pt-4">
                                            <div class="settings-form">
                                                <h4 class="text-primary">Add Clients</h4>
                                                <form id="assignClientToStaffForm">
                                                    <div class="form-group">
                                                        <label>Clients</label>
                                                        <select class="multi-select select2-dropdown" name="clients[]" multiple="multiple">
                                                            <?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($client->id); ?>"><?php echo e($client->name); ?> </option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                    </div>
                                                    <button class="btn btn-primary" type="submit">Add</button>
                                                </form>
                                            </div>
                                        </div>
                                        <div class="mt-4">
                                            <h4 class="text-primary mb-4">Assigned Clients</h4>
                                            <div class="table-responsive">
                                                <table class="display listing-table" style="min-width: 845px">
                                                    <thead>
                                                    <tr>
                                                        <th>Sr</th>
                                                        <th>Name</th>
                                                        
                                                        <th>Email</th>
                                                        <th>Action</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <?php $__currentLoopData = $user->staffClients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <tr>
                                                            <td><?php echo e($loop->iteration); ?></td>
                                                            <td><?php echo e($client->name); ?></td>
                                                            
                                                            <td><?php echo e($client->email); ?></td>
                                                            <td>
                                                                <div class="d-flex">
                                                                    <a href="<?php echo e(route("portal.viewUserPage", ["id" => $client->id])); ?>" class="btn btn-success shadow sharp mr-1" target="_blank"><i class="fa fa-cog"></i> Operations</a>
                                                                    <a href="<?php echo e(route("portal.removeClientFromStaffRequest", ["id" => $client->pivot->id])); ?>" class="deletedBtn btn btn-danger mr-1 shadow sharp"><i class="fa fa-trash"></i> Remove</a>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                    <div id="taskHistoryTab" class="tab-pane fade active show">
                                        <div class="mt-4">
                                            <h4 class="text-primary mb-4">Task History</h4>
                                            <div class="table-responsive">
                                                <table id="datatable2" class="display" style="min-width: 845px; width: 100%">
                                                    <thead>
                                                    <tr>
                                                        <th>Id</th>
                                                        <th>Sr</th>
                                                        <th>Sheet</th>
                                                        <th>Client</th>
                                                        <th>Created At</th>
                                                        <th>Action</th>
                                                    </tr>
                                                    </thead>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footerSource'); ?>
    <script src="<?php echo asset('admin-assets/vendor/select2/js/select2.full.min.js'); ?>"></script>
    <!-- Datatable -->
    <script src="<?php echo asset('admin-assets/vendor/datatables/js/jquery.dataTables.min.js'); ?>"></script>
    <script>
        $(document).ready(function (e) {
            $('.select2-dropdown').select2();

            // add client form submit
            $("#assignClientToStaffForm").submit(function (e) {
                e.preventDefault();
                let data = $(this).serialize()+"&id=<?php echo e($user->id); ?>";
                axios.post('<?php echo e(route("portal.assignClientToStaffRequest")); ?>', data)
                    .then(function (response) {
                        if(response.data.response_code == 1){
                            successMsg(response.data.message);
                            setTimeout(function () {
                                location.reload();
                            }, 1000);
                        } else {
                            errorMsg(response.data.message);
                        }
                    })
                    .catch(function (error) {

                    });
            });

            $("#assignCategoryToUserForm").submit(function (e) {
                e.preventDefault();
                let data = $(this).serialize()+"&id=<?php echo e($user->id); ?>";
                axios.post('<?php echo e(route("portal.assignCategoryToUserRequest")); ?>', data)
                    .then(function (response) {
                        if(response.data.response_code == 1){
                            successMsg(response.data.message);
                            setTimeout(function () {
                                location.reload();
                            }, 1000);
                        } else {
                            errorMsg(response.data.message);
                        }
                    })
                    .catch(function (error) {

                    });
            });

            // staff clients listing
            $('.listing-table').DataTable();

            // task history listing
            $('#datatable2').DataTable({
                processing: true,
                serverSide: true,
                ajax: '<?php echo route('portal.userTaskHistoryDatatable', ["id" => $user->id]); ?>',
                columns: [
                    { data: 'id', name: 'id', 'visible': false},
                    { data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false,searchable: false},
                    { data: 'sheet.name', name: 'sheet.name' },
                    { data: 'client.name', name: 'client.name' },
                    { data: 'created_at', name: 'created_at' },
                    { data: 'action', name: 'action', orderable: false},
                ],
                "order": [[0, 'desc']],
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/bbcareapp/resources/views/portal/users/viewUser.blade.php ENDPATH**/ ?>