

<?php $__env->startSection('title', 'Add New Task Sheet'); ?>

<?php $__env->startSection('headSource'); ?>
<link rel="stylesheet" href="<?php echo asset('admin-assets/vendor/select2/css/select2.min.css'); ?>">
<link href="<?php echo asset('admin-assets/vendor/bootstrap-select/dist/css/bootstrap-select.min.css'); ?>" rel="stylesheet">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row page-titles mx-0">
        <div class="col-sm-6 p-md-0">
            <div class="welcome-text">
                <h4>Add New Task Sheet</h4>
            </div>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('portal.dashboard')); ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route('portal.dataSheetListPage')); ?>">Task Sheets</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Add New Task Sheet</a></li>
            </ol>
        </div>
    </div>

    <div class="row">
        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 col-xl-12">
            <div class="card mb-3">
                <div class="card-header">
                    <h3><i class="fa fa-list-alt"></i> Task Sheet details</h3>
                </div>
                <div class="card-body">
                    <form id="dataSheetAddForm" method="post">
                        <div class="row">
                            <div class="col-lg-12 col-xl-12">
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Sheet name (required)</label>
                                            <input class="form-control" name="name" type="text" required />
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Select Categories (required)</label>
                                            <select class="multi-select select2-dropdown" name="categories[]" multiple="multiple" required>
                                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($category->id); ?>"><?php echo e($category->title); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Add Additional Message</label>
                                            <select class="form-control form-control-lg" name="add_additional_msg" required>
                                                <option value="1">Yes</option>
                                                <option value="0">No</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <button type="submit" class="btn btn-primary">Add Task Sheet</button>
                            </div>
                        </div>
                    </form>
                </div>
                <!-- end card-body -->
            </div>
            <!-- end card -->
        </div>
        <!-- end col -->
    </div>
    <!-- end row -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footerSource'); ?>
<script src="<?php echo asset('admin-assets/vendor/select2/js/select2.full.min.js'); ?>"></script>
<script>
    $(document).ready(function () {
        $('.select2-dropdown').select2({placeholder: 'Select Categories'});
        // add Task Sheet form submit
        $("#dataSheetAddForm").submit(function (e) {
            e.preventDefault();
            let data = $(this).serialize();
            axios.post('<?php echo e(route("portal.addNewDataSheetRequest")); ?>', data)
                .then(function (response) {
                    if(response.data.response_code == 1){
                        successMsg(response.data.message);
                        setTimeout(function () {
                            location.href = response.data.data.redirect_url;
                        }, 1000);
                    } else {
                        errorMsg(response.data.message);
                    }
                })
                .catch(function (error) {

                });
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/bbcareapp/resources/views/portal/dataSheets/addDataSheet.blade.php ENDPATH**/ ?>