

<?php $__env->startSection('title', 'Task Report'); ?>

<?php $__env->startSection('headSource'); ?>
    <link rel="stylesheet" href="<?php echo asset('admin-assets/vendor/select2/css/select2.min.css'); ?>">
    <link href="<?php echo asset('admin-assets/vendor/bootstrap-select/dist/css/bootstrap-select.min.css'); ?>"
          rel="stylesheet">
    <!-- Datatable -->
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.dataTables.min.css">
    <link rel="stylesheet" href="<?php echo asset('admin-assets/vendor/datatables/css/jquery.dataTables.min.css'); ?>">

    <link rel="stylesheet" href="<?php echo asset('admin-assets/vendor/bootstrap-daterangepicker/daterangepicker.css'); ?>">
    <style>
        .dataTables_wrapper .dt-buttons {
            width: 100%;
        }

        .dataTables_wrapper .dt-buttons .buttons-excel {
            background: #2f4cdd;
            color: #fff
        }

        .dataTables_wrapper .dt-buttons .buttons-excel:hover {
            background-color: #203cc5 !important;
            border-color: #1e38bb !important;
        }

        .select2-container--default .select2-selection--single {
            height: 45px;
        }

        .select2-container--default .select2-selection--single .select2-selection__rendered {
            line-height: 45px;
        }

        .select2-container--default .select2-selection--single .select2-selection__arrow {
            height: 45px;
        }

        .select2-container--default .select2-selection--multiple .select2-selection__rendered {
            height: 40px;
        }

        .form-check-input {
            height: 15px;
            width: 15px;
        }

    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row page-titles mx-0">
        <div class="col-sm-6 p-md-0">
            <div class="welcome-text">
                <h4>Task Report</h4>
            </div>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('portal.dashboard')); ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route('portal.dataSheetListPage')); ?>">Task Sheets</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Report</a></li>
            </ol>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card" style="height: auto">
                <div class="card-header">
                    <h4 class="card-title">Task Reporting</h4>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-6 form-group">
                            <label for="staffDate">Date Range</label>
                            <input id="staffDate" type="text" class="daterange-picker form-control"
                                   value="<?php echo e(date('m/d/Y') . ' - ' . date('m/d/Y')); ?>"/>
                            <input type="hidden" id="startDate" value="<?php echo e(date('m/d/Y')); ?>">
                            <input type="hidden" id="endDate" value="<?php echo e(date('m/d/Y')); ?>">
                        </div>
                        <div class="col-sm-6 form-group">
                            <label>Report Type</label><br>
                            <div class="form-check-inline">
                                <label class="form-check-label" for="staffWise">
                                    <input type="radio" class="form-check-input report-type" id="staffWise"
                                           name="reportType"
                                           value="1" checked>Staff</label>
                            </div>
                            <div class="form-check-inline">
                                <label class="form-check-label" for="clientWise">
                                    <input type="radio" class="form-check-input report-type" id="clientWise"
                                           name="reportType"
                                           value="2">Client</label>
                            </div>
                        </div>
                        <?php if(Auth::user()->role == 'SuperAdmin'): ?>
                            <div class="col-sm-6 form-group">
                                <label for="coordinatorSel">Select Coordinator</label>
                                <select id="coordinatorSel" onchange="getExecutives(this)"
                                        class="form-control form-control-lg select2-dropdown">
                                    <option value="" selected>All</option>
                                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option
                                            value="<?php echo e($user->id); ?>"><?php echo e($user->name ? $user->name : $user->email); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-sm-6 form-group">
                                <label for="executiveSel">Select Executive</label>
                                <select id="executiveSel" class="form-control form-control-lg select2-dropdown"
                                        onchange="getStaffMembers(this)" disabled>
                                    <option value="" selected>All</option>
                                </select>
                            </div>
                            <div id="staffDropdown" class="col-sm-12 form-group">
                                <label for="staffSel">Select Staff Members</label>
                                <select id="staffSel" class="form-control form-control-lg select2-dropdown"
                                        multiple="multiple" disabled></select>
                            </div>

                            <div id="clientDropdown" class="col-sm-12 form-group" style="display: none">
                                <label for="clientSel">Select Clients</label>
                                <select id="clientSel" class="form-control form-control-lg select2-dropdown"
                                        multiple="multiple" disabled></select>
                            </div>
                        <?php endif; ?>

                        <?php if(Auth::user()->role == 'Coordinator'): ?>
                            <div class="col-sm-12 form-group">
                                <label for="executiveSel">Select Executive</label>
                                <select id="executiveSel" class="form-control form-control-lg select2-dropdown"
                                        onchange="getStaffMembers(this)">
                                    <option value="" selected>All</option>
                                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option
                                            value="<?php echo e($user->id); ?>"><?php echo e($user->name ? $user->name : $user->email); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div id="staffDropdown" class="col-sm-12 form-group">
                                <label for="staffSel">Select Staff Members</label>
                                <select id="staffSel" class="form-control form-control-lg select2-dropdown"
                                        multiple="multiple" disabled></select>
                            </div>

                            <div id="clientDropdown" class="col-sm-12 form-group" style="display: none">
                                <label for="clientSel">Select Clients</label>
                                <select id="clientSel" class="form-control form-control-lg select2-dropdown"
                                        multiple="multiple" disabled></select>
                            </div>
                        <?php endif; ?>
                        <?php if(Auth::user()->role == 'Executive'): ?>
                            <div id="staffDropdown" class="col-sm-12 form-group">
                                <label for="staffSel">Select Staff Members</label>
                                <select id="staffSel" class="form-control form-control-lg select2-dropdown"
                                        multiple="multiple">
                                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option
                                            value="<?php echo e($user->id); ?>"><?php echo ($user->name ? $user->name : $user->email) . (' (' . $user->role .')'); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div id="clientDropdown" class="col-sm-12 form-group" style="display: none">
                                <label for="clientSel">Select Clients</label>
                                <select id="clientSel" class="form-control form-control-lg select2-dropdown"
                                        multiple="multiple">
                                    <?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option
                                            value="<?php echo e($client->id); ?>"><?php echo e($client->name ? $client->name : $client->email); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        <?php endif; ?>
                        <div class="col-sm-12 text-right">
                            <button type="button" class="btn btn-sm btn-primary" onclick="getReport()">Search
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <div id="reportCard" style="display: none">
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="reportListing" class="display" style="min-width: 845px">
                            <thead>
                            <tr>
                                <th>Sr</th>
                                <th>Sheet</th>
                                <th>Staff</th>
                                <th>Client</th>
                                <th>Created At</th>
                            </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('footerSource'); ?>
    <script src="<?php echo asset('admin-assets/vendor/select2/js/select2.full.min.js'); ?>"></script>
    <!-- Datatable -->
    <script src="<?php echo asset('admin-assets/vendor/datatables/js/jquery.dataTables.min.js'); ?>"></script>
    <script type="text/javascript"
            src="https://cdn.datatables.net/buttons/1.3.1/js/dataTables.buttons.min.js"></script>
    <script type="text/javascript"
            src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script type="text/javascript"
            src="https://cdn.datatables.net/buttons/1.3.1/js/buttons.html5.min.js"></script>
    <!-- DateRange -->
    <script src="<?php echo asset('admin-assets/vendor/moment/moment.min.js'); ?>"></script>
    <script
        src="<?php echo asset('admin-assets/vendor/bootstrap-daterangepicker/daterangepicker.js'); ?>"></script>
    <script>
        const userId = '<?php echo e(Auth::user()->id); ?>', userRole = '<?php echo e(Auth::user()->role); ?>';
        $(document).ready(function () {
            $('.select2-dropdown').select2();

            $('.daterange-picker').daterangepicker({}, function (start, end) {
                $('#startDate').val(start.format('MM/DD/YYYY'));
                $('#endDate').val(end.format('MM/DD/YYYY'));

            });
            // list table
            initDatatable();

            $('.report-type').click(function () {
                if ($(this).val() == '2') {
                    $('#staffDropdown').hide();
                    $('#clientDropdown').show();
                } else {
                    $('#clientDropdown').hide();
                    $('#staffDropdown').show();
                }
            });
        });

        function initDatatable() {
            $('#reportListing').DataTable({
                paging: true,
                lengthMenu: [[10, 20, 50, 100, -1], [10, 20, 50, 100, "All"]],
                pageLength: 20,
                dom: 'Blfrtip',
                buttons: [
                    {
                        extend: 'excel',
                        text: '<i class="mdi mdi-export"></i> Export to Excel',
                        titleAttr: 'Excel Export'
                    }
                ]
            });
        }

        function getExecutives(elem) {
            getUsers($(elem).val(), 'Executive', '#executiveSel');
            $('#staffSel').empty().trigger('change');
            $('#clientSel').empty().trigger('change');
        }

        function getStaffMembers(elem) {
            let executiveId = $(elem).val();
            getUsers(executiveId, 'Manager,Admin,Staff', '#staffSel', true, true);
            getUsers(executiveId, 'Client', '#clientSel');
        }

        function getUsers(branchId, role, userSelector, showRole = false, appendParent = false) {
            let queryParams = `?branchId=${branchId}&role=${role}`;
            queryParams += appendParent ? `&appendParent=1` : '';
            axios.get('<?php echo e(url('/admin/dashboard/users/get-users')); ?>' + queryParams,).then((response) => {

                if (response.data.response_code) {
                    let optionsArr = [{id: '', text: 'All'}];
                    if(appendParent) {
                        let parent = response.data.data.parent;
                        optionsArr.push({
                            id: parent.id,
                            text: (parent.name || parent.email) + (showRole ? ` (${parent.role})` : '')
                        });
                    }
                    $.each(response.data.data.users, function (idx, item) {
                        optionsArr.push({
                            id: item.id,
                            text: (item.name || item.email) + (showRole ? ` (${item.role})` : '')
                        });
                    });
                    $(userSelector).select2('destroy').empty().removeAttr('disabled').select2({data: optionsArr});
                }
            }).catch((error) => {
                console.log(error);
            });
        }

        function getReport() {
            let reportType = $('input[name=reportType]:checked').val(), startDate = $('#startDate').val(),
                endDate = $('#endDate').val(), staff = $('#staffSel').val(), client = $('#clientSel').val(),
                queryParams = `?start=${startDate}&end=${endDate}&reportType=${reportType}&staff=${staff}&client=${client}`;
            let coordinatorId = $('#coordinatorSel').val(), executiveId = $('#executiveSel').val();
            if (userRole == 'Executive') {
                coordinatorId = '<?php echo e(Auth::user()->branch_id); ?>';
                queryParams += `&executive=${userId}&coordinator=${coordinatorId}`;
            } else if (userRole == 'Coordinator') {
                queryParams += `&executive=${executiveId}&coordinator=${userId}`;
            } else {
                queryParams += `&executive=${executiveId}&coordinator=${coordinatorId}`;
            }
            axios.get('<?php echo e(url('/admin/dashboard/task-reports/get-history-report')); ?>' + queryParams,).then((response) => {
                $('#reportListing').DataTable().clear().draw().destroy();
                $('#reportCard').html(response.data).show();
                initDatatable();
            }).catch((error) => {
                console.log(error);
            });
        }

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/bbcareapp/resources/views/portal/taskReports/history-report.blade.php ENDPATH**/ ?>