<?php

namespace App\Http\Controllers\ApiController\StaffController;

use App\Services\DataSheetService;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class DataSheetController extends Controller
{
    // data sheet listing
    public function dataSheetListing(DataSheetService $dataSheetService){
        return $dataSheetService->activeDataSheetListingApi();
    }

    // data sheet tasks
    public function dataSheetTasks($id, DataSheetService $dataSheetService){
        return $dataSheetService->dataSheetTasks($id);
    }

    // generate data sheet progress note
    public function generateSheetProgressNote(Request $request, DataSheetService $dataSheetService){
        $request = json_decode($request->get('data'));
        return $dataSheetService->generateSheetProgressNote($request);
    }

    // save data sheet tasks
    public function saveSheetTasks(Request $request, DataSheetService $dataSheetService){
        $request = json_decode($request->get('data'));
        return $dataSheetService->saveSheetTasks($request);
    }
}
