<?php


namespace App\Services;


use Carbon\Carbon;

class HelperServices
{
    // return json response
    static function returnJsonResponse($responseCode, $msg, $data = [], $errors = [], $statusCode = 200){
        $data = HelperServices::replace_null_with_empty_string(json_decode(json_encode($data),1));

        $response = [
            'response_code' => $responseCode,
            'message'=> $msg,
            'data' => $data,
            'errors' => $errors,
        ];

        return response()->json($response, $statusCode);
    }
    static function replace_null_with_empty_string($array){
        $integer_fields = ['to','from','last_page','per_page'];
        foreach ($array as $key => $value)
        {
            if(is_array($value)){
                $array[$key] = HelperServices::replace_null_with_empty_string($value);
            }else{
                if (is_null($value)){
                    if(in_array($key,$integer_fields)){
                        $array[$key] = 0;
                    }else{
                        $array[$key] = "";
                    }
                }
            }
        }
        return $array;
    }
    // validation error format
    static function validationErrorFormat($errors){
        $errorArray = array();
        foreach(json_decode(json_encode($errors)) as $key=>$error){
            $errorArray[$key] =  $error[0];
        }
        return $errorArray;
    }

    // date & time format apply
    static function dateTimeFormat($date, $format = "M d, Y h:i a"){
        return Carbon::parse($date)->format($format);
    }

    // make directory
    static function makeDir($dirpath, $mode=0644){
        return is_dir($dirpath) || mkdir($dirpath, $mode, true);
    }

    // remove folders & files inside of directory
    static function recursiveRemoveDirectory($directory){
        if(!is_dir($directory)){
            return true;
        }
        foreach(glob("{$directory}/*") as $file){
            if(is_dir($file)) {
                self::recursiveRemoveDirectory($file);
            } else {
                unlink($file);
            }
        }
        rmdir($directory);
    }

    // pagination array response return
    static function returnPaginationArr($pagination, $data){
        return [
            "current_page" => $pagination->currentPage(),
            "from" => $pagination->firstItem(),
            "last_page" => $pagination->lastPage(),
            "per_page" => $pagination->perPage(),
            "to" => $pagination->lastItem(),
            "total" => $pagination->total(),
            "data" => $data,
        ];
    }

    // get dates between two dates
    public static function getDatesBwDates($from, $to){
        $period = \Carbon\CarbonPeriod::create($from, '1 day', $to);
        $returnData = [];
        foreach ($period as $dt) {
            $returnData[] = $dt->format("d M");
        }
        return $returnData;
    }

    public static function arrayLoopGenModified($records){
        foreach($records as $key => $val){
            if(is_array($val)){
                $records[$key] = self::arrayLoopGenModified($val);
            } else {
                $records[$key] = self::nullToString($val);
            }
        }
        return $records;
    }

    // make string if response have null value
    public static function nullToString($value){
        return ($value != NULL)? $value : "";
    }
}
