<?php

namespace App\Http\Controllers\PortalController;

use App\Services\TaskReportService;
use App\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class TaskReportController extends Controller
{
    // task history datatable request
    public function userTaskHistoryRequest($id, TaskReportService $taskReportService){
        return $taskReportService->userTaskHistoryAjaxList($id);
    }

    // view task report page
    public function viewTaskReport($id, TaskReportService $taskReportService){
        $user = User::find($id);
        if (checkPermission('deleteUser',$user->role)  ($user->branch_id==Auth::user()->id || Auth::user()->role=='SuperAdmin')) {
            return $taskReportService->viewTaskReportPage($id);
        }
        return view("auth.login");
    }
}
