<?php


namespace App\Services;

use App\OauthAccessToken;
use App\User;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;

class AuthService
{

    // login request
    public function loginRequest($request){
        $customMsgs = [
            'login.required' => 'Please enter username.',
            //'email.email' => 'Please type correct email.',
            //'email.exists' => 'Email/Password are not correct.',
            'password.required' => 'Please enter password.',
        ];
        $validator = Validator::make($request->all(),[
            'login' => 'required',
            'password' => 'required'
        ], $customMsgs);

        $loginField = $request->login;
        $credentials = null;

        if ($validator->fails()) {
            $errorArray = HelperServices::validationErrorFormat($validator->errors());
            return HelperServices::returnJsonResponse(2, 'Validation Errors', [], $errorArray, 422);
        }
        $loginType = filter_var($loginField, FILTER_VALIDATE_EMAIL) ? 'email' : 'username';

        request()->merge([ $loginType => $loginField ]);

        $credentials = $request->only($loginType, 'password');

        if (Auth::attempt($credentials)) {
            if(Auth::user()->status == 1){
                return HelperServices::returnJsonResponse(1, 'Login successfully', [], [], 200);
            } else {
                Auth::logout();
                return HelperServices::returnJsonResponse(0, 'You have not permission to access', [], [], 403);
            }
        } else {
            return HelperServices::returnJsonResponse(0, 'Email/Password are not correct.', [], [], 401);
        }
    }

    // logout request
    public function logoutRequest(){
        User::where(["id" => Auth::id()])->update(["updated_at" => new \DateTime()]);
        Auth::logout();
        return redirect()->route("portal.loginPage");
    }

    // staff sign in api
    public function staffSignInApi($request){
        $customMsgs = [
            'username.required' => 'Please enter username.',
            //'username.exists' => 'Username/Password are not correct.',
            'password.required' => 'Please enter password.',
            'login_from.required' => 'Error, please provide login with value from following values. Android, IOS',
            'login_from.in' => 'Error, please provide login with value from following values. Android, IOS',
            'device_id.required' => 'Error, Device id not found.',
        ];
        $validator = Validator::make($request->all(),[
            'username' => 'required',
            'password'=>'required',
            'login_from'=>'required|in:Android,IOS',
            'device_id'=>'required',
        ], $customMsgs);

        if ($validator->fails()) {
            $errorArray = HelperServices::validationErrorFormat($validator->errors());
            return HelperServices::returnJsonResponse(2, 'Validation Errors', [], $errorArray, 200);
        }

        $user = User::where(["username" => $request->username])->orWhere(["email" => $request->username])->first();
        if ($user) {
            if (!Hash::check($request->password, $user->password)) {
                return HelperServices::returnJsonResponse(0, 'Username/Password are not correct.');
            } else {
                if($user->role == "Staff" && $user->status == 1){
                    $accessToken = $user->setAppToken($request->login_from, $request->device_id);
                    //User::where('id', $user->id)->update(['login_from' => $request->login_from, "updated_at" => new \DateTime()]);
                    $user = HelperServices::arrayLoopGenModified($user->toArray());
                    return HelperServices::returnJsonResponse(1, 'Login successfully', ['user' => $user, 'access_token' => $accessToken]);
                } else {
                    return HelperServices::returnJsonResponse(0, 'denied access; contact administrator.');
                }
            }
        } else {
            return HelperServices::returnJsonResponse(0, 'Username/Password are not correct.');
        }
    }
}
