@extends('layouts.app')

@section('title', 'View Task Report')

@section('headSource')

@endsection

@section('content')

    <div class="row page-titles mx-0">
        <div class="col-sm-6 p-md-0">
            <div class="welcome-text">
                <h4>View Task Report</h4>
            </div>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Task Reports</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">View Task Report</a></li>
            </ol>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <div class="card card-body">
                <h4 class="text-primary mb-4">Detail</h4>
                <div class="row mb-2">
                    <div class="col-3">
                        <h5 class="f-w-500">Sheet Title <span class="pull-right">:</span>
                        </h5>
                    </div>
                    <div class="col-9"><span>{{$data->sheet->name}}</span>
                    </div>
                </div>
                <div class="row mb-2">
                    <div class="col-3">
                        <h5 class="f-w-500">Staff name <span class="pull-right">:</span>
                        </h5>
                    </div>
                    <div class="col-9"><span>{{$data->staff->name}}</span>
                    </div>
                </div>
                <div class="row mb-2">
                    <div class="col-3">
                        <h5 class="f-w-500">Client name <span class="pull-right">:</span>
                        </h5>
                    </div>
                    <div class="col-9"><span>{{$data->client->name}}</span>
                    </div>
                </div>
                <div class="row mb-2">
                    <div class="col-3">
                        <h5 class="f-w-500">Created at <span class="pull-right">:</span>
                        </h5>
                    </div>
                    <div class="col-9"><span>{{$data->created_at->format("d F, Y g:i A")}}</span>
                    </div>
                </div>
                <div class="row mb-2">
                    <div class="col-3">
                        <h5 class="f-w-500">Additional message <span class="pull-right">:</span>
                        </h5>
                    </div>
                    <div class="col-9"><span>{{$data->additional_message}}</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <div class="card card-body">
                <h4 class="text-primary mb-4">Progress Note</h4>
                <div>
                    {!! $data->progress_note !!}
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Task Report</h4>
                </div>
                <div class="card-body">
                    <div class="basic-list-group">
                        <div class="list-group">
                            @foreach($data->reportData as $record)
                                <div class="list-group-item list-group-item-action flex-column align-items-start">
                                    <div class="d-flex w-100 justify-content-between">
                                        <h3 class="mb-3">{{$record->question->title}}</h3>
                                    </div>
                                    <p class="mb-1">{{$record->answer->answer}}</p>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('footerSource')

@endsection
