@extends('layouts.app')

@section('title', 'View User')

@section('headSource')
    <link rel="stylesheet" href="{!! asset('admin-assets/vendor/select2/css/select2.min.css') !!}">
    <link href="{!! asset('admin-assets/vendor/bootstrap-select/dist/css/bootstrap-select.min.css') !!}" rel="stylesheet">
    <!-- Datatable -->
    <link rel="stylesheet" href="{!! asset('admin-assets/vendor/datatables/css/jquery.dataTables.min.css') !!}">
@endsection

@section('content')

    <div class="row page-titles mx-0">
        <div class="col-sm-6 p-md-0">
            <div class="welcome-text">
                <h4>Role Grant Access</h4>
            </div>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Users</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)"></a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Permissions</a></li>
            </ol>
        </div>
    </div>



    <div class="row">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">
                    <div class="profile-tab">
                        <div class="custom-tab-1">

                            <div class="tab-content">
                                <div id="aboutTab" class="tab-pane fade active show">
                                    <div class="profile-personal-info">
                                        <form id="userPermissions" method="post">
                                            <p style="width:300px">Role: <select id="roleChanger" class="form-control form-control-lg" name="role">
                                                    <option value="SuperAdmin" @if($type=='SuperAdmin') selected="selected" @endif>Super Admin</option>
                                                    <option value="Executive" @if($type=='Executive') selected="selected" @endif>Executive</option>
                                                    <option value="Admin" @if($type=='Admin') selected="selected" @endif>Admin</option>
                                                    <option value="Staff" @if($type=='Staff') selected="selected" @endif>Staff</option>
                                                    <option value="Client" @if($type=='Client') selected="selected" @endif>Client</option>
                                                </select></p>
                                        <h4 class="text-primary mb-4 mt-4">Users </h4>
                                        <div class="row mb-2" style="padding:15px">

                                            <table style="width:100%">
                                                <tr>
                                                    <th style="width:40%">Permission</th><th>Add</th><th>Update</th><th>View</th><th>Delete</th>
                                                </tr>
                                                <tr>
                                                    <td>Super Admin User</td>
                                                    <td>
                                                        <input type="checkbox" name="user_permissions[]" value="addUser_superadmin"  {{ isPermission('addUser_superadmin', $type) ? 'checked' : '' }}> </td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="editUser_superadmin" {{ isPermission('editUser_superadmin', $type) ? 'checked' : '' }}> </td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="viewUser_superadmin" {{ isPermission('viewUser_superadmin', $type) ? 'checked' : '' }}> </td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="deleteUser_superadmin" {{ isPermission('deleteUser_superadmin', $type) ? 'checked' : '' }}> </td>
                                                </tr>
                                                <tr>
                                                    <td>Executive User</td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="addUser_executive" {{ isPermission('addUser_executive', $type) ? 'checked' : '' }}> </td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="editUser_executive" {{ isPermission('editUser_executive', $type) ? 'checked' : '' }}> </td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="viewUser_executive" {{ isPermission('viewUser_executive', $type) ? 'checked' : '' }}> </td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="deleteUser_executive" {{ isPermission('deleteUser_executive', $type) ? 'checked' : '' }}> </td>
                                                </tr>
                                                <tr>
                                                    <td>Admin User</td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="addUser_admin" {{ isPermission('addUser_admin', $type) ? 'checked' : '' }}> </td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="editUser_admin" {{ isPermission('editUser_admin', $type) ? 'checked' : '' }}> </td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="viewUser_admin" {{ isPermission('viewUser_admin', $type) ? 'checked' : '' }}> </td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="deleteUser_admin" {{ isPermission('deleteUser_admin', $type) ? 'checked' : '' }}> </td>
                                                </tr>
                                                <tr>
                                                    <td>Staff User</td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="addUser_staff" {{ isPermission('addUser_staff', $type) ? 'checked' : '' }}> </td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="editUser_staff" {{ isPermission('editUser_staff', $type) ? 'checked' : '' }}> </td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="viewUser_staff" {{ isPermission('viewUser_staff', $type) ? 'checked' : '' }}> </td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="deleteUser_staff" {{ isPermission('deleteUser_staff', $type) ? 'checked' : '' }}> </td>
                                                </tr>
                                                <tr>
                                                    <td>Client User</td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="addUser_client" {{ isPermission('addUser_client', $type) ? 'checked' : '' }}> </td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="editUser_client" {{ isPermission('editUser_client', $type) ? 'checked' : '' }}> </td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="viewUser_client" {{ isPermission('viewUser_client', $type) ? 'checked' : '' }}> </td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="deleteUser_client" {{ isPermission('deleteUser_client', $type) ? 'checked' : '' }}> </td>
                                                </tr>
                                            </table>

                                        </div>

                                        <h4 class="text-primary mb-4 mt-4">Task Sheets </h4>
                                        <div class="row mb-2" style="padding:15px">
                                            <table style="width:100%">
                                                <tr>
                                                    <th style="width:40%">Permission</th><th>Add</th><th>Update</th><th>View</th><th>Delete</th>
                                                </tr>
                                                <tr>
                                                    <td>Task Sheet</td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="addNewSheet_{{$type}}" {{ isPermission('addNewSheet_'.$type, $type) ? 'checked' : '' }}> </td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="editSheet_{{$type}}" {{ isPermission('editSheet_'.$type, $type) ? 'checked' : '' }}> </td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="viewSheetUser_{{$type}}" {{ isPermission('viewSheetUser_'.$type, $type) ? 'checked' : '' }}> </td>
                                                    <td><input type="checkbox" name="user_permissions[]" value="deleteSheet_{{$type}}" {{ isPermission('deleteSheet_'.$type, $type) ? 'checked' : '' }}> </td>
                                                </tr>

                                            </table>

                                        </div>
                                        <input type="submit" class="btn btn-primary" name="submit" value="Save"/>
                                        </form>

                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('footerSource')
    <!-- Daterangepicker -->
    <!-- momment js is must -->
    <script src="{!! asset('admin-assets/vendor/moment/moment.min.js') !!}"></script>
    <script src="{!! asset('admin-assets/vendor/bootstrap-daterangepicker/daterangepicker.js') !!}"></script>
    <script>


        $(document).ready(function () {


            $("#roleChanger").change(function(e){
               let value = $(this).val();
                window.location = "{{url("admin/dashboard/users/permissions")}}/" + $(this).val();
            });

            // add user form submit
            $("#userPermissions").submit(function (e) {
                e.preventDefault();
                let data = new FormData($(this)[0]);
                axios.post('{{route("portal.addUserPermissions")}}', data)
                    .then(function (response) {
                        if(response.data.response_code == 1){
                            successMsg(response.data.message);
                        } else {
                            errorMsg(response.data.message);
                        }
                    })
                    .catch(function (error) {

                    });
            });
        });
    </script>
@endsection
