<?php $__env->startSection('title', 'Add New Task Sheet'); ?>

<?php $__env->startSection('headSource'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row page-titles mx-0">
        <div class="col-sm-6 p-md-0">
            <div class="welcome-text">
                <h4>Add New Task Sheet</h4>
            </div>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Task Sheets</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Add New Task Sheet</a></li>
            </ol>
        </div>
    </div>

    <div class="row">
        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 col-xl-12">
            <div class="card mb-3">
                <div class="card-header">
                    <h3><i class="fa fa-list-alt"></i> Task Sheet details</h3>
                </div>
                <div class="card-body">
                    <form id="dataSheetAddForm" method="post">
                        <div class="row">
                            <div class="col-lg-12 col-xl-12">
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Sheet name (required)</label>
                                            <input class="form-control" name="name" type="text" required />
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Add Additional Message</label>
                                            <select class="form-control form-control-lg" name="add_additional_msg" required>
                                                <option value="1">Yes</option>
                                                <option value="0">No</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <button type="submit" class="btn btn-primary">Add Task Sheet</button>
                            </div>
                        </div>
                    </form>
                </div>
                <!-- end card-body -->
            </div>
            <!-- end card -->
        </div>
        <!-- end col -->
    </div>
    <!-- end row -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footerSource'); ?>

<script>
    $(document).ready(function () {
        // add Task Sheet form submit
        $("#dataSheetAddForm").submit(function (e) {
            e.preventDefault();
            let data = $(this).serialize();
            axios.post('<?php echo e(route("portal.addNewDataSheetRequest")); ?>', data)
                .then(function (response) {
                    if(response.data.response_code == 1){
                        successMsg(response.data.message);
                        setTimeout(function () {
                            location.href = response.data.data.redirect_url;
                        }, 1000);
                    } else {
                        errorMsg(response.data.message);
                    }
                })
                .catch(function (error) {

                });
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\health_app\resources\views/portal/dataSheets/addDataSheet.blade.php ENDPATH**/ ?>