

<?php $__env->startSection('title', 'Add Sheet Task'); ?>

<?php $__env->startSection('headSource'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row page-titles mx-0">
        <div class="col-sm-6 p-md-0">
            <div class="welcome-text">
                <h4>Add New Task</h4>
            </div>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Task Sheets</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">View Task Sheets</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Add New Task</a></li>
            </ol>
        </div>
    </div>

    <div class="row">
        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 col-xl-12">
            <div class="card mb-3">
                <div class="card-header">
                    <h3><i class="fa fa-list-alt"></i> Task detail</h3>
                </div>
                <div class="card-body">
                    <form id="sheetTaskAddForm" method="post">
                        <div class="row">
                            <div class="col-lg-12 col-xl-12">
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label>Title (required)</label>
                                            <textarea class="form-control" name="title" required></textarea>
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label>Progress Note (required)</label>
                                            <textarea id="progressNote" class="form-control" name="progress_note" required></textarea>
                                        </div>
                                        <div class="mb-3">
                                            <span class="badge badge-secondary insertTag" data-toggle="tooltip" title="Jhon Doe" style="cursor: pointer;" data-tag="##ClientFullName##">##ClientFullName##</span>
                                            <span class="badge badge-secondary insertTag" data-toggle="tooltip" title="Jhon" style="cursor: pointer;" data-tag="##ClientFirstName##">##ClientFirstName##</span>
                                            <span class="badge badge-secondary insertTag" data-toggle="tooltip" title="He/She" style="cursor: pointer;" data-tag="##ClientGenderNoun##">##ClientGenderNoun##</span>
                                            <span class="badge badge-secondary insertTag" data-toggle="tooltip" title="Selected Answer" style="cursor: pointer;" data-tag="##AnswerPrompt##">##AnswerPrompt##</span>
                                        </div>
                                    </div>
                                    <div class="col-lg-12 mt-3">
                                        <div class="form-group">
                                            <label>Progress Note For Independent Prompt (required)</label>
                                            <textarea id="progressNoteIndependent" class="form-control" name="progress_note_independent" required></textarea>
                                        </div>
                                        <div class="mb-3">
                                            <span class="badge badge-secondary insertTagInd" data-toggle="tooltip" title="Jhon Doe" style="cursor: pointer;" data-tag="##ClientFullName##">##ClientFullName##</span>
                                            <span class="badge badge-secondary insertTagInd" data-toggle="tooltip" title="Jhon" style="cursor: pointer;" data-tag="##ClientFirstName##">##ClientFirstName##</span>
                                            <span class="badge badge-secondary insertTagInd" data-toggle="tooltip" title="He/She" style="cursor: pointer;" data-tag="##ClientGenderNoun##">##ClientGenderNoun##</span>
                                            
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <button type="submit" class="btn btn-primary">Add Task</button>
                            </div>
                        </div>
                    </form>
                </div>
                <!-- end card-body -->
            </div>
            <!-- end card -->
        </div>
        <!-- end col -->
    </div>
    <!-- end row -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footerSource'); ?>

<script>
    $(document).ready(function () {
        // insert tag in progress note
        $(".insertTag").click(function (e) {
            let tag = $(this).data("tag");
            let noteTxt = $("#progressNote").val();
            let upDateNoteTxt = noteTxt+' '+tag+' ';
            $("#progressNote").val(upDateNoteTxt);
        });
        $(".insertTagInd").click(function (e) {
            let tag = $(this).data("tag");
            let noteTxt = $("#progressNoteIndependent").val();
            let upDateNoteTxt = noteTxt+' '+tag+' ';
            $("#progressNoteIndependent").val(upDateNoteTxt);
        });

        // tooltip
        $('[data-toggle="tooltip"]').tooltip();

        // add sheet task form submit
        $("#sheetTaskAddForm").submit(function (e) {
            e.preventDefault();
            let data = $(this).serialize()+"&data_sheet_id=<?php echo e($sheetId); ?>";
            axios.post('<?php echo e(route("portal.addSheetTaskRequest")); ?>', data)
                .then(function (response) {
                    if(response.data.response_code == 1){
                        successMsg(response.data.message);
                        setTimeout(function () {
                            location.href = response.data.data.redirect_url;
                        }, 1000);
                    } else {
                        errorMsg(response.data.message);
                    }
                })
                .catch(function (error) {

                });
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/sites/health_app/resources/views/portal/dataSheets/sheetTasks/addSheetTask.blade.php ENDPATH**/ ?>