<?php $__env->startSection('title', 'Edit Data Sheet'); ?>

<?php $__env->startSection('headSource'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row page-titles mx-0">
        <div class="col-sm-6 p-md-0">
            <div class="welcome-text">
                <h4>Edit Data Sheet</h4>
            </div>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Data Sheets</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Edit Data Sheet</a></li>
            </ol>
        </div>
    </div>

    <div class="row">
        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 col-xl-12">
            <div class="card mb-3">
                <div class="card-header">
                    <h3><i class="fa fa-list-alt"></i> Data Sheet details</h3>
                </div>
                <div class="card-body">
                    <form id="dataSheetEditForm" method="post">
                        <div class="row">
                            <div class="col-lg-12 col-xl-12">
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Sheet name (required)</label>
                                            <input class="form-control" name="name" type="text" value="<?php echo e($record->name); ?>" required />
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Add Additional Message</label>
                                            <select class="form-control form-control-lg" name="add_additional_msg" required>
                                                <option value="1" <?php echo e(($record->add_additional_msg == 1)? "selected": ""); ?>>Yes</option>
                                                <option value="0" <?php echo e(($record->add_additional_msg == 0)? "selected": ""); ?>>No</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Status</label>
                                            <select class="form-control form-control-lg" name="status">
                                                <option value="1" <?php echo e(($record->status == 1)? "selected": ""); ?>>Active</option>
                                                <option value="0" <?php echo e(($record->status == 0)? "selected": ""); ?>>Inactive</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <button type="submit" class="btn btn-primary">Update Data Sheet</button>
                            </div>
                        </div>
                    </form>
                </div>
                <!-- end card-body -->
            </div>
            <!-- end card -->
        </div>
        <!-- end col -->
    </div>
    <!-- end row -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footerSource'); ?>

<script>
    $(document).ready(function () {
        // edit data sheet form submit
        $("#dataSheetEditForm").submit(function (e) {
            e.preventDefault();
            let data = $(this).serialize()+"&id=<?php echo e($record->id); ?>";
            axios.put('<?php echo e(route("portal.updateDataSheetRequest")); ?>', data)
                .then(function (response) {
                    if(response.data.response_code == 1){
                        successMsg(response.data.message);
                        setTimeout(function () {
                            location.reload();
                        }, 1000);
                    } else {
                        errorMsg(response.data.message);
                    }
                })
                .catch(function (error) {

                });
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\health_app\resources\views/portal/dataSheets/editDataSheet.blade.php ENDPATH**/ ?>