

<?php $__env->startSection('title', 'View Task Report'); ?>

<?php $__env->startSection('headSource'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row page-titles mx-0">
        <div class="col-sm-6 p-md-0">
            <div class="welcome-text">
                <h4>View Task Report</h4>
            </div>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Task Reports</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">View Task Report</a></li>
            </ol>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <div class="card card-body">
                <h4 class="text-primary mb-4">Detail</h4>
                <div class="row mb-2">
                    <div class="col-3">
                        <h5 class="f-w-500">Sheet Title <span class="pull-right">:</span>
                        </h5>
                    </div>
                    <div class="col-9"><span><?php echo e($data->sheet->name); ?></span>
                    </div>
                </div>
                <div class="row mb-2">
                    <div class="col-3">
                        <h5 class="f-w-500">Staff name <span class="pull-right">:</span>
                        </h5>
                    </div>
                    <div class="col-9"><span><?php echo e($data->staff->name); ?></span>
                    </div>
                </div>
                <div class="row mb-2">
                    <div class="col-3">
                        <h5 class="f-w-500">Client name <span class="pull-right">:</span>
                        </h5>
                    </div>
                    <div class="col-9"><span><?php echo e($data->client->name); ?></span>
                    </div>
                </div>
                <div class="row mb-2">
                    <div class="col-3">
                        <h5 class="f-w-500">Created at <span class="pull-right">:</span>
                        </h5>
                    </div>
                    <div class="col-9"><span><?php echo e($data->created_at->format("d F, Y g:i A")); ?></span>
                    </div>
                </div>
                <div class="row mb-2">
                    <div class="col-3">
                        <h5 class="f-w-500">Additional message <span class="pull-right">:</span>
                        </h5>
                    </div>
                    <div class="col-9"><span><?php echo e($data->additional_message); ?></span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <div class="card card-body">
                <h4 class="text-primary mb-4">Progress Note</h4>
                <div>
                    <?php echo $data->progress_note; ?>

                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Task Report</h4>
                </div>
                <div class="card-body">
                    <div class="basic-list-group">
                        <div class="list-group">
                            <?php $__currentLoopData = $data->reportData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="list-group-item list-group-item-action flex-column align-items-start">
                                    <div class="d-flex w-100 justify-content-between">
                                        <h3 class="mb-3"><?php echo e($record->question->title); ?></h3>
                                    </div>
                                    <p class="mb-1"><?php echo e($record->answer->answer); ?></p>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footerSource'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/bbcareapp/resources/views/portal/taskReports/viewTaskReport.blade.php ENDPATH**/ ?>