<?php $__env->startSection('title', 'View Data Sheet'); ?>

<?php $__env->startSection('headSource'); ?>
    <!-- Datatable -->
    <link rel="stylesheet" href="<?php echo asset('admin-assets/vendor/datatables/css/jquery.dataTables.min.css'); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row page-titles mx-0">
        <div class="col-sm-6 p-md-0">
            <div class="welcome-text">
                <h4><?php echo e($record->name); ?> Task Sheet</h4>
            </div>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Task Sheets</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">View Task Sheet</a></li>
            </ol>
        </div>
    </div>

    <!-- row -->
    <div class="row">
        <div class="col-lg-12">
            <div class="profile card card-body px-3 pt-3 pb-0">
                <div class="profile-head">
                    <div class="profile-info">
                        <div class="profile-details">
                            <div class="profile-name px-3 pt-2">
                                <h4 class="text-primary mb-0"><?php echo e($record->name); ?></h4>
                            </div>
                            <div class="dropdown ml-auto">
                                <a href="#" class="btn btn-primary light sharp" data-toggle="dropdown" aria-expanded="true"><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="18px" height="18px" viewBox="0 0 24 24" version="1.1"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><rect x="0" y="0" width="24" height="24"></rect><circle fill="#000000" cx="5" cy="12" r="2"></circle><circle fill="#000000" cx="12" cy="12" r="2"></circle><circle fill="#000000" cx="19" cy="12" r="2"></circle></g></svg></a>
                                <ul class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(-169px, 30px, 0px);">
                                    <li><a class="dropdown-item" href="<?php echo route("portal.editDataSheetPage", ["id" => $record->id]); ?>"> <i class="fa fa-pencil text-primary mr-2"></i> Edit </a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Tasks</h4>
                    <span class="pull-right"><a href="<?php echo e(route("portal.addSheetTaskPage", ["id" => $record->id])); ?>" class="btn btn-primary btn-sm"><i class="fa fa-plus-circle" aria-hidden="true"></i> Add new task</a></span>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="datatable" class="display" style="min-width: 845px">
                            <thead>
                            <tr>
                                <th>Sr</th>
                                <th>Title</th>
                                <th>Progress Note</th>
                                
                                <th>Status</th>
                                <th>Created At</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $record->tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td><?php echo e($task->title); ?></td>
                                        <td><?php echo e(substr($task->progress_note, 0, 50)); ?></td>
                                        
                                        <td> <?php echo ($task->status == 1)? '<span class="badge light badge-success">Active</span>': '<span class="badge light badge-warning">Inactive</span>'; ?> </td>
                                        <td><?php echo e($task->created_at_date); ?></td>
                                        <td width="20%">
                                            <div class="d-flex">
                                                <a href="<?php echo e(route('portal.editSheetTaskPage', ["id" => $task->id])); ?>" class="btn btn-primary shadow sharp mr-1"><i class="fa fa-pencil"></i> Edit</a>
                                                <a href="<?php echo e(route('portal.deleteSheetTask', ["id" => $task->id])); ?>" class="deletedBtn btn btn-danger shadow sharp"><i class="fa fa-trash"></i> Delete</a>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footerSource'); ?>
    <!-- Datatable -->
    <script src="<?php echo asset('admin-assets/vendor/datatables/js/jquery.dataTables.min.js'); ?>"></script>
    <script>
        $(document).ready(function (e) {
            // question listing
            $('#datatable').DataTable({
                columnDefs: [
                    { orderable: false, targets: 6, width: '110px' },
                ],
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\health_app\resources\views/portal/dataSheets/viewDataSheet.blade.php ENDPATH**/ ?>