

<?php $__env->startSection('title', 'Data Sheets Listing'); ?>

<?php $__env->startSection('headSource'); ?>
<!-- Datatable -->
<link rel="stylesheet" href="<?php echo asset('admin-assets/vendor/datatables/css/jquery.dataTables.min.css'); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row page-titles mx-0">
        <div class="col-sm-6 p-md-0">
            <div class="welcome-text">
                <h4>Task Sheets</h4>
            </div>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Dashboard</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Task Sheets</a></li>
            </ol>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Data Sheets</h4>
                    <span class="pull-right"><a href="<?php echo e(route("portal.addNewDataSheetPage")); ?>" class="btn btn-primary btn-sm"><i class="fa fa-plus-circle" aria-hidden="true"></i> Add new task sheet</a></span>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="datatable" class="display" style="min-width: 845px">
                            <thead>
                                <tr>
                                    <th>Sr</th>
                                    <th>Name</th>
                                    
                                    <th>Status</th>
                                    <th>Total Tasks</th>
                                    <th>Created At</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $records; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td><?php echo e($record->name); ?></td>
                                        
                                        <td> <?php echo ($record->status == 1)? '<span class="badge light badge-success">Active</span>': '<span class="badge light badge-warning">Inactive</span>'; ?> </td>
                                        <td><?php echo e($record->tasks_count); ?></td>
                                        <td><?php echo e($record->created_at_date); ?></td>
                                        <td>
                                            <div class="d-flex">
                                                <a href="<?php echo e(route('portal.viewDataSheetPage', ["id" => $record->id])); ?>" class="btn btn-success shadow sharp mr-1"><i class="fa fa-cog"></i> Operations</a>
                                                <a href="<?php echo e(route('portal.editDataSheetPage', ["id" => $record->id])); ?>" class="btn btn-primary shadow sharp mr-1"><i class="fa fa-pencil"></i> Edit</a>
                                                <a href="<?php echo e(route('portal.deleteDataSheet', ["id" => $record->id])); ?>" class="deletedBtn btn btn-danger shadow sharp"><i class="fa fa-trash"></i> Delete</a>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footerSource'); ?>
    <!-- Datatable -->
    <script src="<?php echo asset('admin-assets/vendor/datatables/js/jquery.dataTables.min.js'); ?>"></script>
    <script>
        $(document).ready(function () {
            // list table
            $('#datatable').DataTable({
                columnDefs: [
                    { orderable: false, targets: 6, width: '220px' },
                ],
            });
        });

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/sites/health_app/resources/views/portal/dataSheets/index.blade.php ENDPATH**/ ?>