<!-- Required vendors -->
<script src="<?php echo asset('admin-assets/vendor/global/global.min.js'); ?>"></script>
<script src="<?php echo asset('admin-assets/js/custom.min.js'); ?>"></script>
<script src="<?php echo asset('admin-assets/js/deznav-init.js'); ?>"></script>
<script src="<?php echo asset('admin-assets/vendor/sweetalert2/dist/sweetalert.min.js'); ?>"></script>
<script src="<?php echo asset('admin-assets/vendor/toastr/js/toastr.min.js'); ?>"></script>
<script src="<?php echo asset('js/axios.min.js'); ?>"></script>
<script src="<?php echo asset('js/jquery.blockUI.js'); ?>"></script>

<script>

$(document).ready(function () {
    $("body").on("click", ".deletedBtn", function (e) {
        e.preventDefault();
        let url = $(this).attr("href");
        swal({
            title: "Are you sure?",
            text: "Once deleted, you will not be able to recover this!",
            icon: "warning",
            buttons: true,
            dangerMode: true,
        })
            .then((willDelete) => {
                if (willDelete) {
                    axios.delete(url)
                        .then(function (response) {
                            if(response.data.response_code == 1){
                                successMsg(response.data.message);
                                setTimeout(function () {
                                    location.reload();
                                }, 1000);
                            } else {
                                errorMsg(response.data.message);
                            }
                        })
                        .catch(function (error) {

                        });
                }
            });
    });

    // image preview
    $('.previewInput').change( function(event) {
        var targetView = $(this).data("target");
        var files = event.target.files[0];
        var fileName = files.name;
        var fsize = files.size;
        var tmppath = URL.createObjectURL(files);
        var ext = fileName.split('.').pop().toLowerCase();
        switch(ext){
            case 'jpg': case 'jpeg': case 'png':
                break;
            default:
                errorMsg('invalid file');
                $(this).val("");
                return false
        }
        if(fsize>1048576){
            errorMsg('invalid size');
            $(this).val("");
            return false
        }
        $(targetView).attr('src',tmppath);
    });
});

// Add a request interceptor
axios.interceptors.request.use(function (config) {
    // Do something before request is sent
    showLoader();
    return config;
}, function (error) {
    // Do something with request error
    hideLoader();
    errorMsg("Something error");
    return Promise.reject(error);
});

// Add a response interceptor
axios.interceptors.response.use(function (response) {
    // Do something with response data
    hideLoader();
    return response;
}, function (error) {
    // Do something with response error
    hideLoader();
    if(error.response.status == 422){
        $.each(error.response.data.errors, function (index, value) {
            errorMsg(value);
        });
    } else if(error.response.status == 401 || error.response.status == 403){
        errorMsg(error.response.data.message);
    } else {
        errorMsg("Something went wrong");
    }
    return Promise.reject(error);
});

// show success msg
function successMsg(msg){
	toastr.success(msg);
}

// show error msg
function errorMsg(msg){
	window.toastr.error(msg);
}

// show loader
function showLoader(){
	$.blockUI({
        css: {
            border: 'none',
            padding: '15px',
            backgroundColor: '#000',
            '-webkit-border-radius': '10px',
            '-moz-border-radius': '10px',
            color: '#fff',
        },
        baseZ: 2000,
	});
}

// hide loader
function hideLoader(){
	$.unblockUI();
}

// create cookies
function createCookie(name,value,days) {
    if (days) {
        var date = new Date();
        date.setTime(date.getTime()+(days*24*60*60*1000));
        var expires = "; expires="+date.toGMTString();
    }
    else var expires = "";
    document.cookie = name+"="+value+expires+"; path=/";
}

// read cookies
function readCookie(name) {
    var nameEQ = name + "=";
    var ca = document.cookie.split(';');
    for(var i=0;i < ca.length;i++) {
        var c = ca[i];
        while (c.charAt(0)==' ') c = c.substring(1,c.length);
        if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
    }
    return null;
}

// delete cookies
function eraseCookie(name) {
    createCookie(name,"",-1);
}
</script>
<?php /**PATH /var/www/html/sites/health_app/resources/views/layouts/defaultJs.blade.php ENDPATH**/ ?>