<?php

namespace App\Http\Controllers\PortalController;

use App\Services\CategoryService;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class CategoryController extends Controller
{
    // category listing page
    public function listing(CategoryService $categoryService)
    {
        $authMessage = "Not Authorized! Please contact with the SuperAdmin";
        if (checkPermission('viewCategory', Auth::user()->role) || Auth::user()->role == 'SuperAdmin') {
            return $categoryService->listPage();
        }
        return view("auth.login", compact('authMessage'));
    }

    // add new category page
    public function addPage()
    {
        $authMessage = "Not Authorized! Please contact with the SuperAdmin";
        if (checkPermission('addCategory', Auth::user()->role) || Auth::user()->role == 'SuperAdmin') {
            return view("portal.categories.addCategory");
        }
        return view("auth.login", compact('authMessage'));
    }

    // add new category request
    public function addRequest(Request $request, CategoryService $categoryService)
    {

        return $categoryService->addRequest($request);

    }

    // edit category
    public function editPage($id, CategoryService $dataSheetService)
    {
        if (checkPermission('editCategory', Auth::user()->role) || Auth::user()->role == 'SuperAdmin') {
            return $dataSheetService->editCategory($id);
        }
    }

    // update data sheet
    public function updateRequest(Request $request, CategoryService $categoryService)
    {
        return $categoryService->updateRequest($request);
    }

    // delete category
    public function deleteRequest($id, CategoryService $categoryService)
    {
        return $categoryService->deleteCategory($id);
    }
}
