<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class CheckHaveAccessPortal
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if (Auth::check() && Auth::user()->status == 1) {
            // check trial expiry
            if (Auth::user()->role != 'SuperAdmin' && Auth::user()->is_on_trial && time() > strtotime(Auth::user()->trial_ends_at)) {
                Auth::logout();
                return redirect()->route("portal.loginPage")->with('message', 'Please contact your plan administrator to continue using BB Care Notes.');
            }
            return $next($request);
        }
        Auth::logout();
        return redirect()->route("portal.loginPage");
    }
}
