<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;
use App\OauthAccessToken;

class CheckTrialExpiry
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if (Auth::user()->is_on_trial && time() > strtotime(Auth::user()->trial_ends_at)) {
            OauthAccessToken::where('user_id', Auth::user()->id)->delete();
            return response()->json(['message' => 'Unauthenticated.', 'error' => 'Please contact your plan administrator to continue using BB Care Notes.'], 401);
        }
        return $next($request);
    }
}
