<?php

namespace App\Services;

use App\Category;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;


class CategoryService
{
    // category listing page
    public function listPage()
    {
        $records = Category::select('*');
        $records = $records->orderBy('id', 'ASC')->get();

        return view("portal.categories.index", compact("records"));
    }

    // add new category request
    public function addRequest($request)
    {
        $customMsgs = [
            'title.required' => 'Please enter category title.',
        ];
        $validator = Validator::make($request->all(), [
            'title' => 'required',
        ], $customMsgs);

        if ($validator->fails()) {
            $errorArray = HelperServices::validationErrorFormat($validator->errors());
            return HelperServices::returnJsonResponse(2, 'Validation Errors', [], $errorArray, 422);
        }

        $record = new Category();
        $record->created_by = Auth::user()->id;
        $record->title = $request->title;
        $record->status = $request->status;
        if ($record->save()) {
            $redirectUrl = route("portal.categoryListPage");
            return HelperServices::returnJsonResponse(1, 'Category created successfully.', ["redirect_url" => $redirectUrl]);
        } else {
            return HelperServices::returnJsonResponse(0, 'Category not created.');
        }
    }

    // get data sheet page
    public function editCategory($id)
    {
        $record = Category::find($id);
        if (!$record) {
            abort(404);
        }
        return view('portal.categories.editCategory', compact('record'));
    }

    // update data sheet
    public function updateRequest($request)
    {
        $customMsgs = [
            'id.required' => 'Error: Something went wrong.',
            'title.required' => 'Please enter category title.',
        ];
        $validator = Validator::make($request->all(), [
            'id' => 'required',
            'title' => 'required',
        ], $customMsgs);

        if ($validator->fails()) {
            $errorArray = HelperServices::validationErrorFormat($validator->errors());
            return HelperServices::returnJsonResponse(2, 'Validation Errors', [], $errorArray, 422);
        }

        $record = Category::find($request->id);
        if (!$record) {
            return HelperServices::returnJsonResponse(0, "Record not found");
        }
        $record->title = $request->title;
        $record->status = $request->status;
        $record->updated_by = Auth::user()->id;
        if ($record->save()) {
            return HelperServices::returnJsonResponse(1, "Record updated successfully");
        } else {
            return HelperServices::returnJsonResponse(0, "Nothing updated");
        }
    }

    // delete data sheet
    public function deleteCategory($id)
    {
        $record = Category::find($id);
        if (!$record) {
            return HelperServices::returnJsonResponse(0, 'Record not found.');
        }
        if ($record->delete()) {
            return HelperServices::returnJsonResponse(1, 'Record deleted successfully.');
        } else {
            return HelperServices::returnJsonResponse(0, 'Record not deleted.');
        }
    }
}
