<?php

namespace App;

use App\Scopes\LatestScope;
use Illuminate\Database\Eloquent\Model;
use App\Traits\FormatDates;
use App\SheetAnswer;

class SheetQuestion extends Model
{
    use FormatDates;

    /**
     *
     * Boot the model.
     *
     */
    public static function boot()
    {
        parent::boot();

        // create default answers on creating
        static::created(function ($record) {
            $answersArr = [1, 2, 3, 4, 5];
            if (isset($record->sheet_type_id)) {
                $sheetAnswers = SheetAnswer::selectRaw('GROUP_CONCAT(id) as ids')->where('sheet_type_id', $record->sheet_type_id)->first();
                if ($sheetAnswers && isset($sheetAnswers->ids))
                    $answersArr = explode(',', $sheetAnswers->ids);
            }
            $record->answers()->attach($answersArr);
        });

        // deleted answer relationship
        static::deleted(function ($record) {
            $record->answers()->detach();
        });

        // add global scope
        static::addGlobalScope(new LatestScope());
    }

    // answers
    public function answers(){
        return $this->belongsToMany('App\SheetAnswer', "question_answers", "sheet_question_id", "sheet_answer_id")->withPivot("id", "delete_answer")->withTimestamps();
    }
}
