<?php

use App\Notifications;
use App\Permission;
use Illuminate\Support\Facades\Auth;

    function checkPermission($access, $type)
    {
        if (null === Auth::check()) {
            return false;
        }

        $user_role = Auth::user()->role;
        if (!empty($type)) {
            $access = $access . '_' . $type;
        } else {
            $access = $access . '_' . strtolower($user_role);
        }
        //echo $access;


        $permission = Permission::where("role", $user_role)->where("role_key", $access)->count();
        if ($permission > 0) {
            return true;
        }
        return false;
    }

    function isPermission($permission, $role)
    {

        $is_permission = Permission::where('role', $role)->where('role_key', $permission)->count();

        if ($is_permission > 0) {
            return true;
        }
        return false;
    }





