<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class Welcome extends Mailable
{
    use Queueable, SerializesModels;

    public $data;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($data)
    {
        $this->data = $data;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->from(config('mail.to.address'), config('mail.to.name'))
            ->replyTo(config('mail.to.address'), config('mail.to.name'))
            ->to($this->data['email'], $this->data['name'])
            ->subject($this->data['subject'])
            ->view('emails.send_welcome_email')
            ->with($this->data);
    }
}
