<?php

namespace App;

use App\Scopes\LatestScope;
use Illuminate\Database\Eloquent\Model;
use App\Traits\FormatDates;

class SheetQuestion extends Model
{
    use FormatDates;

    /**
     *
     * Boot the model.
     *
     */
    public static function boot()
    {
        parent::boot();

        // create default answers on creating
        static::created(function ($record) {
            $record->answers()->attach([1,2,3,4,5]);
        });

        // deleted answer relationship
        static::deleted(function ($record) {
            $record->answers()->detach();
        });

        // add global scope
        static::addGlobalScope(new LatestScope());
    }

    // answers
    public function answers(){
        return $this->belongsToMany('App\SheetAnswer', "question_answers", "sheet_question_id", "sheet_answer_id")->withPivot("id", "delete_answer")->withTimestamps();
    }
}
