<?php

namespace App;

use App\Scopes\LatestScope;
use App\Traits\FormatDates;
use Illuminate\Database\Eloquent\Model;

class TaskReport extends Model
{
    use FormatDates;

    /**
     *
     * Boot the model.
     *
     */
    public static function boot()
    {
        parent::boot();

        // add global scope
        static::addGlobalScope(new LatestScope());
    }

    // relation with report data
    public function reportData(){
        return $this->hasMany('App\ReportData', 'report_id');
    }

    // relation with sheet
    public function sheet(){
        return $this->belongsTo('App\DataSheet', 'data_sheet_id');
    }

    // relation with client
    public function client(){
        return $this->belongsTo('App\User', 'client_id');
    }

    // relation with staff
    public function staff(){
        return $this->belongsTo('App\User', 'staff_id');
    }
}
