<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSheetQuestionTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sheet_questions', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('title');
            $table->string('progress_note');
            $table->bigInteger('data_sheet_id')->unsigned();
            $table->foreign('data_sheet_id')
                ->references('id')->on('data_sheets')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sheet_questions');
    }
}
