@extends('layouts.app')

@section('title', 'Categories Listing')

@section('headSource')
<!-- Datatable -->
<link rel="stylesheet" href="{!! asset('admin-assets/vendor/datatables/css/jquery.dataTables.min.css') !!}">
@endsection

@section('content')

    <div class="row page-titles mx-0">
        <div class="col-sm-6 p-md-0">
            <div class="welcome-text">
                <h4>Task Sheets</h4>
            </div>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{route('portal.dashboard')}}">Dashboard</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Categories</a></li>
            </ol>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Categories</h4>
                    @if (checkPermission('addCategory', Auth::user()->role) || Auth::user()->role=='SuperAdmin')
                    <span class="pull-right"><a href="{{route("portal.addCategoryPage")}}" class="btn btn-primary btn-sm"><i class="fa fa-plus-circle" aria-hidden="true"></i> Add new category</a></span>
                    @endif
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="datatable" class="display" style="min-width: 845px">
                            <thead>
                                <tr>
                                    <th>Sr</th>
                                    <th>Title</th>
                                    <th>Status</th>
                                    <th>Created At</th>
                                    @if((checkPermission('editCategory', Auth::user()->role) || checkPermission('deleteCategory', Auth::user()->role)) || Auth::user()->role == 'SuperAdmin')
                                    <th>Action</th>
                                    @endif
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($records as $record)
                                    <tr>
                                        <td>{{$loop->iteration}}</td>
                                        <td>{{$record->title}}</td>
                                        <td> {!! ($record->status == 1) ? '<span class="badge light badge-success">Active</span>': '<span class="badge light badge-warning">In-Active</span>' !!} </td>
                                        <td>{{ Carbon\Carbon::parse($record->created_at)->format('d M, Y h:i A')}}</td>
                                        <td>
                                            <div class="d-flex">
                                                @if (checkPermission('editCategory',Auth::user()->role) || Auth::user()->role=='SuperAdmin')
                                                <a href="{{route('portal.editCategoryPage', ["id" => $record->id])}}" class="btn btn-primary shadow sharp mr-1"><i class="fa fa-pencil"></i> Edit</a>
                                                @endif
                                                @if (checkPermission('deleteCategory',Auth::user()->role) || Auth::user()->role=='SuperAdmin')
                                                <a href="{{route('portal.deleteCategoryRequest', ["id" => $record->id])}}" class="deletedBtn btn btn-danger shadow sharp"><i class="fa fa-trash"></i> Delete</a>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('footerSource')
    <!-- Datatable -->
    <script src="{!! asset('admin-assets/vendor/datatables/js/jquery.dataTables.min.js') !!}"></script>
    <script>
        $(document).ready(function () {
            // list table
            $('#datatable').DataTable({
                columnDefs: [
                    { orderable: false, targets: 6, width: '220px' },
                ],
            });
        });

    </script>
@endsection
