@extends('layouts.app')

@section('title', 'Edit Sheet Task')

@section('headSource')

@endsection

@section('content')
    <style>
        .prompt-tags span, .pro-notes span, .pro-notes-ind span {
            margin-top: 2px;
            cursor: pointer;
        }

        .pro-notes span.selected, .pro-notes-ind span.selected {
            color: #3d4465 !important;
        }

        .multi-answers span i {
            position: relative;
            top: -5px;
            left: -3px;
            opacity: 0;
            pointer-events: none;
        }
        .multi-answers span.selected:hover i.fa {
            opacity: 1 !important;
            pointer-events: auto;
        }
    </style>
    @php if (count($record->answers) == 2) {
         $noteLabel1 = 'Progress Note for ' . strtoupper($record->answers[0]->answer) . ' case';
         $noteLabel2 = 'Progress Note for ' . strtoupper($record->answers[1]->answer) . ' case';
         $showAlternativePrompt = true;
    } else {
         $noteLabel1 = 'Progress Note';
         $noteLabel2 = 'Progress Note For Independent Prompt';
         $showAlternativePrompt = false;
    }
    @endphp
    <div class="row page-titles mx-0">
        <div class="col-sm-6 p-md-0">
            <div class="welcome-text">
                <h4>Edit Task</h4>
            </div>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{route('portal.dashboard')}}">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="{{route('portal.dataSheetListPage')}}">Data Sheets</a></li>
                <li class="breadcrumb-item"><a href="{{route('portal.viewDataSheetPage', ["id" => $record->data_sheet_id])}}">View Tasks</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Edit Task</a></li>
            </ol>
        </div>
    </div>

    <div class="row">
        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 col-xl-12">
            <div class="card mb-3">
                <div class="card-header">
                    <h3><i class="fa fa-list-alt"></i> Task detail</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-9">
                            <form id="sheetTaskEditForm" method="post">
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label>Title (required)</label>
                                            <textarea id="sheetTitle" class="form-control" name="title" required>{{$record->title}}</textarea>
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label>{{$noteLabel1}} (required)</label>
                                            <div class="mb-2 pro-notes" style="display: flex; justify-content: flex-start">
                                                <div style="width: 75%">
                                                    <span class="multi-answers">
                                                        @if($record->is_new)
                                                            @foreach(json_decode($record->progress_note) as $key => $note)
                                                                <span class="badge badge-sm {{ $key == 0 ? 'selected' : '' }}"
                                                                      onclick="answerChangeHandle(this)">Answer {{$key + 1}} <i
                                                                        class="fa fa-minus-circle text-danger"
                                                                        onclick="removeAnswer(this)"></i></span>
                                                            @endforeach
                                                        @else
                                                        <span class="badge badge-sm selected"
                                                              onclick="answerChangeHandle(this)">Answer 1 <i
                                                                class="fa fa-minus-circle text-danger"
                                                                onclick="removeAnswer(this)"></i></span>
                                                        @endif
                                                    </span>
                                                    <span id="addAnswer" class="badge badge-primary badge-sm"
                                                          data-toggle="tooltip" title="Add more"
                                                          style="cursor: pointer;">Add more</span>
                                                </div>
                                                <div style="width: 25%; display: flex; justify-content: end">
                                                    <span id="progressAssessment" class="badge badge-sm">Assessment</span>
                                                    <span id="progressPlan" class="badge badge-sm">Plan</span>
                                                </div>
                                            </div>
                                            <textarea id="progressNote" class="form-control" name="progress_note"></textarea>
                                            <textarea id="progressAssessmentText" class="form-control" name="progress_assessment" style="display: none">{{$record->assessment}}</textarea>
                                            <textarea id="progressPlanText" class="form-control" name="progress_plan" style="display: none">{{$record->plan}}</textarea>
                                        </div>
                                        <div class="mb-3 prompt-tags">
                                            <span class="badge badge-secondary insertTag" data-toggle="tooltip" title="Jhon Doe" style="cursor: pointer;" data-tag="##ClientFullName##">##ClientFullName##</span>
                                            <span class="badge badge-secondary insertTag" data-toggle="tooltip" title="Jhon" style="cursor: pointer;" data-tag="##ClientFirstName##">##ClientFirstName##</span>
                                            <span class="badge badge-secondary insertTag" data-toggle="tooltip" title="He/She" style="cursor: pointer;" data-tag="##ClientGenderNoun##">##ClientGenderNoun##</span>
                                            <span class="badge badge-secondary insertTag" data-toggle="tooltip" title="His/Her" style="cursor: pointer;" data-tag="##HIS-HER-GenderNoun##">##HIS-HER-GenderNoun##</span>
                                            <span class="badge badge-secondary insertTag" data-toggle="tooltip" title="Him/Her" style="cursor: pointer;" data-tag="##HIM-HER-Objective##">##HIM-HER-Objective##</span>
                                            <span class="badge badge-secondary insertTag" data-toggle="tooltip" title="Selected Answer" style="cursor: pointer;" data-tag="##AnswerPrompt##">##AnswerPrompt##</span>
                                        </div>
                                    </div>
                                    <div class="col-lg-12 mt-3">
                                        <div class="form-group">
                                            <label>{{$noteLabel2}} (required)</label>
                                            <div class="mb-2 pro-notes-ind" style="display: flex; justify-content: flex-start">
                                                <div style="width: 75%">
                                                <span class="multi-answers">
                                                    @if($record->is_new)
                                                        @foreach(json_decode($record->progress_note_independent) as $index => $item)
                                                            <span
                                                                class="badge badge-sm {{ $index == 0 ? 'selected' : '' }}"
                                                                onclick="answerIndChangeHandle(this)">Answer {{$index + 1}} <i
                                                                    class="fa fa-minus-circle text-danger"
                                                                    onclick="removeAnswerInd(this)"></i></span>
                                                        @endforeach
                                                    @else
                                                        <span class="badge badge-sm selected"
                                                              onclick="answerIndChangeHandle(this)">Answer 1 <i
                                                                class="fa fa-minus-circle text-danger"
                                                                onclick="removeAnswerInd(this)"></i></span>
                                                    @endif
                                                </span>
                                                    <span id="addAnswerInd" class="badge badge-primary badge-sm" data-toggle="tooltip" title="Add more"
                                                          style="cursor: pointer;">Add more</span>
                                                </div>
                                                <div style="width: 25%; display: flex; justify-content: end">
                                                    <span id="progressAssessmentInd" class="badge badge-sm">Assessment</span>
                                                    <span id="progressPlanInd" class="badge badge-sm">Plan</span>
                                                </div>
                                            </div>
                                            <textarea id="progressNoteIndependent" class="form-control" name="progress_note_independent"></textarea>
                                            <textarea id="progressAssessmentIndText" class="form-control" name="independent_assessment" style="display: none">{{$record->independent_assessment}}</textarea>
                                            <textarea id="progressPlanIndText" class="form-control" name="independent_plan" style="display: none">{{$record->independent_plan}}</textarea>
                                        </div>
                                        <div class="mb-3 prompt-tags">
                                            <span class="badge badge-secondary insertTagInd" data-toggle="tooltip" title="Jhon Doe" style="cursor: pointer;" data-tag="##ClientFullName##">##ClientFullName##</span>
                                            <span class="badge badge-secondary insertTagInd" data-toggle="tooltip" title="Jhon" style="cursor: pointer;" data-tag="##ClientFirstName##">##ClientFirstName##</span>
                                            <span class="badge badge-secondary insertTagInd" data-toggle="tooltip" title="He/She" style="cursor: pointer;" data-tag="##ClientGenderNoun##">##ClientGenderNoun##</span>
                                            <span class="badge badge-secondary insertTagInd" data-toggle="tooltip" title="His/Her" style="cursor: pointer;" data-tag="##HIS-HER-GenderNoun##">##HIS-HER-GenderNoun##</span>
                                            <span class="badge badge-secondary insertTagInd" data-toggle="tooltip" title="Him/Her" style="cursor: pointer;" data-tag="##HIM-HER-Objective##">##HIM-HER-Objective##</span>
                                            @if ($showAlternativePrompt)
                                                <span id="answerPrompt" class="badge badge-secondary insertTagInd" data-toggle="tooltip" title="Selected Answer" style="cursor: pointer;" data-tag="##AnswerPrompt##">##AnswerPrompt##</span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Status</label>
                                            <select id="status" class="form-control form-control-lg" name="status">
                                                <option value="1" {{($record->status == 1)? "selected": ""}}>Active</option>
                                                <option value="0" {{($record->status == 0)? "selected": ""}}>Inactive</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-12">
                                        <a href="{{route('portal.viewDataSheetPage', ["id" => $record->data_sheet_id])}}" class="btn btn-secondary">Back To Task Sheet</a>
                                        <button type="submit" class="btn btn-primary">Update Task</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="col-lg-3">
                            {{--<form id="taskAnswerForm" method="post">
                                <label>Add more answer</label>
                                <div class="input-group">
                                    <input name="answer" type="text" class="form-control" required>
                                    <div class="input-group-append">
                                        <button class="btn btn-primary" type="submit">Add</button>
                                    </div>
                                </div>
                            </form>--}}
                            <label class="mt-4">Prompts</label>
                            <div class="basic-list-group">
                                <ul class="list-group">
                                    @foreach($record->answers as $answer)
                                        <li class="list-group-item d-flex justify-content-between align-items-center">
                                            {{$answer->answer}} {{--<a href="{{route('portal.deleteAnswerInTask', ["id" => $answer->pivot->id])}}" class="deletedBtn badge badge-primary badge-pill"><i class="fa fa-times"></i></a>--}}
                                        </li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- end card-body -->
            </div>
            <!-- end card -->
        </div>
        <!-- end col -->
    </div>
    <!-- end row -->

@endsection

@section('footerSource')

<script>

    let progressAnswers = [], progressAnswersInd = [], isNew = {{$record->is_new}};
    if (isNew) {
        progressAnswers = JSON.parse(<?= json_encode($record->progress_note); ?>);
        progressAnswersInd = JSON.parse(<?= json_encode($record->progress_note_independent); ?>);
    } else {
        progressAnswers.push('<?php echo addslashes($record->progress_note); ?>');
        progressAnswersInd.push('<?php echo addslashes($record->progress_note_independent); ?>');
    }
    $('#progressNote').val(progressAnswers[0]);
    $('#progressNoteIndependent').val(progressAnswersInd[0]);

    function answerChangeHandle(elem, addNew = false) {
        if ($(elem).hasClass('selected') && !addNew) return;

        $('#progressPlanText').hide();
        $('#progressAssessmentText').hide();
        $('#progressNote').show();

        let selectedIndex = 0;
        if ($('.pro-notes .multi-answers span.selected')) {
            selectedIndex = $('.pro-notes .multi-answers span.selected').index();
        }

        progressAnswers[selectedIndex] = $("#progressNote").val();
        $("#progressNote").val('');
        $('.pro-notes span.selected').removeClass('selected');
        if (addNew) {
            let tagsLen = $('.pro-notes .multi-answers span').length;
            $('.pro-notes .multi-answers').append(`<span class="badge badge-sm selected" onclick="answerChangeHandle(this)">Answer ${tagsLen + 1} <i class="fa fa-minus-circle text-danger" onclick="removeAnswer(this)"></i></span>`);
            progressAnswers.push('');
        } else {
            $(elem).addClass('selected');
            $('#progressNote').val(progressAnswers[$(elem).index()]);
        }
    }

    function removeAnswer(elem) {
        if ($('.pro-notes .multi-answers span').length === 1) return;

        let parentSpan = $(elem).closest('span.badge'),
            parentIndex = parentSpan.index();
        progressAnswers.splice(parentIndex, 1);
        parentSpan.remove();
        // reindex answer
        $('.pro-notes .multi-answers span').each(function(index) {
            $(this).text(`Answer ${index + 1} `).append('<i class="fa fa-minus-circle text-danger" onclick="removeAnswer(this)"></i>');
        });
        // select first answer
        $('.pro-notes .multi-answers span:first').trigger('click');
    }

    function pushAnswerOnChange() {
        if ($('.pro-notes .multi-answers span.selected')) {
            let selectedIndex = $('.pro-notes .multi-answers span.selected').index();
            progressAnswers[selectedIndex] = $("#progressNote").val();
            $('#progressNote').val('');
        }
    }


    function answerIndChangeHandle(elem, addNew = false) {
        if ($(elem).hasClass('selected') && !addNew) return;

        $('#progressPlanIndText').hide();
        $('#progressAssessmentIndText').hide();
        $('#progressNoteIndependent').show();

        let selectedIndex = 0;
        if ($('.pro-notes-ind .multi-answers span.selected')) {
            selectedIndex = $('.pro-notes-ind .multi-answers span.selected').index();
        }

        progressAnswersInd[selectedIndex] = $("#progressNoteIndependent").val();
        $('#progressNoteIndependent').val('');
        $('.pro-notes-ind span.selected').removeClass('selected');
        if (addNew) {
            let tagsLen = $('.pro-notes-ind .multi-answers span').length;
            $('.pro-notes-ind .multi-answers').append(`<span class="badge badge-sm selected" onclick="answerIndChangeHandle(this)">Answer ${tagsLen + 1} <i class="fa fa-minus-circle text-danger" onclick="removeAnswerInd(this)"></i></span>`);
            progressAnswersInd.push('');
        } else {
            $(elem).addClass('selected');
            $('#progressNoteIndependent').val(progressAnswersInd[$(elem).index()]);
        }
    }

    function removeAnswerInd(elem) {
        if ($('.pro-notes-ind .multi-answers span').length === 1) return;

        let parentSpan = $(elem).closest('span.badge'),
            parentIndex = parentSpan.index();
        progressAnswersInd.splice(parentIndex, 1);
        parentSpan.remove();
        // reindex answer
        $('.pro-notes-ind .multi-answers span').each(function(index) {
            $(this).text(`Answer ${index + 1} `).append('<i class="fa fa-minus-circle text-danger" onclick="removeAnswerInd(this)"></i>');
        });
        // select first answer
        $('.pro-notes-ind .multi-answers span:first').trigger('click');
    }

    function pushIndAnswerOnChange() {
        if ($('.pro-notes-ind .multi-answers span.selected')) {
            let selectedIndex = $('.pro-notes-ind .multi-answers span.selected').index();
            progressAnswersInd[selectedIndex] = $("#progressNoteIndependent").val();
            $("#progressNoteIndependent").val('');
        }
    }

    $(document).ready(function () {
        // insert tag in progress note
        $(".insertTag").click(function (e) {
            let tag = $(this).data("tag");
            let textArea = $('#progressAssessment').hasClass('selected')
                ? '#progressAssessmentText' : ($('#progressPlan').hasClass('selected')
                    ? '#progressPlanText' : '#progressNote');
            let noteTxt = $(textArea).val();
            let upDateNoteTxt = noteTxt+' '+tag+' ';
            $(textArea).val(upDateNoteTxt);
        });
        $(".insertTagInd").click(function (e) {
            let tag = $(this).data("tag");
            let textArea = $('#progressAssessmentInd').hasClass('selected')
                ? '#progressAssessmentIndText' : ($('#progressPlanInd').hasClass('selected')
                    ? '#progressPlanIndText' : '#progressNoteIndependent');
            let noteTxt = $(textArea).val();
            let upDateNoteTxt = noteTxt+' '+tag+' ';
            $(textArea).val(upDateNoteTxt);
        });
        // tooltip
        $('[data-toggle="tooltip"]').tooltip();

        $('#addAnswer').click(function (e) {
            answerChangeHandle($(this), true);
        });

        // save value on focus change
        $('#progressNote').blur(function() {
            if ($('.pro-notes .multi-answers span.selected')) {
                let selectedIndex = $('.pro-notes .multi-answers span.selected').index();
                progressAnswers[selectedIndex] = $(this).val();
            }
        });

        // save value on focus change
        $('#progressNoteIndependent').blur(function() {
            if ($('.pro-notes-ind .multi-answers span.selected')) {
                let selectedIndex = $('.pro-notes-ind .multi-answers span.selected').index();
                progressAnswersInd[selectedIndex] = $(this).val();
            }
        });

        $('#progressAssessment').click(function (e) {
            pushAnswerOnChange();
            $('.pro-notes span.selected').removeClass('selected');
            $(this).addClass('selected');
            $('#progressNote').hide();
            $('#progressPlanText').hide();
            $('#progressAssessmentText').show();
        });

        $('#progressPlan').click(function (e) {
            pushAnswerOnChange();
            $('.pro-notes span.selected').removeClass('selected');
            $(this).addClass('selected');
            $('#progressNote').hide();
            $('#progressAssessmentText').hide();
            $('#progressPlanText').show();
        });

        $('#addAnswerInd').click(function (e) {
            answerIndChangeHandle($(this), true);
        });

        $('#progressAssessmentInd').click(function (e) {
            pushIndAnswerOnChange();
            $('.pro-notes-ind span.selected').removeClass('selected');
            $(this).addClass('selected');
            $('#progressNoteIndependent').hide();
            $('#progressPlanIndText').hide();
            $('#progressAssessmentIndText').show();
        });

        $('#progressPlanInd').click(function (e) {
            pushIndAnswerOnChange();
            $('.pro-notes-ind span.selected').removeClass('selected');
            $(this).addClass('selected');
            $('#progressNoteIndependent').hide();
            $('#progressAssessmentIndText').hide();
            $('#progressPlanIndText').show();
        });

        // edit sheet task form submit
        $("#sheetTaskEditForm").submit(function (e) {
            e.preventDefault();

            let filteredProgressAnswers = progressAnswers.filter(function(elem) {
                return elem.trim() !== '';
            });

            let filteredProgressAnswersInd = progressAnswersInd.filter(function(elem) {
                return elem.trim() !== '';
            });
            if (!filteredProgressAnswers.length || !filteredProgressAnswersInd.length) {
                errorMsg('Please enter at-least one progress note.');
            } else {
                {{--let data = $(this).serialize() + "&id={{$record->id}}";--}}
                let postData = {
                    id: {{$record->id}},
                    title: $('#sheetTitle').val(),
                    progress_assessment: $('#progressAssessmentText').val(),
                    progress_plan: $('#progressPlanText').val(),
                    independent_assessment: $('#progressAssessmentIndText').val(),
                    independent_plan: $('#progressPlanIndText').val(),
                    progress_notes: filteredProgressAnswers,
                    progress_notes_independent: filteredProgressAnswersInd,
                    status: $('#status').val()
                };
                axios.put('{{route("portal.updateSheetTaskRequest")}}', postData)
                    .then(function (response) {
                        if (response.data.response_code == 1) {
                            successMsg(response.data.message);
                            setTimeout(function () {
                                location.reload();
                            }, 1000);
                        } else {
                            errorMsg(response.data.message);
                        }
                    })
                    .catch(function (error) {

                    });
            }
        });

        // add answer form submit
        $("#taskAnswerForm").submit(function (e) {
            e.preventDefault();
            let data = $(this).serialize()+"&id={{$record->id}}";
            axios.post('{{route("portal.addAnswerInTaskRequest")}}', data)
                .then(function (response) {
                    if(response.data.response_code == 1){
                        successMsg(response.data.message);
                        setTimeout(function () {
                            location.reload();
                        }, 1000);
                    } else {
                        errorMsg(response.data.message);
                    }
                })
                .catch(function (error) {

                });
        });
    });
</script>
@endsection
