@extends('layouts.app')
@section('title', 'Move Clients')
@section('content')
    <div class="row page-titles mx-0">
        <div class="col-sm-6 p-md-0">
            <div class="welcome-text">
                <h4>Move Clients</h4>
            </div>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{route('portal.dashboard')}}">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Users</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Move Clients</a></li>
            </ol>
        </div>
    </div>
    <div class="row">
        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 col-xl-12">
            <div class="card mb-3">
                <div class="card-header">
                    <h4><i class="fa fa-retweet"></i> Move clients from one Executive to another</h4>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="single-select">Select Executive</label>
                                        <select id="single-select" class="form-control form-control-lg" name="executive"
                                                required>
                                            <option value="" disabled selected>Choose Executive</option>
                                            @foreach($executives as $executive)
                                                @php $optText = Auth::user()->role == 'SuperAdmin' ?  $executive->name . ' ('. $executive->coordinatorName . ')' : $executive->name; @endphp
                                                <option value="{{$executive->id}}">{{$optText}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="clientsSel">Select Client(s)</label>
                                        <select id="clientsSel" class="form-control form-control-lg multi-select"
                                                name="clients[]"
                                                multiple="multiple" disabled required>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <button id="submitBtn" type="button" class="btn btn-primary">Submit</button>
                        </div>
                    </div>
                </div>
                <!-- end card-body -->
            </div>
            <!-- end card -->
        </div>
        <!-- end col -->
    </div>
    <!-- end row -->
@endsection
@section('footerSource')
    <script>
        $(document).ready(function () {
            $('#single-select').val('').trigger('change');
        });
        $('#single-select').change(function (e) {
            axios.post('{{route("portal.getExecutiveClientsRequest")}}', {id: $(this).val()})
                .then(function (response) {
                    let clients = response.data.data, clientsArr = [], clientsSelect = $('select.multi-select');
                    clientsSelect.empty().attr('disabled', false);
                    for (let i = 0; i < clients.length; i++) {
                        clientsArr.push({id: clients[i].id, text: clients[i].name});
                        let option = new Option(clients[i].name + ' (' + clients[i].executiveName + ')', clients[i].id, false, false);
                        clientsSelect.append(option);
                    }
                    clientsSelect.trigger('change');
                })
                .catch(function (error) {
                    errorMsg("Couldn't fetch clients. Try again later!");
                });
        });

        $('#submitBtn').click(function (e) {
            e.preventDefault();
            let selectedExecutive = $('#single-select').val(),
                selectedClients = $('select.multi-select').select2('data'), clientIds = [];
            for (let i = 0; i < selectedClients.length; i++) {
                clientIds.push(selectedClients[i]['id']);
            }
            if (selectedExecutive && clientIds.length > 0) {
                swal({
                    text: "Please note that if you move client to another executive then it will be unassigned from already assigned staff members.",
                    icon: "warning", buttons: true,
                    confirmButtonText: 'OK', cancelButtonText: "Cancel", confirmButtonColor: '#24a247',
                }).then((isConfirmed) => {
                    if (isConfirmed) {
                        axios.post('{{route("portal.moveExecutiveClientsRequest")}}', {
                            executive: selectedExecutive,
                            clients: clientIds
                        }).then(function (response) {
                            if (response.data.response_code == 1) {
                                successMsg(response.data.message);
                                setTimeout(function () {
                                    location.href = response.data.data.redirect_url;
                                }, 1500);
                            } else {
                                errorMsg(response.data.message);
                                setTimeout(function () {
                                    location.reload(true);
                                }, 1500);
                            }
                        }).catch(function (error) {
                            errorMsg("Something went wrong. Try again later");
                        });
                    }
                });
            } else {
                errorMsg("Select Executive and Clients first!");
            }
        });
    </script>
@endsection
