@extends('layouts.app')

@section('title', 'View User')

@section('headSource')
    <link rel="stylesheet" href="{!! asset('admin-assets/vendor/select2/css/select2.min.css') !!}">
    <link href="{!! asset('admin-assets/vendor/bootstrap-select/dist/css/bootstrap-select.min.css') !!}"
          rel="stylesheet">
    <!-- Datatable -->
    <link rel="stylesheet" href="{!! asset('admin-assets/vendor/datatables/css/jquery.dataTables.min.css') !!}">
@endsection
<style>
    fieldset {
        padding: 1px 15px 10px !important;
        border: 1px solid #ced4da !important;
        margin-bottom: 15px !important;
    }

    legend {
        width: auto !important;
        padding: 0 10px !important;
        font-weight: 400;
    }

    fieldset input[type="checkbox"] {
        float: right;
        margin-top: 5px;
        margin-right: 15px;
    }

    fieldset label {
        margin-bottom: 0px;
    }

    label {
        font-size: 14px;
    }
</style>
@section('content')

    <div class="row page-titles mx-0">
        <div class="col-sm-6 p-md-0">
            <div class="welcome-text">
                <h4>Role Grant Access</h4>
            </div>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{route('portal.dashboard')}}">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="{{route('portal.userFilterList', ["type" => $type])}}">Users</a>
                </li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Permissions</a></li>
            </ol>
        </div>
    </div>
    <div class="row">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">
                    <div class="profile-tab">
                        <div class="custom-tab-1">
                            <div class="tab-content">
                                <div id="aboutTab" class="tab-pane fade active show">
                                    <div class="profile-personal-info">
                                        <form id="userPermissions" method="post">
                                            <p style="width:300px">Role:
                                                <select id="roleChanger" class="form-control form-control-lg"
                                                        name="role">
                                                    <option value="SuperAdmin"
                                                            @if($type=='SuperAdmin') selected="selected" @endif>Super
                                                        Admin
                                                    </option>
                                                    <option value="Coordinator"
                                                            @if($type==='Coordinator') selected="selected" @endif
                                                    >Coordinator
                                                    </option>
                                                    <option value="Executive"
                                                            @if($type=='Executive') selected="selected" @endif>Executive
                                                    </option>
                                                    <option value="Manager"
                                                            @if($type==='Manager') selected="selected" @endif>Manager
                                                    </option>
                                                    <option value="Admin"
                                                            @if($type=='Admin') selected="selected" @endif>Admin
                                                    </option>
                                                    <option value="Staff"
                                                            @if($type=='Staff') selected="selected" @endif>Staff
                                                    </option>
                                                    <option value="Client"
                                                            @if($type=='Client') selected="selected" @endif>Client
                                                    </option>
                                                </select></p>
                                            <fieldset class="mb-4 mt-4">
                                                <legend><h4 class="text-primary">User Roles Management</h4></legend>
                                                <div class="row">
                                                    <div class="col-sm-6">
                                                        <fieldset>
                                                            <legend><h5 class="text-primary">Super Admin</h5></legend>
                                                            <div class="row">
                                                                <div class="col-sm-4">
                                                                    <label for="addSuperAdmin">Add</label> <input
                                                                        id="addSuperAdmin" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="addUser_superadmin" {{ isPermission('addUser_superadmin', $type) ? 'checked' : '' }}>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="editSuperAdmin">Edit</label> <input
                                                                        id="editSuperAdmin" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="editUser_superadmin" {{ isPermission('editUser_superadmin', $type) ? 'checked' : '' }}>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="viewSuperAdmin">View</label> <input
                                                                        id="viewSuperAdmin" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="viewUser_superadmin" {{ isPermission('viewUser_superadmin', $type) ? 'checked' : '' }}>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="deleteSuperAdmin">Delete</label> <input
                                                                        id="deleteSuperAdmin" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="deleteUser_superadmin" {{ isPermission('deleteUser_superadmin', $type) ? 'checked' : '' }}>
                                                                </div>
                                                                <div class="col-sm-8">
                                                                    <label for="deactivateSuperAdmin">Deactivate</label>
                                                                    <input id="deactivateSuperAdmin" type="checkbox"
                                                                           name="user_permissions[]"
                                                                           value="deactivateUser_superadmin" {{ isPermission('deactivateUser_superadmin', $type) ? 'checked' : '' }}>
                                                                </div>
                                                            </div>
                                                        </fieldset>
                                                    </div>
                                                    <div class="col-sm-6">
                                                        <fieldset>
                                                            <legend><h5 class="text-primary">Coordinator</h5></legend>
                                                            <div class="row">
                                                                <div class="col-sm-4">
                                                                    <label for="addCoordinator">Add</label> <input
                                                                        id="addCoordinator" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="addUser_coordinator" {{ isPermission('addUser_coordinator', $type) ? 'checked' : '' }}>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="editCoordinator">Edit</label> <input
                                                                        id="editCoordinator" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="editUser_coordinator" {{ isPermission('editUser_coordinator', $type) ? 'checked' : '' }}>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="viewCoordinator">View</label> <input
                                                                        id="viewCoordinator" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="viewUser_coordinator" {{ isPermission('viewUser_coordinator', $type) ? 'checked' : '' }}>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="deleteCoordinator">Delete</label> <input
                                                                        id="deleteCoordinator" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="deleteUser_coordinator" {{ isPermission('deleteUser_coordinator', $type) ? 'checked' : '' }}>
                                                                </div>
                                                                <div class="col-sm-8">
                                                                    <label
                                                                        for="deactivateCoordinator">Deactivate</label>
                                                                    <input id="deactivateCoordinator" type="checkbox"
                                                                           name="user_permissions[]"
                                                                           value="deactivateUser_coordinator" {{ isPermission('deactivateUser_coordinator', $type) ? 'checked' : '' }}>
                                                                </div>
                                                            </div>
                                                        </fieldset>
                                                    </div>
                                                    <div class="col-sm-6">
                                                        <fieldset>
                                                            <legend><h5 class="text-primary">Executive</h5></legend>
                                                            <div class="row">
                                                                <div class="col-sm-4">
                                                                    <label for="addExecutive">Add</label> <input
                                                                        id="addExecutive" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="addUser_executive" {{ isPermission('addUser_executive', $type) ? 'checked' : '' }}>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="editExecutive">Edit</label> <input
                                                                        id="editExecutive" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="editUser_executive" {{ isPermission('editUser_executive', $type) ? 'checked' : '' }}>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="viewExecutive">View</label> <input
                                                                        id="viewExecutive" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="viewUser_executive" {{ isPermission('viewUser_executive', $type) ? 'checked' : '' }}>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="deleteExecutive">Delete</label> <input
                                                                        id="deleteExecutive" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="deleteUser_executive" {{ isPermission('deleteUser_executive', $type) ? 'checked' : '' }}>
                                                                </div>
                                                                <div class="col-sm-8">
                                                                    <label for="deactivateExecutive">Deactivate</label>
                                                                    <input id="deactivateExecutive" type="checkbox"
                                                                           name="user_permissions[]"
                                                                           value="deactivateUser_executive" {{ isPermission('deactivateUser_executive', $type) ? 'checked' : '' }}>
                                                                </div>
                                                            </div>
                                                        </fieldset>
                                                    </div>
                                                    <div class="col-sm-6">
                                                        <fieldset>
                                                            <legend><h5 class="text-primary">Manager</h5></legend>
                                                            <div class="row">
                                                                <div class="col-sm-4">
                                                                    <label for="addManager">Add</label> <input
                                                                        id="addManager" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="addUser_manager" {{ isPermission('addUser_manager', $type) ? 'checked' : '' }}>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="editManager">Edit</label> <input
                                                                        id="editManager" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="editUser_manager" {{ isPermission('editUser_manager', $type) ? 'checked' : '' }}>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="viewManager">View</label> <input
                                                                        id="viewManager" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="viewUser_manager" {{ isPermission('viewUser_manager', $type) ? 'checked' : '' }}>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="deleteManager">Delete</label> <input
                                                                        id="deleteManager" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="deleteUser_manager" {{ isPermission('deleteUser_manager', $type) ? 'checked' : '' }}>
                                                                </div>
                                                                <div class="col-sm-8">
                                                                    <label for="deactivateManager">Deactivate</label>
                                                                    <input id="deactivateManager" type="checkbox"
                                                                           name="user_permissions[]"
                                                                           value="deactivateUser_manager" {{ isPermission('deactivateUser_manager', $type) ? 'checked' : '' }}>
                                                                </div>
                                                            </div>
                                                        </fieldset>
                                                    </div>
                                                    <div class="col-sm-6">
                                                        <fieldset>
                                                            <legend><h5 class="text-primary">Admin</h5></legend>
                                                            <div class="row">
                                                                <div class="col-sm-4">
                                                                    <label for="addAdmin">Add</label> <input
                                                                        id="addAdmin" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="addUser_admin" {{ isPermission('addUser_admin', $type) ? 'checked' : '' }}>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="editAdmin">Edit</label> <input
                                                                        id="editAdmin" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="editUser_admin" {{ isPermission('editUser_admin', $type) ? 'checked' : '' }}>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="viewAdmin">View</label> <input
                                                                        id="viewAdmin" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="viewUser_admin" {{ isPermission('viewUser_admin', $type) ? 'checked' : '' }}>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="deleteAdmin">Delete</label> <input
                                                                        id="deleteAdmin" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="deleteUser_admin" {{ isPermission('deleteUser_admin', $type) ? 'checked' : '' }}>
                                                                </div>
                                                                <div class="col-sm-8">
                                                                    <label for="deactivateAdmin">Deactivate</label>
                                                                    <input id="deactivateAdmin" type="checkbox"
                                                                           name="user_permissions[]"
                                                                           value="deactivateUser_admin" {{ isPermission('deactivateUser_admin', $type) ? 'checked' : '' }}>
                                                                </div>
                                                            </div>
                                                        </fieldset>
                                                    </div>
                                                    <div class="col-sm-6">
                                                        <fieldset>
                                                            <legend><h5 class="text-primary">Staff</h5></legend>
                                                            <div class="row">
                                                                <div class="col-sm-4">
                                                                    <label for="addStaff">Add</label> <input
                                                                        id="addStaff" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="addUser_staff" {{ isPermission('addUser_staff', $type) ? 'checked' : '' }}>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="editStaff">Edit</label> <input
                                                                        id="editStaff" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="editUser_staff" {{ isPermission('editUser_staff', $type) ? 'checked' : '' }}>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="viewStaff">View</label> <input
                                                                        id="viewStaff" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="viewUser_staff" {{ isPermission('viewUser_staff', $type) ? 'checked' : '' }}>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="deleteStaff">Delete</label> <input
                                                                        id="deleteStaff" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="deleteUser_staff" {{ isPermission('deleteUser_staff', $type) ? 'checked' : '' }}>
                                                                </div>
                                                                <div class="col-sm-8">
                                                                    <label for="deactivateStaff">Deactivate</label>
                                                                    <input id="deactivateStaff" type="checkbox"
                                                                           name="user_permissions[]"
                                                                           value="deactivateUser_staff" {{ isPermission('deactivateUser_staff', $type) ? 'checked' : '' }}>
                                                                </div>
                                                            </div>
                                                        </fieldset>
                                                    </div>
                                                    <div class="col-sm-6">
                                                        <fieldset>
                                                            <legend><h5 class="text-primary">Client</h5></legend>
                                                            <div class="row">
                                                                <div class="col-sm-4">
                                                                    <label for="addClient">Add</label> <input
                                                                        id="addClient" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="addUser_client" {{ isPermission('addUser_client', $type) ? 'checked' : '' }}>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="editClient">Edit</label> <input
                                                                        id="editClient" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="editUser_client" {{ isPermission('editUser_client', $type) ? 'checked' : '' }}>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="viewClient">View</label> <input
                                                                        id="viewClient" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="viewUser_client" {{ isPermission('viewUser_client', $type) ? 'checked' : '' }}>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label for="deleteClient">Delete</label> <input
                                                                        id="deleteClient" type="checkbox"
                                                                        name="user_permissions[]"
                                                                        value="deleteUser_client" {{ isPermission('deleteUser_client', $type) ? 'checked' : '' }}>
                                                                </div>
                                                                <div class="col-sm-8">
                                                                    <label for="deactivateClient">Deactivate</label>
                                                                    <input id="deactivateClient" type="checkbox"
                                                                           name="user_permissions[]"
                                                                           value="deactivateUser_client" {{ isPermission('deactivateUser_client', $type) ? 'checked' : '' }}>
                                                                </div>
                                                            </div>
                                                        </fieldset>
                                                    </div>
                                                </div>
                                            </fieldset>
                                            <div class="row mb-4 mt-4">
                                                <div class="col-sm-6">
                                                    <fieldset class="mb-4 mt-4">
                                                        <legend><h4 class="text-primary">Task Sheets</h4></legend>
                                                        <div class="row">
                                                            <div class="col-sm-4">
                                                                <label for="addNewSheet">Add</label> <input
                                                                    id="addNewSheet" type="checkbox"
                                                                    name="user_permissions[]"
                                                                    value="addNewSheet_{{$type}}" {{ isPermission('addNewSheet_'.$type, $type) ? 'checked' : '' }}>
                                                            </div>
                                                            <div class="col-sm-4">
                                                                <label for="editSheet">Edit</label> <input
                                                                    id="editSheet" type="checkbox"
                                                                    name="user_permissions[]"
                                                                    value="editSheet_{{$type}}" {{ isPermission('editSheet_'.$type, $type) ? 'checked' : '' }}>
                                                            </div>
                                                            <div class="col-sm-4">
                                                                <label for="viewSheetUser">View</label> <input
                                                                    id="viewSheetUser" type="checkbox"
                                                                    name="user_permissions[]"
                                                                    value="viewSheetUser_{{$type}}" {{ isPermission('viewSheetUser_'.$type, $type) ? 'checked' : '' }}>
                                                            </div>
                                                            <div class="col-sm-4">
                                                                <label for="deleteSheet">Delete</label> <input
                                                                    id="deleteSheet" type="checkbox"
                                                                    name="user_permissions[]"
                                                                    value="deleteSheet_{{$type}}" {{ isPermission('deleteSheet_'.$type, $type) ? 'checked' : '' }}>
                                                            </div>
                                                            <div class="col-sm-8">
                                                                <label for="addAppSheet">Submit via app</label> <input
                                                                    id="addAppSheet" type="checkbox"
                                                                    name="user_permissions[]"
                                                                    value="addAppSheet_{{$type}}" {{ isPermission('addAppSheet_'.$type, $type) ? 'checked' : '' }}>
                                                            </div>
                                                        </div>
                                                    </fieldset>
                                                </div>
                                                <div class="col-sm-6">
                                                    <fieldset class="mb-4 mt-4">
                                                        <legend><h4 class="text-primary">Tasks</h4></legend>
                                                        <div class="row">
                                                            <div class="col-sm-4">
                                                                <label for="addTask">Add</label> <input id="addTask"
                                                                                                        type="checkbox"
                                                                                                        name="user_permissions[]"
                                                                                                        value="addTask_{{$type}}" {{ isPermission('addTask_'.$type, $type) ? 'checked' : '' }}>
                                                            </div>
                                                            <div class="col-sm-4">
                                                                <label for="editTask">Edit</label> <input id="editTask"
                                                                                                          type="checkbox"
                                                                                                          name="user_permissions[]"
                                                                                                          value="editTask_{{$type}}" {{ isPermission('editTask_'.$type, $type) ? 'checked' : '' }}>
                                                            </div>
                                                            <div class="col-sm-4">
                                                                <label for="viewTask">View</label> <input id="viewTask"
                                                                                                          type="checkbox"
                                                                                                          name="user_permissions[]"
                                                                                                          value="viewTask_{{$type}}" {{ isPermission('viewTask_'.$type, $type) ? 'checked' : '' }}>
                                                            </div>
                                                            <div class="col-sm-4">
                                                                <label for="deleteTask">Delete</label> <input
                                                                    id="deleteTask" type="checkbox"
                                                                    name="user_permissions[]"
                                                                    value="deleteTask_{{$type}}" {{ isPermission('deleteTask_'.$type, $type) ? 'checked' : '' }}>
                                                            </div>
                                                            <div class="col-sm-8">
                                                                <label for="taskReport">Task History Reporting</label> <input
                                                                    id="taskReport" type="checkbox" name="user_permissions[]"
                                                                    value="viewTaskReporting_{{$type}}" {{ isPermission('viewTaskReporting_'.$type, $type) ? 'checked' : '' }}>
                                                            </div>
                                                        </div>
                                                    </fieldset>
                                                </div>
                                            </div>

                                            <div class="row mb-4 mt-4">
                                                <div class="col-sm-6">
                                                    <fieldset class="mb-4 mt-4">
                                                        <legend><h4 class="text-primary">Categories</h4></legend>
                                                        <div class="row">
                                                            <div class="col-sm-4">
                                                                <label for="addCategory">Add</label> <input
                                                                    id="addCategory" type="checkbox"
                                                                    name="user_permissions[]"
                                                                    value="addCategory_{{$type}}" {{ isPermission('addCategory_'.$type, $type) ? 'checked' : '' }}>
                                                            </div>
                                                            <div class="col-sm-4">
                                                                <label for="editCategory">Edit</label> <input
                                                                    id="editCategory" type="checkbox"
                                                                    name="user_permissions[]"
                                                                    value="editCategory_{{$type}}" {{ isPermission('editCategory_'.$type, $type) ? 'checked' : '' }}>
                                                            </div>
                                                            <div class="col-sm-4">
                                                                <label for="viewCategory">View</label> <input
                                                                    id="viewCategory" type="checkbox"
                                                                    name="user_permissions[]"
                                                                    value="viewCategory_{{$type}}" {{ isPermission('viewCategory_'.$type, $type) ? 'checked' : '' }}>
                                                            </div>
                                                            <div class="col-sm-4">
                                                                <label for="deleteCategory">Delete</label> <input
                                                                    id="deleteCategory" type="checkbox"
                                                                    name="user_permissions[]"
                                                                    value="deleteCategory_{{$type}}" {{ isPermission('deleteCategory_'.$type, $type) ? 'checked' : '' }}>
                                                            </div>
                                                            <div class="col-sm-4">
                                                                <label for="addUserCategory">Assign to users</label> <input
                                                                    id="addUserCategory" type="checkbox"
                                                                    name="user_permissions[]"
                                                                    value="addUserCategory_{{$type}}" {{ isPermission('addUserCategory_'.$type, $type) ? 'checked' : '' }}>
                                                            </div>
                                                            <div class="col-sm-4">
                                                                <label for="addTaskCategory">Assign to tasks</label> <input
                                                                    id="addTaskCategory" type="checkbox"
                                                                    name="user_permissions[]"
                                                                    value="addTaskCategory_{{$type}}" {{ isPermission('addTaskCategory_'.$type, $type) ? 'checked' : '' }}>
                                                            </div>
                                                        </div>
                                                    </fieldset>
                                                </div>
                                            </div>

{{--                                            <fieldset class="mb-4 mt-4">--}}
{{--                                                <legend><h4 class="text-primary">User Assignments/ Reassignments</h4>--}}
{{--                                                </legend>--}}
{{--                                                <div class="row">--}}
{{--                                                    <div class="col-sm-6">--}}
{{--                                                        <label for="switchClientManager">Switch client to another--}}
{{--                                                            manager</label> <input id="switchClientManager"--}}
{{--                                                                                   type="checkbox"--}}
{{--                                                                                   name="user_permissions[]"--}}
{{--                                                                                   value="switchClientManager_{{$type}}" {{ isPermission('switchClientManager_'.$type, $type) ? 'checked' : '' }}>--}}
{{--                                                    </div>--}}
{{--                                                    <div class="col-sm-6">--}}
{{--                                                        <label for="switchClientStaff">Switch client to staff</label>--}}
{{--                                                        <input id="switchClientStaff" type="checkbox"--}}
{{--                                                               name="user_permissions[]"--}}
{{--                                                               value="switchClientStaff_{{$type}}" {{ isPermission('switchClientStaff_'.$type, $type) ? 'checked' : '' }}>--}}
{{--                                                    </div>--}}
{{--                                                    <div class="col-sm-6">--}}
{{--                                                        <label for="assignClientStaff">Assign client to staff</label>--}}
{{--                                                        <input id="assignClientStaff" type="checkbox"--}}
{{--                                                               name="user_permissions[]"--}}
{{--                                                               value="assignClientStaff_{{$type}}" {{ isPermission('assignClientStaff_'.$type, $type) ? 'checked' : '' }}>--}}
{{--                                                    </div>--}}
{{--                                                </div>--}}
{{--                                            </fieldset>--}}

{{--                                            <fieldset class="mb-4 mt-4">--}}
{{--                                                <legend><h4 class="text-primary">Receive Emails</h4></legend>--}}
{{--                                                <div class="row">--}}
{{--                                                    <div class="col-sm-6">--}}
{{--                                                        <label for="emailTaskSheetStaff">Tasksheet Staff</label> <input--}}
{{--                                                            id="emailTaskSheetStaff" type="checkbox"--}}
{{--                                                            name="user_permissions[]"--}}
{{--                                                            value="emailTaskSheetStaff_{{$type}}" {{ isPermission('emailTaskSheetStaff_'.$type, $type) ? 'checked' : '' }}>--}}
{{--                                                    </div>--}}
{{--                                                    <div class="col-sm-6">--}}
{{--                                                        <label for="emailTaskSheetAdmin">Tasksheet From Admin</label>--}}
{{--                                                        <input id="emailTaskSheetAdmin" type="checkbox"--}}
{{--                                                               name="user_permissions[]"--}}
{{--                                                               value="emailTaskSheetAdmin_{{$type}}" {{ isPermission('emailTaskSheetAdmin_'.$type, $type) ? 'checked' : '' }}>--}}
{{--                                                    </div>--}}
{{--                                                    <div class="col-sm-6">--}}
{{--                                                        <label for="emailTaskSheetManager">Tasksheet From--}}
{{--                                                            Manager</label> <input id="emailTaskSheetManager"--}}
{{--                                                                                   type="checkbox"--}}
{{--                                                                                   name="user_permissions[]"--}}
{{--                                                                                   value="emailTaskSheetManager_{{$type}}" {{ isPermission('emailTaskSheetManager_'.$type, $type) ? 'checked' : '' }}>--}}
{{--                                                    </div>--}}
{{--                                                    <div class="col-sm-6">--}}
{{--                                                        <label for="emailTaskSheetExecutive">Tasksheet From--}}
{{--                                                            Executive</label> <input id="emailTaskSheetExecutive"--}}
{{--                                                                                     type="checkbox"--}}
{{--                                                                                     name="user_permissions[]"--}}
{{--                                                                                     value="emailTaskSheetExecutive_{{$type}}" {{ isPermission('emailTaskSheetExecutive_'.$type, $type) ? 'checked' : '' }}>--}}
{{--                                                    </div>--}}
{{--                                                </div>--}}
{{--                                            </fieldset>--}}

                                            <fieldset class="mb-4 mt-4">
                                                <legend><h4 class="text-primary">Others</h4></legend>
                                                <div class="row">
                                                    <div class="col-sm-6">
                                                        <label for="loginViaApp">Login via App?</label> <input
                                                            id="loginViaApp" type="checkbox" name="user_permissions[]"
                                                            value="loginViaApp_{{$type}}" {{ isPermission('loginViaApp_'.$type, $type) ? 'checked' : '' }}>
                                                    </div>
                                                </div>
                                            </fieldset>

                                            <fieldset class="mb-4 mt-4">
                                                <legend><h4 class="text-primary">Password</h4></legend>
                                                <div class="row">
                                                    <div class="col-sm-6">
                                                        <label for="password">Can Change Password?</label> <input
                                                            id="password" type="checkbox" name="user_permissions[]"
                                                            value="password_{{$type}}" {{ isPermission('password_'.$type, $type) ? 'checked' : '' }}>
                                                    </div>
                                                    <div class="col-sm-6">
                                                        <label for="passwordReset">Reset Password?</label> <input
                                                            id="passwordReset" type="checkbox" name="user_permissions[]"
                                                            value="passwordReset_{{$type}}" {{ isPermission('passwordReset_'.$type, $type) ? 'checked' : '' }}>
                                                    </div>
                                                </div>
                                            </fieldset>
                                            <input type="submit" class="btn btn-primary" name="submit" value="Save"/>
                                        </form>

                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('footerSource')
    <!-- Daterangepicker -->
    <!-- momment js is must -->
    <script src="{!! asset('admin-assets/vendor/moment/moment.min.js') !!}"></script>
    <script src="{!! asset('admin-assets/vendor/bootstrap-daterangepicker/daterangepicker.js') !!}"></script>
    <script>


        $(document).ready(function () {


            $("#roleChanger").change(function (e) {
                let value = $(this).val();
                window.location = "{{url("admin/dashboard/users/permissions")}}/" + $(this).val();
            });

            // add user form submit
            $("#userPermissions").submit(function (e) {
                e.preventDefault();
                let data = new FormData($(this)[0]);
                axios.post('{{route("portal.addUserPermissions")}}', data)
                    .then(function (response) {
                        if (response.data.response_code == 1) {
                            successMsg(response.data.message);
                        } else {
                            errorMsg(response.data.message);
                        }
                    })
                    .catch(function (error) {

                    });
            });
        });
    </script>
@endsection
