@extends('layouts.app')

@section('title', 'View User')

@section('headSource')
    <link rel="stylesheet" href="{!! asset('admin-assets/vendor/select2/css/select2.min.css') !!}">
    <link href="{!! asset('admin-assets/vendor/bootstrap-select/dist/css/bootstrap-select.min.css') !!}" rel="stylesheet">
    <!-- Datatable -->
    <link rel="stylesheet" href="{!! asset('admin-assets/vendor/datatables/css/jquery.dataTables.min.css') !!}">
@endsection

@section('content')

    <div class="row page-titles mx-0">
        <div class="col-sm-6 p-md-0">
            <div class="welcome-text">
                <h4>View {{$user->role}}</h4>
            </div>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{route('portal.dashboard')}}">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="{{ route("portal.userFilterList")}}/{{strtolower($user->role)}}/{{$user->branch_id}}"> {{$branchName}} Users</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">{{$user->role}}</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Detail</a></li>
            </ol>
        </div>
    </div>

    <!-- row -->
    <div class="row">
        <div class="col-lg-12">
            <div class="profile card card-body px-3 pt-3 pb-0">
                <div class="profile-head">
                    <div class="profile-info">
                        <div class="profile-photo">
                            <img src="{!! $user->thumbnail !!}" class="rounded-circle" alt="" style="width: 100px; height: 100px;">
                        </div>
                        <div class="profile-details">
                            <div class="profile-name px-3 pt-2">
                                <h4 class="text-primary mb-0">{{$user->name}}</h4>
                                <p>{{$user->role}}</p>
                            </div>
                            <div class="profile-email px-2 pt-2">
                                <h4 class="text-muted mb-0">{{$user->email}}</h4>
                                <p>{{$user->username}}</p>
                            </div>
                            <div class="dropdown ml-auto">
                                <a href="#" class="btn btn-primary light sharp" data-toggle="dropdown" aria-expanded="true"><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="18px" height="18px" viewBox="0 0 24 24" version="1.1"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><rect x="0" y="0" width="24" height="24"></rect><circle fill="#000000" cx="5" cy="12" r="2"></circle><circle fill="#000000" cx="12" cy="12" r="2"></circle><circle fill="#000000" cx="19" cy="12" r="2"></circle></g></svg></a>
                                <ul class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(-169px, 30px, 0px);">
                                    <li><a class="dropdown-item" href="{!! route("portal.editUserPage", ["id" => $user->id]) !!}"> <i class="fa fa-pencil text-primary mr-2"></i> Edit </a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">
                    <div class="profile-tab">
                        <div class="custom-tab-1">
                            <ul class="nav nav-tabs">
                                @if($user->role == "SuperAdmin" || $user->role == 'Client')
                                    <li class="nav-item"><a href="#aboutTab" data-toggle="tab" class="nav-link active show">About</a></li>
                                @else
                                    <li class="nav-item"><a href="#taskHistoryTab" data-toggle="tab" class="nav-link active show">Task History</a></li>
                                    @if($user->role == "Executive" && (checkPermission('addUserCategory', Auth::user()->role) || Auth::user()->role == 'SuperAdmin'))
                                        <li class="nav-item"><a href="#categoryTab" data-toggle="tab" class="nav-link">Categories</a></li>
                                    @endif
                                    @if($user->role == "Staff")
                                        <li class="nav-item"><a href="#clientsTab" data-toggle="tab" class="nav-link">Clients</a></li>
                                    @endif
                                    <li class="nav-item"><a href="#aboutTab" data-toggle="tab" class="nav-link">About</a></li>
                                @endif
                            </ul>
                            <div class="tab-content">
                                <div id="aboutTab" class="tab-pane fade {{($user->role == "SuperAdmin" || $user->role == 'Client') ? 'active show' : '' }}">
                                    <div class="profile-personal-info">
                                        <h4 class="text-primary mb-4 mt-4">Information</h4>
                                        <div class="row mb-2">
                                            <div class="col-3">
                                                <h5 class="f-w-500">Name <span class="pull-right">:</span>
                                                </h5>
                                            </div>
                                            <div class="col-9"><span>{{$user->name}}</span>
                                            </div>
                                        </div>
                                        <div class="row mb-2">
                                            <div class="col-3">
                                                <h5 class="f-w-500">Email <span class="pull-right">:</span>
                                                </h5>
                                            </div>
                                            <div class="col-9"><span>{{$user->email}}</span>
                                            </div>
                                        </div>
                                        <div class="row mb-2">
                                            <div class="col-3">
                                                <h5 class="f-w-500">Username <span class="pull-right">:</span></h5>
                                            </div>
                                            <div class="col-9"><span>{{$user->username}}</span>
                                            </div>
                                        </div>
                                        <div class="row mb-2">
                                            <div class="col-3">
                                                <h5 class="f-w-500">Date of birth <span class="pull-right">:</span>
                                                </h5>
                                            </div>
                                            <div class="col-9"><span>{{$user->date_of_birth}}</span>
                                            </div>
                                        </div>
                                        <div class="row mb-2">
                                            <div class="col-3">
                                                <h5 class="f-w-500">Gender <span class="pull-right">:</span>
                                                </h5>
                                            </div>
                                            <div class="col-9"><span>{{$user->gender}}</span>
                                            </div>
                                        </div>
                                        <div class="row mb-2">
                                            <div class="col-3">
                                                <h5 class="f-w-500">Address <span class="pull-right">:</span>
                                                </h5>
                                            </div>
                                            <div class="col-9"><span>{{$user->address}}</span>
                                            </div>
                                        </div>
                                        <div class="row mb-2">
                                            <div class="col-3">
                                                <h5 class="f-w-500">Phone Number <span class="pull-right">:</span>
                                                </h5>
                                            </div>
                                            <div class="col-9"><span>{{$user->phone_number}}</span>
                                            </div>
                                        </div>
                                        <div class="row mb-2">
                                            <div class="col-3">
                                                <h5 class="f-w-500">Emergency Contact <span class="pull-right">:</span>
                                                </h5>
                                            </div>
                                            <div class="col-9"><span>{{$user->emergency_contact}}</span>
                                            </div>
                                        </div>
                                        @if($user->role == "Staff")
                                            <div class="row mb-2">
                                                <div class="col-3">
                                                    <h5 class="f-w-500">Employee Id <span class="pull-right">:</span>
                                                    </h5>
                                                </div>
                                                <div class="col-9"><span>{{$user->employee_id}}</span>
                                                </div>
                                            </div>
                                        @endif
                                        @if($user->role == "Client")
                                            <div class="row mb-2">
                                                <div class="col-3">
                                                    <h5 class="f-w-500">Staff <span class="pull-right">:</span>
                                                    </h5>
                                                </div>
                                                <div class="col-9">
                                                    @if($user->relateStaff()->first())
                                                        <span>{{$user->relateStaff()->first()->name}}</span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="row mb-2">
                                                <div class="col-3">
                                                    <h5 class="f-w-500">Identification Number  <span class="pull-right">:</span>
                                                    </h5>
                                                </div>
                                                <div class="col-9"><span>{{$user->ddd_id}}</span>
                                                </div>
                                            </div>
                                        @endif
                                        {{--<div class="row mb-2">
                                            <div class="col-3">
                                                <h5 class="f-w-500">Login From <span class="pull-right">:</span>
                                                </h5>
                                            </div>
                                            <div class="col-9"><span>{{$user->login_from}}</span>
                                            </div>
                                        </div>--}}
                                        <div class="row mb-2">
                                            <div class="col-3">
                                                <h5 class="f-w-500">Role <span class="pull-right">:</span>
                                                </h5>
                                            </div>
                                            <div class="col-9"><span>{{$user->role}}</span>
                                            </div>
                                        </div>
                                        <div class="row mb-2">
                                            <div class="col-3">
                                                <h5 class="f-w-500">Status <span class="pull-right">:</span>
                                                </h5>
                                            </div>
                                            <div class="col-9"><span>{!! ($user->status == 1)? '<span class="badge light badge-success">Active</span>': '<span class="badge light badge-warning">Inactive</span>'  !!}</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @if($user->role != "SuperAdmin" && $user->role != 'Client')
                                    @if($user->role == "Executive" && (checkPermission('addUserCategory', Auth::user()->role) || Auth::user()->role == 'SuperAdmin'))
                                        <div id="categoryTab" class="tab-pane fade">
                                            <div class="pt-4">
                                                <div class="settings-form col-sm-6">
                                                    <h4 class="text-primary">Assign New Categories</h4>
                                                    <form id="assignCategoryToUserForm">
                                                        <div class="form-group">
                                                            <label>Choose Categories</label>
                                                            <select class="multi-select select2-dropdown" name="categories[]" multiple="multiple" required>
                                                                @foreach($categories as $category)
                                                                    <option value="{{$category->id}}">{{$category->title}}</option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                        <button class="btn btn-primary" type="submit">Assign</button>
                                                    </form>
                                                </div>
                                            </div>
                                            <div class="mt-4">
                                                <h4 class="text-primary mb-4">Assigned Categories</h4>
                                                <div class="table-responsive">
                                                    <table class="display listing-table" style="min-width: 845px">
                                                        <thead>
                                                        <tr>
                                                            <th>Sr</th>
                                                            <th>Title</th>
                                                            <th>Action</th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        @foreach($user->userCategories as $item)
                                                            <tr>
                                                                <td>{{$loop->iteration}}</td>
                                                                <td>{{$item->title}}</td>
                                                                <td>
                                                                    <a href="{{ route("portal.removeCategoryFromUserRequest", ["id" => $item->pivot->id]) }}" class="deletedBtn btn btn-danger mr-1 shadow sharp"><i class="fa fa-trash"></i> Remove</a>
                                                                </td>
                                                            </tr>
                                                        @endforeach
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    @endif
                                @if($user->role == "Staff")
                                    <div id="clientsTab" class="tab-pane fade">
                                        <div class="pt-4">
                                            <div class="settings-form">
                                                <h4 class="text-primary">Add Clients</h4>
                                                <form id="assignClientToStaffForm">
                                                    <div class="form-group">
                                                        <label>Clients</label>
                                                        <select class="multi-select select2-dropdown" name="clients[]" multiple="multiple">
                                                            @foreach($clients as $client)
                                                                <option value="{{$client->id}}">{{$client->name}} {{--({{$client->username}})--}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <button class="btn btn-primary" type="submit">Add</button>
                                                </form>
                                            </div>
                                        </div>
                                        <div class="mt-4">
                                            <h4 class="text-primary mb-4">Assigned Clients</h4>
                                            <div class="table-responsive">
                                                <table class="display listing-table" style="min-width: 845px">
                                                    <thead>
                                                    <tr>
                                                        <th>Sr</th>
                                                        <th>Name</th>
                                                        {{--<th>Username</th>--}}
                                                        <th>Email</th>
                                                        <th>Action</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    @foreach($user->staffClients as $client)
                                                        <tr>
                                                            <td>{{$loop->iteration}}</td>
                                                            <td>{{$client->name}}</td>
                                                            {{--<td>{{$client->username}}</td>--}}
                                                            <td>{{$client->email}}</td>
                                                            <td>
                                                                <div class="d-flex">
                                                                    <a href="{{ route("portal.viewUserPage", ["id" => $client->id]) }}" class="btn btn-success shadow sharp mr-1" target="_blank"><i class="fa fa-cog"></i> Operations</a>
                                                                    <a href="{{ route("portal.removeClientFromStaffRequest", ["id" => $client->pivot->id]) }}" class="deletedBtn btn btn-danger mr-1 shadow sharp"><i class="fa fa-trash"></i> Remove</a>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                                    <div id="taskHistoryTab" class="tab-pane fade active show">
                                        <div class="mt-4">
                                            <h4 class="text-primary mb-4">Task History</h4>
                                            <div class="table-responsive">
                                                <table id="datatable2" class="display" style="min-width: 845px; width: 100%">
                                                    <thead>
                                                    <tr>
                                                        <th>Id</th>
                                                        <th>Sr</th>
                                                        <th>Sheet</th>
                                                        <th>Client</th>
                                                        <th>Created At</th>
                                                        <th>Action</th>
                                                    </tr>
                                                    </thead>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('footerSource')
    <script src="{!! asset('admin-assets/vendor/select2/js/select2.full.min.js') !!}"></script>
    <!-- Datatable -->
    <script src="{!! asset('admin-assets/vendor/datatables/js/jquery.dataTables.min.js') !!}"></script>
    <script>
        $(document).ready(function (e) {
            $('.select2-dropdown').select2();

            // add client form submit
            $("#assignClientToStaffForm").submit(function (e) {
                e.preventDefault();
                let data = $(this).serialize()+"&id={{$user->id}}";
                axios.post('{{route("portal.assignClientToStaffRequest")}}', data)
                    .then(function (response) {
                        if(response.data.response_code == 1){
                            successMsg(response.data.message);
                            setTimeout(function () {
                                location.reload();
                            }, 1000);
                        } else {
                            errorMsg(response.data.message);
                        }
                    })
                    .catch(function (error) {

                    });
            });

            $("#assignCategoryToUserForm").submit(function (e) {
                e.preventDefault();
                let data = $(this).serialize()+"&id={{$user->id}}";
                axios.post('{{route("portal.assignCategoryToUserRequest")}}', data)
                    .then(function (response) {
                        if(response.data.response_code == 1){
                            successMsg(response.data.message);
                            setTimeout(function () {
                                location.reload();
                            }, 1000);
                        } else {
                            errorMsg(response.data.message);
                        }
                    })
                    .catch(function (error) {

                    });
            });

            // staff clients listing
            $('.listing-table').DataTable();

            // task history listing
            $('#datatable2').DataTable({
                processing: true,
                serverSide: true,
                ajax: '{!! route('portal.userTaskHistoryDatatable', ["id" => $user->id]) !!}',
                columns: [
                    { data: 'id', name: 'id', 'visible': false},
                    { data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false,searchable: false},
                    { data: 'sheet.name', name: 'sheet.name' },
                    { data: 'client.name', name: 'client.name' },
                    { data: 'created_at', name: 'created_at' },
                    { data: 'action', name: 'action', orderable: false},
                ],
                "order": [[0, 'desc']],
            });
        });
    </script>
@endsection
