<?php

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::namespace('ApiController')->name('api.')->prefix('v1')->group(function () {
    // staff api's
    Route::namespace('StaffController')->prefix('staff')->name('staff.')->group(function (){
        Route::post('/sign-in', 'AuthController@signInRequest')->name('signInRequest');


        Route::middleware(["auth:api", "check.trial"])->group(function (){
            Route::post('/profile-detail', 'DashboardController@profileDetail')->name('profileDetail');
            Route::post('/update-profile', 'DashboardController@updateProfile')->name('profileUpdate');
            Route::post('/profile-img-update', 'DashboardController@updateProfileImg')->name('profileImgUpdate');
            Route::post('/staff-client-listing', 'DashboardController@staffClientListing')->name('clientListing');
            Route::post('/data-sheet-listing', 'DataSheetController@dataSheetListing')->name('dataSheetListing');
            Route::post('/data-sheet-tasks/{id}', 'DataSheetController@dataSheetTasks')->name('dataSheetTasks');
            Route::post('/generate-sheet-progress-note', 'DataSheetController@generateSheetProgressNote')->name('generateSheetProgressNote');
            Route::post('/save-sheet-tasks', 'DataSheetController@saveSheetTasks')->name('saveSheetTasks');
            Route::post('/get-sheet-reports', 'TaskReportController@getSheetReports')->name('getSheetReports');

        });
    });
// client api's
    Route::namespace('ClientController')->prefix('client')->name('client.')->group(function (){
        Route::middleware(["auth:api", "check.trial"])->group(function () {
            Route::post('/dashboard-data', 'DashboardController@clientDashboard')->name('clientDashboardData');
            Route::post('/get-reports-history', 'DashboardController@sheetReports')->name('sheetReportsHistory');
            Route::post('/submit-feedback', 'DashboardController@submitFeedback')->name('submitClientFeedback');
        });
    });
});




