

<?php $__env->startSection('title', 'Edit Category'); ?>

<?php $__env->startSection('headSource'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row page-titles mx-0">
        <div class="col-sm-6 p-md-0">
            <div class="welcome-text">
                <h4>Edit Category</h4>
            </div>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('portal.dashboard')); ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route('portal.categoryListPage')); ?>">Categories</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Edit</a></li>
            </ol>
        </div>
    </div>

    <div class="row">
        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 col-xl-12">
            <div class="card mb-3">
                <div class="card-header">
                    <h3><i class="fa fa-list-alt"></i> Category details</h3>
                </div>
                <div class="card-body">
                    <form id="categoryEditForm" method="post">
                        <div class="row">
                            <div class="col-lg-12 col-xl-12">
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Category Title (required)</label>
                                            <input class="form-control" name="title" type="text"
                                                   value="<?php echo e($record->title); ?>" required/>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Status</label>
                                            <select class="form-control form-control-lg" name="status">
                                                <option value="1" <?php echo e(($record->status == 1) ? "selected": ""); ?>>Active
                                                </option>
                                                <option value="0" <?php echo e(($record->status == 0) ? "selected": ""); ?>>In-Active
                                                </option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <button type="submit" class="btn btn-primary">Update Category</button>
                            </div>
                        </div>
                    </form>
                </div>
                <!-- end card-body -->
            </div>
            <!-- end card -->
        </div>
        <!-- end col -->
    </div>
    <!-- end row -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footerSource'); ?>

    <script>
        $(document).ready(function () {
            // editcategory form submit
            $("#categoryEditForm").submit(function (e) {
                e.preventDefault();
                let data = $(this).serialize() + "&id=<?php echo e($record->id); ?>";
                axios.put('<?php echo e(route("portal.updateCategoryRequest")); ?>', data)
                    .then(function (response) {
                        if (response.data.response_code == 1) {
                            successMsg(response.data.message);
                            setTimeout(function () {
                                location.reload();
                            }, 1000);
                        } else {
                            errorMsg(response.data.message);
                        }
                    })
                    .catch(function (error) {

                    });
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/bbcareapp/resources/views/portal/categories/editCategory.blade.php ENDPATH**/ ?>