<?php $__env->startSection('title', 'Add Sheet Task'); ?>

<?php $__env->startSection('headSource'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<style>
    .prompt-tags span, .pro-notes span, .pro-notes-ind span {
        margin-top: 2px;
        cursor: pointer;
    }

    .pro-notes span.selected, .pro-notes-ind span.selected {
        color: #3d4465 !important;
    }

    .multi-answers span i {
        position: relative;
        top: -5px;
        left: -3px;
        opacity: 0;
        pointer-events: none;
    }
    .multi-answers span.selected:hover i.fa {
        opacity: 1 !important;
        pointer-events: auto;
    }

</style>
    <div class="row page-titles mx-0">
        <div class="col-sm-6 p-md-0">
            <div class="welcome-text">
                <h4>Add New Task</h4>
            </div>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('portal.dashboard')); ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route('portal.dataSheetListPage')); ?>">Task Sheets</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">View Task Sheets</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Add New Task</a></li>
            </ol>
        </div>
    </div>

    <div class="row">
        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 col-xl-12">
            <div class="card mb-3">
                <div class="card-header">
                    <h3><i class="fa fa-list-alt"></i> Task detail</h3>
                </div>
                <div class="card-body">
                    <form id="sheetTaskAddForm" method="post">
                        <div class="row">
                            <div class="col-lg-12 col-xl-12">
                                <div class="row">
                                    <div class="col-lg-8">
                                        <div class="form-group">
                                            <label>Title (required)</label>
                                            <textarea id="sheetTitle" class="form-control" name="title" required></textarea>
                                        </div>
                                    </div>
                                    <div class="col-lg-4">
                                        <div class="form-group">
                                            <label>Select Sheet Type (required)</label>
                                            <select id="sheetType" class="form-control form-control-lg" name="sheet_type" required>
                                                <?php $__currentLoopData = $sheetTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($type->id); ?>" data-options="<?php echo e(strtoupper($type->options)); ?>"><?php echo e($type->title); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label><span id="noteLabel1">Progress Note</span> (required)</label>
                                            <div class="mb-2 pro-notes" style="display: flex; justify-content: flex-start">
                                                <div style="width: 80%">
                                                    <span class="multi-answers">
                                                        <span class="badge badge-sm selected"
                                                              onclick="answerChangeHandle(this)">Answer 1 <i
                                                                class="fa fa-minus-circle text-danger"
                                                                onclick="removeAnswer(this)"></i></span>
                                                    </span>
                                                    <span id="addAnswer" class="badge badge-primary badge-sm"
                                                          data-toggle="tooltip" title="Add more"
                                                          style="cursor: pointer;">Add more</span>
                                                </div>
                                                <div style="width: 20%">
                                                    <span id="progressAssessment" class="badge badge-sm">Assessment</span>
                                                    <span id="progressPlan" class="badge badge-sm">Plan</span>
                                                </div>
                                            </div>
                                            <textarea id="progressNote" class="form-control"></textarea>
                                            <textarea id="progressAssessmentText" class="form-control" name="progress_assessment" style="display: none"></textarea>
                                            <textarea id="progressPlanText" class="form-control" name="progress_plan" style="display: none"></textarea>
                                        </div>
                                        <div class="mb-3 prompt-tags">
                                            <span class="badge badge-secondary insertTag" data-toggle="tooltip" title="Jhon Doe" style="cursor: pointer;" data-tag="##ClientFullName##">##ClientFullName##</span>
                                            <span class="badge badge-secondary insertTag" data-toggle="tooltip" title="Jhon" style="cursor: pointer;" data-tag="##ClientFirstName##">##ClientFirstName##</span>
                                            <span class="badge badge-secondary insertTag" data-toggle="tooltip" title="He/She" style="cursor: pointer;" data-tag="##ClientGenderNoun##">##ClientGenderNoun##</span>
                                            <span class="badge badge-secondary insertTag" data-toggle="tooltip" title="His/Her" style="cursor: pointer;" data-tag="##HIS-HER-GenderNoun##">##HIS-HER-GenderNoun##</span>
                                            <span class="badge badge-secondary insertTag" data-toggle="tooltip" title="Him/Her" style="cursor: pointer;" data-tag="##HIM-HER-Objective##">##HIM-HER-Objective##</span>
                                            <span class="badge badge-secondary insertTag" data-toggle="tooltip" title="Selected Answer" style="cursor: pointer;" data-tag="##AnswerPrompt##">##AnswerPrompt##</span>
                                        </div>
                                    </div>
                                    <div class="col-lg-12 mt-3">
                                        <div class="form-group">
                                            <label><span id="noteLabel2">Progress Note For Independent Prompt</span> (required)</label>
                                            <div class="mb-2 pro-notes-ind" style="display: flex; justify-content: flex-start">
                                                <div style="width: 80%">
                                                <span class="multi-answers">
                                                    <span class="badge badge-sm selected" onclick="answerIndChangeHandle(this)">Answer 1 <i class="fa fa-minus-circle text-danger" onclick="removeAnswerInd(this)"></i></span>
                                                </span>
                                                <span id="addAnswerInd" class="badge badge-primary badge-sm" data-toggle="tooltip" title="Add more"
                                                      style="cursor: pointer;">Add more</span>
                                                </div>
                                                <div style="width: 20%">
                                                    <span id="progressAssessmentInd" class="badge badge-sm">Assessment</span>
                                                    <span id="progressPlanInd" class="badge badge-sm">Plan</span>
                                                </div>
                                            </div>
                                            <textarea id="progressNoteIndependent" class="form-control"></textarea>
                                            <textarea id="progressAssessmentIndText" class="form-control" name="independent_assessment" style="display: none"></textarea>
                                            <textarea id="progressPlanIndText" class="form-control" name="independent_plan" style="display: none"></textarea>
                                        </div>
                                        <div class="mb-3 prompt-tags">
                                            <span class="badge badge-secondary insertTagInd" data-toggle="tooltip" title="Jhon Doe" style="cursor: pointer;" data-tag="##ClientFullName##">##ClientFullName##</span>
                                            <span class="badge badge-secondary insertTagInd" data-toggle="tooltip" title="Jhon" style="cursor: pointer;" data-tag="##ClientFirstName##">##ClientFirstName##</span>
                                            <span class="badge badge-secondary insertTagInd" data-toggle="tooltip" title="He/She" style="cursor: pointer;" data-tag="##ClientGenderNoun##">##ClientGenderNoun##</span>
                                            <span class="badge badge-secondary insertTagInd" data-toggle="tooltip" title="His/Her" style="cursor: pointer;" data-tag="##HIS-HER-GenderNoun##">##HIS-HER-GenderNoun##</span>
                                            <span class="badge badge-secondary insertTagInd" data-toggle="tooltip" title="Him/Her" style="cursor: pointer;" data-tag="##HIM-HER-Objective##">##HIM-HER-Objective##</span>
                                            <span id="answerPrompt" class="badge badge-secondary insertTagInd" data-toggle="tooltip" title="Selected Answer" style="cursor: pointer;" data-tag="##AnswerPrompt##">##AnswerPrompt##</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <button type="submit" class="btn btn-primary">Add Task</button>
                            </div>
                        </div>
                    </form>
                </div>
                <!-- end card-body -->
            </div>
            <!-- end card -->
        </div>
        <!-- end col -->
    </div>
    <!-- end row -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footerSource'); ?>

<script>
    // Select first option on page load
    $("#sheetType").val($("#sheetType option:first").val());

    let progressAnswers = [''], progressAnswersInd = [''];

    function answerChangeHandle(elem, addNew = false) {
        if ($(elem).hasClass('selected') && !addNew) return;

        $('#progressPlanText').hide();
        $('#progressAssessmentText').hide();
        $('#progressNote').show();

        let selectedIndex = 0;
        if ($('.pro-notes .multi-answers span.selected')) {
            selectedIndex = $('.pro-notes .multi-answers span.selected').index();
        }

        progressAnswers[selectedIndex] = $("#progressNote").val();
        $("#progressNote").val('');
        $('.pro-notes span.selected').removeClass('selected');
        if (addNew) {
            let tagsLen = $('.pro-notes .multi-answers span').length;
            $('.pro-notes .multi-answers').append(`<span class="badge badge-sm selected" onclick="answerChangeHandle(this)">Answer ${tagsLen + 1} <i class="fa fa-minus-circle text-danger" onclick="removeAnswer(this)"></i></span>`);
            progressAnswers.push('');
        } else {
            $(elem).addClass('selected');
            $('#progressNote').val(progressAnswers[$(elem).index()]);
        }
    }

    function removeAnswer(elem) {
        if ($('.pro-notes .multi-answers span').length === 1) return;

        let parentSpan = $(elem).closest('span.badge'),
            parentIndex = parentSpan.index();
        progressAnswers.splice(parentIndex, 1);
        parentSpan.remove();
        // reindex answer
        $('.pro-notes .multi-answers span').each(function(index) {
            $(this).text(`Answer ${index + 1} `).append('<i class="fa fa-minus-circle text-danger" onclick="removeAnswer(this)"></i>');
        });
        // select first answer
        $('.pro-notes .multi-answers span:first').trigger('click');
    }

    function pushAnswerOnChange() {
        if ($('.pro-notes .multi-answers span.selected')) {
            let selectedIndex = $('.pro-notes .multi-answers span.selected').index();
            progressAnswers[selectedIndex] = $("#progressNote").val();
            $('#progressNote').val('');
        }
    }


    function answerIndChangeHandle(elem, addNew = false) {
        if ($(elem).hasClass('selected') && !addNew) return;

        $('#progressPlanIndText').hide();
        $('#progressAssessmentIndText').hide();
        $('#progressNoteIndependent').show();

        let selectedIndex = 0;
        if ($('.pro-notes-ind .multi-answers span.selected')) {
            selectedIndex = $('.pro-notes-ind .multi-answers span.selected').index();
        }

        progressAnswersInd[selectedIndex] = $("#progressNoteIndependent").val();
        $('#progressNoteIndependent').val('');
        $('.pro-notes-ind span.selected').removeClass('selected');
        if (addNew) {
            let tagsLen = $('.pro-notes-ind .multi-answers span').length;
            $('.pro-notes-ind .multi-answers').append(`<span class="badge badge-sm selected" onclick="answerIndChangeHandle(this)">Answer ${tagsLen + 1} <i class="fa fa-minus-circle text-danger" onclick="removeAnswerInd(this)"></i></span>`);
            progressAnswersInd.push('');
        } else {
            $(elem).addClass('selected');
            $('#progressNoteIndependent').val(progressAnswersInd[$(elem).index()]);
        }
    }

    function removeAnswerInd(elem) {
        if ($('.pro-notes-ind .multi-answers span').length === 1) return;

        let parentSpan = $(elem).closest('span.badge'),
            parentIndex = parentSpan.index();
        progressAnswersInd.splice(parentIndex, 1);
        parentSpan.remove();
        // reindex answer
        $('.pro-notes-ind .multi-answers span').each(function(index) {
            $(this).text(`Answer ${index + 1} `).append('<i class="fa fa-minus-circle text-danger" onclick="removeAnswerInd(this)"></i>');
        });
        // select first answer
        $('.pro-notes-ind .multi-answers span:first').trigger('click');
    }

    function pushIndAnswerOnChange() {
        if ($('.pro-notes-ind .multi-answers span.selected')) {
            let selectedIndex = $('.pro-notes-ind .multi-answers span.selected').index();
            progressAnswersInd[selectedIndex] = $("#progressNoteIndependent").val();
            $("#progressNoteIndependent").val('');
        }
    }

    $(document).ready(function () {
        // insert tag in progress note
        $(".insertTag").click(function (e) {
            let tag = $(this).data("tag");
            let textArea = $('#progressAssessment').hasClass('selected')
                ? '#progressAssessmentText' : ($('#progressPlan').hasClass('selected')
                    ? '#progressPlanText' : '#progressNote');
            let noteTxt = $(textArea).val();
            let upDateNoteTxt = noteTxt+' '+tag+' ';
            $(textArea).val(upDateNoteTxt);
        });
        $(".insertTagInd").click(function (e) {
            let tag = $(this).data("tag");
            let textArea = $('#progressAssessmentInd').hasClass('selected')
                ? '#progressAssessmentIndText' : ($('#progressPlanInd').hasClass('selected')
                    ? '#progressPlanIndText' : '#progressNoteIndependent');
            let noteTxt = $(textArea).val();
            let upDateNoteTxt = noteTxt+' '+tag+' ';
            $(textArea).val(upDateNoteTxt);
        });

        // tooltip
        $('[data-toggle="tooltip"]').tooltip();


        $('#addAnswer').click(function (e) {
            answerChangeHandle($(this), true);
        });

        // save value on focus change
        $('#progressNote').blur(function() {
            if ($('.pro-notes .multi-answers span.selected')) {
                let selectedIndex = $('.pro-notes .multi-answers span.selected').index();
                progressAnswers[selectedIndex] = $(this).val();
            }
        });

        // save value on focus change
        $('#progressNoteIndependent').blur(function() {
            if ($('.pro-notes-ind .multi-answers span.selected')) {
                let selectedIndex = $('.pro-notes-ind .multi-answers span.selected').index();
                progressAnswersInd[selectedIndex] = $(this).val();
            }
        });

        $('#progressAssessment').click(function (e) {
            pushAnswerOnChange();
            $('.pro-notes span.selected').removeClass('selected');
            $(this).addClass('selected');
            $('#progressNote').hide();
            $('#progressPlanText').hide();
            $('#progressAssessmentText').show();
        });

        $('#progressPlan').click(function (e) {
            pushAnswerOnChange();
            $('.pro-notes span.selected').removeClass('selected');
            $(this).addClass('selected');
            $('#progressNote').hide();
            $('#progressAssessmentText').hide();
            $('#progressPlanText').show();
        });

        $('#addAnswerInd').click(function (e) {
            answerIndChangeHandle($(this), true);
        });

        $('#progressAssessmentInd').click(function (e) {
            pushIndAnswerOnChange();
            $('.pro-notes-ind span.selected').removeClass('selected');
            $(this).addClass('selected');
            $('#progressNoteIndependent').hide();
            $('#progressPlanIndText').hide();
            $('#progressAssessmentIndText').show();
        });

        $('#progressPlanInd').click(function (e) {
            pushIndAnswerOnChange();
            $('.pro-notes-ind span.selected').removeClass('selected');
            $(this).addClass('selected');
            $('#progressNoteIndependent').hide();
            $('#progressAssessmentIndText').hide();
            $('#progressPlanIndText').show();
        });

        // add sheet task form submit
        $("#sheetTaskAddForm").submit(function (e) {
            e.preventDefault();
            let filteredProgressAnswers = progressAnswers.filter(function(elem) {
                return elem.trim() !== '';
            });

            let filteredProgressAnswersInd = progressAnswersInd.filter(function(elem) {
                return elem.trim() !== '';
            });

            if (!filteredProgressAnswers.length || !filteredProgressAnswersInd.length) {
                errorMsg('Please enter at-least one progress note.');
            } else {
                
                let postData = {
                    title: $('#sheetTitle').val(),
                    sheet_type: $('#sheetType').val(),
                    progress_assessment: $('#progressAssessmentText').val(),
                    progress_plan: $('#progressPlanText').val(),
                    independent_assessment: $('#progressAssessmentIndText').val(),
                    independent_plan: $('#progressPlanIndText').val(),
                    data_sheet_id: <?php echo e($sheetId); ?>,
                    progress_notes: filteredProgressAnswers,
                    progress_notes_independent: filteredProgressAnswersInd
                };
                axios.post('<?php echo e(route("portal.addSheetTaskRequest")); ?>', postData)
                    .then(function (response) {
                        if(response.data.response_code == 1){
                            successMsg(response.data.message);
                            setTimeout(function () {
                                location.href = response.data.data.redirect_url;
                            }, 1000);
                        } else {
                            errorMsg(response.data.message);
                        }
                    })
                    .catch(function (error) {

                    });
            }
        });

        // sheet type change event
        $('#sheetType').change(function (e) {
            let optionStr = $(this).find('option:selected').data('options'),
                optionArr = optionStr.split(',');
            if (optionArr.length === 2) {
                $('#noteLabel1').html('Progress Note for ' + optionArr[0] + ' case');
                $('#noteLabel2').html('Progress Note for ' + optionArr[1] + ' case');
                $('#answerPrompt').show();
            } else {
                $('#noteLabel1').html('Progress Note');
                $('#noteLabel2').html('Progress Note For Independent Prompt');
                $('#answerPrompt').hide();
            }
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/bbcareapp/resources/views/portal/dataSheets/sheetTasks/addSheetTask.blade.php ENDPATH**/ ?>