<?php $__env->startSection('title', 'Task History'); ?>
<?php $__env->startSection('headSource'); ?>
    <style>
        /*@font-face {*/
        /*    font-family: 'Elegance';*/
        /*    font-weight: normal;*/
        /*    font-style: normal;*/
        /*    font-variant: normal;*/
        /*    src: url("http://eclecticgeek.com/dompdf/fonts/Elegance.ttf") format("truetype");*/
        /*}*/

        body {
            font-size: 0.85rem;
            color: #616161;
            background: #fff !important;
        }

        .text-black {
            color: #0f0f0f !important;
        }

        p, h6 {
            margin-bottom: 2px !important;
        }

        .report-title, .sheet-title {
            padding: 20px 0px;
            text-align: center;
        }

        .report-title h4 {
            border-top: 1px solid #000;
            border-bottom: 1px dotted #000;
            padding: 10px 0;
            margin: 0;
            font-weight: 600;
            color: #0f0f0f;
        }

        .sheet-title h6 {
            padding: 5px 0;
            margin: 0;
            background: #e0e0e0;
            font-weight: 600;
            color: #0f0f0f;
        }

        footer {
            border-top: 1px solid #000;
            position: fixed;
            bottom: -60px;
            left: 0px;
            right: 0px;
            height: 50px;
            color: #333;
            text-align: center;
            line-height: 35px;
            font-size: 11px;
        }

    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <table style="width: 100%; margin-top: 10px">
        <tr>
            <td colspan="2" style="text-align: center;">

                <img src="<?php echo asset('images/pdf-logo.png'); ?>" width="190" style="margin-bottom: 20px">
            </td>
        </tr>
        <tr>
            <td colspan="2">
                <p class="text-black font-w600">Report Description</p>
            </td>
        </tr>
        <tr>
            <td style="width: 20%">
                <p class="text-black font-w600">Individual Name</p>
            </td>
            <td style="width: 80%">
                <p><?php echo e($user->name); ?></p>
            </td>
        </tr>
        <tr>
            <td>
                <p class="text-black font-w600">Date Range</p>
            </td>
            <td>
                <p><?php echo e($dateRange); ?></p>
            </td>
        </tr>
        <tr>
            <td>
                <p class="text-black font-w600">Client Number</p>
            </td>
            <td>
                <p><?php echo e($user->ddd_id); ?></p>
            </td>
        </tr>
        <tr style="height: 10px;"><td colspan="2"></td></tr>
        <tr>
            <td colspan="2" class="report-title">
                <h4 style="text-align: center;">Clinician Report</h4>
            </td>
        </tr>
    </table>
    <table style="width: 100%;">
        <?php $__currentLoopData = $reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td colspan="2" class="sheet-title">
                    <h6><?php echo e($report->sheet->name); ?> Task Sheet</h6>
                </td>
            </tr>
            <tr>
                <td style="width: 60%">
                    <p><strong class="text-black font-w600">Service Provider:</strong> <span><?php echo e(ucwords($report->staff->name)); ?></span></p>
                </td>
                <td style="text-align: right; margin-right: 20px">
                    <p><strong class="text-black font-w600">Date:</strong> <span><?php echo e(date('m/d/Y', strtotime($report->created_at))); ?></span>
                        <strong class="text-black font-w600 ml-3">Time:</strong> <span><?php echo e(date('h:i A', strtotime($report->created_at))); ?></span></p>
                </td>
            </tr>
            <tr>
                <td colspan="2">
                    <p class="text-black font-w600" style="margin-top: 10px">Progress notes:</p>
                    <?php echo $report->progress_note; ?>

                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </table>

<footer>
    <table style="width: 100%">
        <tr>
            <td style="width: 25%;font-size: 0.8rem">
                <p class="text-black font-w600">BB Care Notes</p>
            </td>
            <td style="width: 75%;text-align: right">
                <p>
                    <span class="text-black font-w600">Report Date: </span><span><?php echo e(date('m/d/Y')); ?></span>
                    <span class="text-black font-w600" style="margin-left: 10px;">Time: </span><span><?php echo e(date('h:i A')); ?></span>
                    <span class="text-black font-w600" style="margin-left: 10px;">Generated By: </span><span><?php echo e(Auth::user()->name); ?></span>
                </p>
            </td>
        </tr>
    </table>
</footer>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.content', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/bbcareapp/resources/views/portal/taskReports/clientTaskHistory.blade.php ENDPATH**/ ?>